/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TankWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.compat.emi.AdornEmiPlugin;
import juuxel.adorn.compat.emi.EmiUtil;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public record BrewingEmiRecipe(ResourceLocation id, EmiIngredient inputItem, EmiIngredient firstItemIngredient, EmiIngredient secondItemIngredient, EmiIngredient fluidIngredient, EmiStack result) implements EmiRecipe
{
    private static final int PADDING = 0;
    private static final int FLUID_SCALE_Z_OFFSET = 100;
    private static final ResourceLocation TEXTURE = AdornCommon.id("textures/gui/recipe_viewer/brewer_light.png");

    public BrewingEmiRecipe(ResourceLocation id, ItemBrewingRecipe recipe) {
        this(id, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AdornItems.MUG.get())), EmiUtil.withRemainders(EmiIngredient.of((Ingredient)recipe.firstIngredient())), EmiUtil.withRemainders(EmiIngredient.of((Ingredient)recipe.secondIngredient())), (EmiIngredient)EmiStack.EMPTY, EmiStack.of((ItemStack)recipe.result()));
    }

    public BrewingEmiRecipe(ResourceLocation id, FluidBrewingRecipe recipe) {
        this(id, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)AdornItems.MUG.get())), EmiUtil.withRemainders(EmiIngredient.of((Ingredient)recipe.firstIngredient())), EmiUtil.withRemainders(EmiIngredient.of((Ingredient)recipe.secondIngredient())), EmiUtil.emiIngredientOf(recipe.fluid()), EmiStack.of((ItemStack)recipe.result()));
    }

    public EmiRecipeCategory getCategory() {
        return AdornEmiPlugin.BREWER_CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.inputItem, this.firstItemIngredient, this.secondItemIngredient, this.fluidIngredient);
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.result);
    }

    public int getDisplayWidth() {
        return 105;
    }

    public int getDisplayHeight() {
        return 61;
    }

    public void addWidgets(WidgetHolder widgets) {
        int leftX = 0;
        int topY = 0;
        widgets.addTexture(TEXTURE, leftX, topY, 105, 61, 49, 16);
        widgets.addSlot(this.firstItemIngredient, leftX, topY).drawBack(false);
        widgets.addSlot(this.secondItemIngredient, leftX + 60, topY).drawBack(false);
        widgets.addSlot((EmiIngredient)this.result, leftX + 26, topY + 35).drawBack(false).recipeContext((EmiRecipe)this).large(true);
        long capacity = 2L * FluidBridge.get().getFluidUnit().getBucketVolume();
        widgets.add((Widget)new TankWidget(this.fluidIngredient, leftX + 87, topY, 18, 61, capacity).drawBack(false));
        widgets.addSlot(this.inputItem, leftX + 3, topY + 38).drawBack(false);
        widgets.addDrawable(leftX + 88, topY + 1, 16, 59, (context, mouseX, mouseY, tickDelta) -> context.blit(TEXTURE, 0, 0, 100, 154.0f, 17.0f, 16, 59, 256, 256));
        widgets.addDrawable(leftX + 35, topY + 8, 8, 59, (context, mouseX, mouseY, tickDelta) -> {
            float progressFraction = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
            int height = Math.round(progressFraction * 25.0f);
            context.blit(TEXTURE, 0, 0, 1, 176.0f, 0.0f, 8, height, 256, 256);
        });
    }
}

