/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.commonmixin;

import juuxel.adorn.block.PrismarineChimneyBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BubbleColumnBlock.class})
abstract class BubbleColumnBlockMixin {
    BubbleColumnBlockMixin() {
    }

    @Inject(method={"canSurvive(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanPlaceAt(BlockState state, LevelReader world, BlockPos pos, CallbackInfoReturnable<Boolean> info) {
        BlockState stateBelow = world.getBlockState(pos.below());
        if (!info.getReturnValueZ() && stateBelow.getBlock() instanceof PrismarineChimneyBlock.WithColumn) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getColumnState(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void onGetBubbleState(BlockState state, CallbackInfoReturnable<BlockState> info) {
        Block block = state.getBlock();
        if (block instanceof PrismarineChimneyBlock.WithColumn) {
            PrismarineChimneyBlock.WithColumn chimney = (PrismarineChimneyBlock.WithColumn)block;
            info.setReturnValue((Object)((BlockState)Blocks.BUBBLE_COLUMN.defaultBlockState().setValue((Property)BubbleColumnBlock.DRAG_DOWN, (Comparable)Boolean.valueOf(chimney.getDrag()))));
        }
    }
}

