/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import juuxel.adorn.block.entity.TradingStationBlockEntity;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.util.AdornUtil;
import juuxel.adorn.util.Colors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public final class TradingStationRenderer
implements BlockEntityRenderer<TradingStationBlockEntity> {
    private static final float SELLING_ROTATION_MULTIPLIER = 1.2f;
    private static final String OWNER_LABEL = "block.adorn.trading_station.label.owner";
    private static final String SELLING_LABEL = "block.adorn.trading_station.label.selling";
    private static final String PRICE_LABEL = "block.adorn.trading_station.label.price";
    private final BlockEntityRenderDispatcher dispatcher;
    private final Font textRenderer;

    public TradingStationRenderer(BlockEntityRendererProvider.Context context) {
        this.dispatcher = context.getBlockEntityRenderDispatcher();
        this.textRenderer = context.getFont();
    }

    public void render(TradingStationBlockEntity be, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        HitResult hitResult = this.dispatcher.cameraHitResult;
        boolean lookingAtBlock = hitResult != null && hitResult.getType() == HitResult.Type.BLOCK && be.getBlockPos().equals((Object)((BlockHitResult)hitResult).getBlockPos());
        Trade trade = be.getTrade();
        if (!trade.isEmpty()) {
            matrices.pushPose();
            matrices.translate(0.5, 1.2, 0.5);
            int playerAge = Minecraft.getInstance().player.tickCount;
            matrices.mulPose(Axis.YP.rotationDegrees(((float)playerAge + tickDelta) * 1.2f));
            matrices.scale(0.6f, 0.6f, 0.6f);
            matrices.translate(0.0, 0.3, 0.0);
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            itemRenderer.renderStatic(trade.getSelling(), ItemDisplayContext.FIXED, light, overlay, matrices, vertexConsumers, be.getLevel(), 0);
            matrices.popPose();
        }
        if (lookingAtBlock && ConfigManager.config().client.showTradingStationTooltips) {
            MutableComponent label1 = Component.translatable((String)OWNER_LABEL, (Object[])new Object[]{be.getOwnerName().copy().withStyle(ChatFormatting.GOLD)});
            this.renderLabel(be, (Component)label1, 0.0, 0.9, 0.0, 12, matrices, vertexConsumers, light);
            if (!be.getTrade().isEmpty()) {
                MutableComponent label2 = Component.translatable((String)SELLING_LABEL, (Object[])new Object[]{AdornUtil.toTextWithCount(be.getTrade().getSelling())});
                MutableComponent label3 = Component.translatable((String)PRICE_LABEL, (Object[])new Object[]{AdornUtil.toTextWithCount(be.getTrade().getPrice())});
                this.renderLabel(be, (Component)label2, 0.0, 0.65, 0.0, 12, matrices, vertexConsumers, light);
                this.renderLabel(be, (Component)label3, 0.0, 0.4, 0.0, 12, matrices, vertexConsumers, light);
            }
        }
    }

    private void renderLabel(BlockEntity be, Component label, double x, double y, double z, int maxDistance, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        Camera camera = this.dispatcher.camera;
        double dist = be.getBlockPos().distToCenterSqr(camera.getPosition().x, camera.getPosition().y, camera.getPosition().z);
        if (dist < (double)(maxDistance * maxDistance)) {
            matrices.pushPose();
            matrices.translate(x + 0.5, y + 1.5, z + 0.5);
            matrices.mulPose(camera.rotation());
            matrices.scale(0.025f, -0.025f, 0.025f);
            Matrix4f positionMatrix = matrices.last().pose();
            float opacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int backgroundColor = Colors.color(0, opacity);
            float textX = (float)(-this.textRenderer.width((FormattedText)label)) * 0.5f;
            this.textRenderer.drawInBatch(label, textX, 0.0f, 0x20FFFFFF, false, positionMatrix, vertexConsumers, Font.DisplayMode.SEE_THROUGH, backgroundColor, light);
            this.textRenderer.drawInBatch(label, textX, 0.0f, -1, false, positionMatrix, vertexConsumers, Font.DisplayMode.NORMAL, 0, light);
            matrices.popPose();
        }
    }
}

