/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.widget;

import juuxel.adorn.client.gui.widget.Draggable;
import juuxel.adorn.client.gui.widget.TickingElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationSupplier;

public abstract class WidgetEnvelope
implements GuiEventListener,
Renderable,
NarratableEntry,
TickingElement,
Draggable {
    protected abstract GuiEventListener current();

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        GuiEventListener guiEventListener = this.current();
        if (guiEventListener instanceof Renderable) {
            Renderable drawable = (Renderable)guiEventListener;
            drawable.render(context, mouseX, mouseY, delta);
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.current().mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.current().mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.current().mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.current().mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        return this.current().mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.current().keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.current().keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int modifiers) {
        return this.current().charTyped(chr, modifiers);
    }

    public boolean isFocused() {
        return this.current().isFocused();
    }

    public void setFocused(boolean focused) {
        this.current().setFocused(focused);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.current().isMouseOver(mouseX, mouseY);
    }

    public void updateNarration(NarrationElementOutput builder) {
        GuiEventListener guiEventListener = this.current();
        if (guiEventListener instanceof NarrationSupplier) {
            NarrationSupplier narratable = (NarrationSupplier)guiEventListener;
            narratable.updateNarration(builder);
        }
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        NarratableEntry.NarrationPriority narrationPriority;
        GuiEventListener guiEventListener = this.current();
        if (guiEventListener instanceof NarratableEntry) {
            NarratableEntry selectable = (NarratableEntry)guiEventListener;
            narrationPriority = selectable.narrationPriority();
        } else {
            narrationPriority = NarratableEntry.NarrationPriority.NONE;
        }
        return narrationPriority;
    }

    @Override
    public void tick() {
        GuiEventListener guiEventListener = this.current();
        if (guiEventListener instanceof TickingElement) {
            TickingElement ticking = (TickingElement)guiEventListener;
            ticking.tick();
        }
    }

    @Override
    public void stopDragging() {
        GuiEventListener guiEventListener = this.current();
        if (guiEventListener instanceof Draggable) {
            Draggable draggable = (Draggable)guiEventListener;
            draggable.stopDragging();
        }
    }
}

