/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.widget;

import juuxel.adorn.client.gui.Scissors;
import juuxel.adorn.client.gui.widget.WidgetEnvelope;
import net.minecraft.client.gui.GuiGraphics;

public abstract class ScissorEnvelope
extends WidgetEnvelope {
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;

    protected ScissorEnvelope(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    protected boolean isWithinScissor(double mouseX, double mouseY) {
        return (double)this.x <= mouseX && mouseX <= (double)(this.x + this.width) && (double)this.y <= mouseY && mouseY <= (double)(this.y + this.height);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY) && this.isWithinScissor(mouseX, mouseY);
    }

    protected boolean isMouseWithinScissorForInput(double x, double y) {
        return this.isWithinScissor(x, y);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (!this.isMouseWithinScissorForInput(mouseX, mouseY)) {
            return;
        }
        super.mouseMoved(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseWithinScissorForInput(mouseX, mouseY)) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.isMouseWithinScissorForInput(mouseX, mouseY)) {
            return false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!this.isMouseWithinScissorForInput(mouseX, mouseY)) {
            return false;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.isMouseWithinScissorForInput(mouseX, mouseY)) {
            return false;
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Override
    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        Scissors.push(this.x, this.y, this.width, this.height);
        super.render(context, mouseX, mouseY, delta);
        Scissors.pop();
    }
}

