/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.ClientNetworkBridge;
import juuxel.adorn.client.gui.screen.AdornMenuScreen;
import juuxel.adorn.menu.TradingStationMenu;
import juuxel.adorn.networking.SetTradeStackC2SMessage;
import juuxel.adorn.util.Logging;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public final class TradingStationScreen
extends AdornMenuScreen<TradingStationMenu> {
    private static final Logger LOGGER = Logging.logger();
    private static final ResourceLocation BACKGROUND_TEXTURE = AdornCommon.id("textures/gui/trading_station.png");
    private static final Component SELLING_LABEL = Component.translatable((String)"block.adorn.trading_station.selling");
    private static final Component PRICE_LABEL = Component.translatable((String)"block.adorn.trading_station.price");

    public TradingStationScreen(TradingStationMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageHeight = 186;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -1, false);
        context.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -1, false);
        context.drawString(this.font, SELLING_LABEL, 35 - this.font.width((FormattedText)SELLING_LABEL) / 2, 25, -1, false);
        context.drawString(this.font, PRICE_LABEL, 35 - this.font.width((FormattedText)PRICE_LABEL) / 2, 61, -1, false);
    }

    public void updateTradeStack(Slot slot, ItemStack stack) {
        if (!TradingStationMenu.isValidItem(stack)) {
            LOGGER.error("Trying to set invalid item {} for slot {} in trading station", (Object)stack, (Object)slot);
            return;
        }
        slot.setByPlayer(stack);
        ClientNetworkBridge.get().sendToServer(new SetTradeStackC2SMessage(((TradingStationMenu)this.menu).containerId, slot.index, stack));
    }
}

