/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import juuxel.adorn.client.gui.screen.AdornMenuScreen;
import juuxel.adorn.client.resources.ColorManager;
import juuxel.adorn.menu.ContainerBlockMenu;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.util.Colors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class PalettedMenuScreen<M extends AbstractContainerMenu>
extends AdornMenuScreen<M> {
    private final ResourceLocation blockId;

    public PalettedMenuScreen(M menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.blockId = BuiltInRegistries.BLOCK.getKey((Object)((Block)((ContainerBlockMenu)menu).getContext().evaluate((world, pos) -> world.getBlockState(pos).getBlock(), (Object)Blocks.AIR)));
    }

    protected abstract ResourceLocation getBackgroundTexture();

    protected abstract ResourceLocation getPaletteId();

    private ColorManager.ColorPair getPalette() {
        return PlatformBridges.get().getResources().getColorManager().getColors(this.getPaletteId()).get(this.blockId);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int bg = this.getPalette().bg();
        RenderSystem.setShaderColor((float)Colors.redOf(bg), (float)Colors.greenOf(bg), (float)Colors.blueOf(bg), (float)1.0f);
        context.blit(this.getBackgroundTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        int fg = this.getPalette().fg();
        context.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, fg, false);
        context.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, fg, false);
    }
}

