/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.book.Book;
import juuxel.adorn.client.book.Image;
import juuxel.adorn.client.book.Page;
import juuxel.adorn.client.gui.Scissors;
import juuxel.adorn.client.gui.widget.Draggable;
import juuxel.adorn.client.gui.widget.FlipBook;
import juuxel.adorn.client.gui.widget.Panel;
import juuxel.adorn.client.gui.widget.ScrollEnvelope;
import juuxel.adorn.client.gui.widget.SizedElement;
import juuxel.adorn.client.gui.widget.TickingElement;
import juuxel.adorn.util.CollectionUtil;
import juuxel.adorn.util.animation.AnimationEngine;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class GuideBookScreen
extends Screen {
    private static final int BOOK_SIZE = 192;
    private static final int PAGE_TITLE_X = 20;
    private static final int PAGE_WIDTH = 116;
    private static final int PAGE_BODY_HEIGHT = 121;
    private static final int PAGE_TITLE_WIDTH = 76;
    private static final int PAGE_TEXT_X = 4;
    private static final int PAGE_TEXT_Y = 24;
    private static final int PAGE_IMAGE_GAP = 4;
    private static final int ICON_DURATION = 25;
    private static final ResourceLocation CLOSE_BOOK_ACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_active.png");
    private static final ResourceLocation CLOSE_BOOK_INACTIVE_TEXTURE = AdornCommon.id("textures/gui/close_book_inactive.png");
    private static final int HOVER_AREA_HIGHLIGHT_COLOR = -2130706433;
    private final Book book;
    private FlipBook flipBook;
    private PageButton previousPageButton;
    private PageButton nextPageButton;
    private final AnimationEngine animationEngine = new AnimationEngine();

    public GuideBookScreen(Book book) {
        super(CommonComponents.EMPTY);
        this.book = book;
    }

    protected void init() {
        int x = (this.width - 192) / 2;
        int y = (this.height - 192) / 2;
        int pageX = x + 35;
        int pageY = y + 14;
        this.addRenderableWidget((GuiEventListener)new CloseButton(this, x + 142, y + 14, button -> this.onClose()));
        this.previousPageButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(x + 49, y + 159, false, widget -> this.flipBook.showPreviousPage(), true));
        this.nextPageButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(x + 116, y + 159, true, widget -> this.flipBook.showNextPage(), true));
        this.flipBook = (FlipBook)this.addRenderableWidget(new FlipBook(this::updatePageTurnButtons));
        this.flipBook.add(new TitlePage(pageX, pageY));
        for (Page page : this.book.pages()) {
            Panel panel = new Panel();
            panel.add(new BookPageTitle(pageX, pageY, page));
            BookPageBody body = new BookPageBody(pageX, pageY + 24, page);
            panel.add(new ScrollEnvelope(pageX, pageY + 24, 116, 121, body, this.animationEngine));
            this.flipBook.add((GuiEventListener)panel);
        }
        this.updatePageTurnButtons();
        this.animationEngine.start();
    }

    private void updatePageTurnButtons() {
        this.previousPageButton.visible = this.flipBook.hasPreviousPage();
        this.nextPageButton.visible = this.flipBook.hasNextPage();
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
        int x = (this.width - 192) / 2;
        int y = (this.height - 192) / 2;
        context.blit(BookViewScreen.BOOK_LOCATION, x, y, 0, 0, 192, 192);
    }

    public boolean handleComponentClicked(@Nullable Style style) {
        ClickEvent clickEvent;
        if (style != null && (clickEvent = style.getClickEvent()) != null && clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            int page;
            try {
                page = Integer.parseInt(clickEvent.getValue());
            }
            catch (NumberFormatException e) {
                return false;
            }
            int pageIndex = page - 1;
            if (0 <= pageIndex && pageIndex < this.flipBook.getPageCount()) {
                this.flipBook.setCurrentPage(pageIndex);
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                return true;
            }
        }
        return super.handleComponentClicked(style);
    }

    public void tick() {
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof TickingElement)) continue;
            TickingElement ticking = (TickingElement)child;
            ticking.tick();
        }
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof Draggable) {
            Draggable focused = (Draggable)guiEventListener;
            if (!this.isDragging()) {
                focused.stopDragging();
            }
        }
    }

    public void removed() {
        this.animationEngine.stop();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        GuiEventListener guiEventListener = this.flipBook.getCurrentPageValue();
        if (guiEventListener instanceof Panel) {
            Panel currentPage = (Panel)guiEventListener;
            for (GuiEventListener guiEventListener2 : currentPage.children()) {
                if (!(guiEventListener2 instanceof ScrollEnvelope)) continue;
                return guiEventListener2.keyPressed(keyCode, scanCode, modifiers);
            }
        }
        return false;
    }

    private final class CloseButton
    extends Button {
        private CloseButton(GuideBookScreen guideBookScreen, int x, int y, Button.OnPress onPress) {
            super(x, y, 8, 8, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
        }

        protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            ResourceLocation texture = this.isHovered() ? CLOSE_BOOK_ACTIVE_TEXTURE : CLOSE_BOOK_INACTIVE_TEXTURE;
            context.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    private final class TitlePage
    implements GuiEventListener,
    Renderable {
        private final int x;
        private final int y;
        private final Component byAuthor;
        private boolean focused;

        private TitlePage(int x, int y) {
            this.byAuthor = Component.translatable((String)"book.byAuthor", (Object[])new Object[]{GuideBookScreen.this.book.author()});
            this.focused = false;
            this.x = x;
            this.y = y;
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            int cx = this.x + 58;
            PoseStack matrices = context.pose();
            matrices.pushPose();
            matrices.translate((double)cx, (double)(this.y + 7 + 25), 0.0);
            matrices.scale(GuideBookScreen.this.book.titleScale(), GuideBookScreen.this.book.titleScale(), 1.0f);
            context.drawString(GuideBookScreen.this.font, GuideBookScreen.this.book.title(), -GuideBookScreen.this.font.width((FormattedText)GuideBookScreen.this.book.title()) / 2, 0, -12566464, false);
            matrices.popPose();
            context.drawString(GuideBookScreen.this.font, GuideBookScreen.this.book.subtitle(), cx - GuideBookScreen.this.font.width((FormattedText)GuideBookScreen.this.book.subtitle()) / 2, this.y + 45, -12566464, false);
            context.drawString(GuideBookScreen.this.font, this.byAuthor, cx - GuideBookScreen.this.font.width((FormattedText)this.byAuthor) / 2, this.y + 60, -12566464, false);
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }
    }

    private final class BookPageTitle
    implements GuiEventListener,
    Renderable,
    TickingElement {
        private final int x;
        private final int y;
        private final List<FormattedCharSequence> wrappedTitleLines;
        private final List<ItemStack> icons;
        private int icon = 0;
        private int iconTicks = 0;
        private boolean focused = false;

        private BookPageTitle(int x, int y, Page page) {
            this.x = x;
            this.y = y;
            this.wrappedTitleLines = GuideBookScreen.this.font.split((FormattedText)page.title().copy().withStyle(style -> style.withBold(Boolean.valueOf(true))), 76);
            this.icons = CollectionUtil.interleave(page.icons().stream().map(Page.Icon::createStacks).toList());
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            context.renderFakeItem(this.icons.get(this.icon), this.x, this.y);
            Objects.requireNonNull(GuideBookScreen.this.font);
            int titleY = this.y + 10 - 9 * this.wrappedTitleLines.size() / 2;
            for (int i = 0; i < this.wrappedTitleLines.size(); ++i) {
                FormattedCharSequence line = this.wrappedTitleLines.get(i);
                Font font = GuideBookScreen.this.font;
                Objects.requireNonNull(GuideBookScreen.this.font);
                context.drawString(font, line, this.x + 20, titleY + i * 9, -12566464, false);
            }
        }

        @Override
        public void tick() {
            if (this.iconTicks++ >= 25) {
                this.iconTicks = 0;
                this.icon = (this.icon + 1) % this.icons.size();
            }
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }
    }

    private final class BookPageBody
    implements SizedElement,
    Renderable {
        private final int x;
        private final int y;
        private final Page page;
        private final List<FormattedCharSequence> wrappedBodyLines;
        private final int textHeight;
        private final int imageHeight;
        private final int height;
        private boolean focused;

        private BookPageBody(int x, int y, Page page) {
            this.x = x;
            this.y = y;
            this.page = page;
            this.wrappedBodyLines = GuideBookScreen.this.font.split((FormattedText)page.text(), 112);
            int n = this.wrappedBodyLines.size();
            Objects.requireNonNull(GuideBookScreen.this.font);
            this.textHeight = n * 9;
            this.imageHeight = page.image() != null ? page.image().size().y() + 4 : 0;
            this.height = Math.max(121, this.textHeight + this.imageHeight);
        }

        @Override
        public int getWidth() {
            return 116;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return (double)this.x <= mouseX && mouseX <= (double)(this.x + GuideBookScreen.this.width) && (double)this.y <= mouseY && mouseY <= (double)(this.y + this.height);
        }

        @Nullable
        private Style getTextStyleAt(int x, int y) {
            if (!this.isMouseOver(x, y)) {
                return null;
            }
            int wx = x - (this.x + 4);
            int wy = y - this.y;
            Objects.requireNonNull(GuideBookScreen.this.font);
            int lineIndex = wy / 9;
            if (0 <= lineIndex && lineIndex < this.wrappedBodyLines.size()) {
                FormattedCharSequence line = this.wrappedBodyLines.get(lineIndex);
                return GuideBookScreen.this.font.getSplitter().componentStyleAtWidth(line, wx);
            }
            return null;
        }

        public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
            int textYOffset = this.page.image() != null && this.page.image().placement() == Image.Placement.BEFORE_TEXT ? this.imageHeight : 0;
            for (int i = 0; i < this.wrappedBodyLines.size(); ++i) {
                FormattedCharSequence line = this.wrappedBodyLines.get(i);
                Font font = GuideBookScreen.this.font;
                Objects.requireNonNull(GuideBookScreen.this.font);
                context.drawString(font, line, this.x + 4, textYOffset + this.y + i * 9, -12566464, false);
            }
            if (this.page.image() != null) {
                this.renderImage(context, this.page.image(), mouseX, mouseY);
            }
            Style hoveredStyle = this.getTextStyleAt(mouseX, mouseY);
            Scissors.suspendScissors(() -> context.renderComponentHoverEffect(GuideBookScreen.this.font, hoveredStyle, mouseX, mouseY));
        }

        private void renderImage(GuiGraphics context, Image image, int mouseX, int mouseY) {
            int imageX = this.x + (116 - image.size().x()) / 2;
            int imageY = switch (image.placement()) {
                default -> throw new MatchException(null, null);
                case Image.Placement.BEFORE_TEXT -> this.y;
                case Image.Placement.AFTER_TEXT -> this.y + this.textHeight + 4;
            };
            RenderSystem.enableBlend();
            context.blit(image.location(), imageX, imageY, 0.0f, 0.0f, image.size().x(), image.size().y(), image.size().x(), image.size().y());
            RenderSystem.disableBlend();
            for (Image.HoverArea hoverArea : image.hoverAreas()) {
                if (!hoverArea.contains(mouseX - imageX, mouseY - imageY)) continue;
                int hX = imageX + hoverArea.position().x();
                int hY = imageY + hoverArea.position().y();
                context.fill(hX, hY, hX + hoverArea.size().x(), hY + hoverArea.size().y(), -2130706433);
                List wrappedTooltip = GuideBookScreen.this.font.split((FormattedText)hoverArea.tooltip(), 116);
                Scissors.suspendScissors(() -> context.renderTooltip(GuideBookScreen.this.font, wrappedTooltip, mouseX, mouseY));
                break;
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            Style style;
            if (button == 0 && (style = this.getTextStyleAt((int)mouseX, (int)mouseY)) != null && GuideBookScreen.this.handleComponentClicked(style)) {
                return true;
            }
            return SizedElement.super.mouseClicked(mouseX, mouseY, button);
        }

        public boolean isFocused() {
            return this.focused;
        }

        public void setFocused(boolean focused) {
            this.focused = focused;
        }
    }
}

