/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;

public final class Scissors {
    private static final Deque<Frame> STACK = new ArrayDeque<Frame>();

    public static void push(int x, int y, int width, int height) {
        Scissors.push(new Frame(x, y, x + width, y + height));
    }

    public static void push(Frame frame) {
        STACK.addLast(frame);
        Scissors.apply();
    }

    public static Frame pop() {
        Frame frame = STACK.removeLast();
        Scissors.apply();
        return frame;
    }

    public static void suspendScissors(Runnable fn) {
        Frame frame = Scissors.pop();
        fn.run();
        Scissors.push(frame);
    }

    private static void apply() {
        if (STACK.isEmpty()) {
            RenderSystem.disableScissor();
            return;
        }
        Window window = Minecraft.getInstance().getWindow();
        int x1 = 0;
        int y1 = 0;
        int x2 = window.getGuiScaledWidth();
        int y2 = window.getGuiScaledHeight();
        for (Frame frame : STACK) {
            x1 = Math.max(x1, frame.x1);
            y1 = Math.max(y1, frame.y1);
            x2 = Math.min(x2, frame.x2);
            y2 = Math.min(y2, frame.y2);
        }
        double scale = window.getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)x1 * scale)), (int)((int)((double)window.getHeight() - scale * (double)y2)), (int)((int)((double)(x2 - x1) * scale)), (int)((int)((double)(y2 - y1) * scale)));
    }

    public record Frame(int x1, int y1, int x2, int y2) {
    }
}

