/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import juuxel.adorn.client.book.Image;
import juuxel.adorn.util.EntryOrTag;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record Page(List<Icon> icons, Component title, Component text, @Nullable Image image) {
    public static final Codec<Page> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Icon.CODEC.listOf().fieldOf("icons").forGetter(Page::icons), (App)ComponentSerialization.CODEC.fieldOf("title").forGetter(Page::title), (App)ComponentSerialization.CODEC.optionalFieldOf("text", (Object)Component.empty()).forGetter(Page::text), (App)Image.CODEC.optionalFieldOf("image").forGetter(page -> Optional.ofNullable(page.image))).apply((Applicative)instance, Page::new));

    private Page(List<Icon> icons, Component title, Component text, Optional<Image> image) {
        this(icons, title, text, (Image)image.orElse(null));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Icon> icons = new ArrayList<Icon>();
        @Nullable
        private Component title;
        @Nullable
        private Component text;
        @Nullable
        private Image image;

        private Builder() {
        }

        public Builder icon(ItemLike item) {
            this.icons.add(new Icon(new EntryOrTag.OfEntry<Item>(item.asItem())));
            return this;
        }

        public Builder icon(TagKey<Item> tag) {
            this.icons.add(new Icon(new EntryOrTag.OfTag<Item>(tag)));
            return this;
        }

        public Builder title(Component title) {
            this.title = title;
            return this;
        }

        public Builder content(Component text) {
            this.text = text;
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public Page build() {
            if (this.icons.isEmpty()) {
                throw new IllegalArgumentException("Page has no icons");
            }
            Objects.requireNonNull(this.title);
            Objects.requireNonNull(this.text);
            return new Page(this.icons, this.title, this.text, this.image);
        }
    }

    public record Icon(EntryOrTag<Item> items) {
        public static final Codec<Icon> CODEC = EntryOrTag.codec(Registries.ITEM).xmap(Icon::new, Icon::items);

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<ItemStack> createStacks() {
            TagKey tag;
            List<ItemStack> list;
            EntryOrTag<Item> entryOrTag = this.items;
            Objects.requireNonNull(entryOrTag);
            EntryOrTag<Item> entryOrTag2 = entryOrTag;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntryOrTag.OfEntry.class, EntryOrTag.OfTag.class}, entryOrTag2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Item item2;
                    EntryOrTag.OfEntry ofEntry = (EntryOrTag.OfEntry)entryOrTag2;
                    try {
                        Item item;
                        item2 = item = (Item)ofEntry.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    list = List.of(item2.getDefaultInstance());
                    return list;
                }
                case 1: 
            }
            EntryOrTag.OfTag ofTag = (EntryOrTag.OfTag)entryOrTag2;
            {
                TagKey tagKey;
                tag = tagKey = ofTag.tag();
            }
            HolderSet.Named entries = BuiltInRegistries.ITEM.getOrCreateTag(tag);
            ArrayList<ItemStack> result = new ArrayList<ItemStack>(entries.size());
            Iterator iterator = entries.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    list = result;
                    return list;
                }
                Holder entry = (Holder)iterator.next();
                result.add(((Item)entry.value()).getDefaultInstance());
            }
        }
    }
}

