/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import juuxel.adorn.util.Vec2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;

public record Image(ResourceLocation location, Vec2i size, Placement placement, List<HoverArea> hoverAreas) {
    public static final Codec<Image> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(Image::location), (App)Vec2i.CODEC.fieldOf("size").forGetter(Image::size), (App)Placement.CODEC.optionalFieldOf("placement", (Object)Placement.AFTER_TEXT).forGetter(Image::placement), (App)HoverArea.CODEC.listOf().optionalFieldOf("hoverAreas", List.of()).forGetter(Image::hoverAreas)).apply((Applicative)instance, Image::new));

    public static enum Placement {
        BEFORE_TEXT("beforeText"),
        AFTER_TEXT("afterText");

        private static final Map<String, Placement> BY_ID;
        public static final Codec<Placement> CODEC;
        private final String id;

        private Placement(String id) {
            this.id = id;
        }

        static {
            BY_ID = Arrays.stream(Placement.values()).map(placement -> Pair.of((Object)placement.id, (Object)placement)).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            CODEC = Codec.STRING.xmap(BY_ID::get, placement -> placement.id);
        }
    }

    public record HoverArea(Vec2i position, Vec2i size, Component tooltip) {
        public static final Codec<HoverArea> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Vec2i.CODEC.fieldOf("position").forGetter(HoverArea::position), (App)Vec2i.CODEC.fieldOf("size").forGetter(HoverArea::size), (App)ComponentSerialization.CODEC.fieldOf("tooltip").forGetter(HoverArea::tooltip)).apply((Applicative)instance, HoverArea::new));

        public boolean contains(int x, int y) {
            return this.position.x() <= x && x <= this.position.x() + this.size.x() && this.position.y() <= y && y <= this.position.y() + this.size.y();
        }
    }
}

