/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import juuxel.adorn.client.book.Page;
import juuxel.adorn.client.book.PageTreeBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public record Book(Component title, Component subtitle, Component author, List<Page> pages, float titleScale) {
    public static final Codec<Book> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("title").forGetter(Book::title), (App)ComponentSerialization.CODEC.fieldOf("subtitle").forGetter(Book::subtitle), (App)ComponentSerialization.CODEC.fieldOf("author").forGetter(Book::author), (App)Page.CODEC.listOf().fieldOf("pages").forGetter(Book::pages), (App)Codec.FLOAT.fieldOf("titleScale").forGetter(Book::titleScale)).apply((Applicative)instance, Book::new));

    public static Builder builder() {
        return new Builder();
    }

    public static MutableComponent jumpToPage(MutableComponent text, int page) {
        return text.withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, Integer.toString(page))).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"guide.adorn.contents.jump_to_page", (Object[])new Object[]{page}).withStyle(ChatFormatting.ITALIC))));
    }

    public static final class Builder {
        @Nullable
        private Component title;
        @Nullable
        private Component subtitle;
        @Nullable
        private Component author;
        private final List<Page> pages = new ArrayList<Page>();
        private float titleScale = 1.0f;

        private Builder() {
        }

        public Builder title(Component title) {
            this.title = title;
            return this;
        }

        public Builder subtitle(Component subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder author(Component author) {
            this.author = author;
            return this;
        }

        public Builder page(Page page) {
            this.pages.add(page);
            return this;
        }

        public Builder pageTree(UnaryOperator<PageTreeBuilder> builderOp) {
            this.pages.addAll(((PageTreeBuilder)builderOp.apply(new PageTreeBuilder(this.pages.size() + 2))).build());
            return this;
        }

        public Builder titleScale(float titleScale) {
            this.titleScale = titleScale;
            return this;
        }

        public Book build() {
            Objects.requireNonNull(this.title);
            Objects.requireNonNull(this.subtitle);
            Objects.requireNonNull(this.author);
            return new Book(this.title, this.subtitle, this.author, List.copyOf(this.pages), this.titleScale);
        }
    }
}

