/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.property;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public final class OptionalProperty<T extends Enum<T>>
extends Property<Value<T>> {
    private static final String NONE_NAME = "none";
    private final EnumProperty<T> delegate;
    private final Value.None<T> none = new Value.None();
    private final Map<@Nullable T, Value<T>> values;

    public OptionalProperty(EnumProperty<T> delegate) {
        super(delegate.getName(), Value.class);
        this.delegate = delegate;
        this.values = new HashMap<T, Value<T>>();
        this.values.put(null, this.none);
        for (Enum value : delegate.getPossibleValues()) {
            if (NONE_NAME.equals(((StringRepresentable)value).getSerializedName())) {
                throw new IllegalArgumentException("Delegate has a 'none' value");
            }
            this.values.put(value, new Value.Some<Enum>(value));
        }
    }

    public Optional<Value<T>> getValue(String name) {
        return NONE_NAME.equals(name) ? Optional.of(this.none) : this.delegate.getValue(name).map(x$0 -> (Value)this.values.get(x$0));
    }

    public Collection<Value<T>> getPossibleValues() {
        return this.values.values();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String name(Value<T> value) {
        Object inner;
        if (!(value instanceof Value.Some)) return NONE_NAME;
        Value.Some some = (Value.Some)value;
        try {
            Object object;
            inner = object = some.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        String string = ((StringRepresentable)inner).getSerializedName();
        return string;
    }

    public EnumProperty<T> getDelegate() {
        return this.delegate;
    }

    public Value.None<T> getNone() {
        return this.none;
    }

    @Nullable
    public Value<T> wrap(@Nullable T value) {
        return this.values.get(value);
    }

    public Value<T> wrapOrNone(@Nullable T value) {
        return this.values.getOrDefault(value, this.none);
    }

    public static sealed interface Value<T>
    extends Comparable<Value<T>> {
        public boolean isPresent();

        @Nullable
        public T value();

        public static final class None<T extends Enum<T>>
        implements Value<T> {
            @Override
            @Nullable
            public T value() {
                return null;
            }

            @Override
            public boolean isPresent() {
                return false;
            }

            @Override
            public int compareTo(Value<T> o) {
                return o instanceof None ? 0 : -1;
            }
        }

        public static final class Some<T extends Enum<T>>
        extends Record
        implements Value<T> {
            private final T value;

            public Some(T value) {
                this.value = value;
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int compareTo(Value<T> o) {
                Value<T> value = o;
                Objects.requireNonNull(value);
                Value<T> value2 = value;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, value2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Some some = (Some)value2;
                        try {
                            Object object;
                            Object otherValue = object = some.value();
                            int n2 = ((Enum)this.value).compareTo((Object)otherValue);
                            return n2;
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                    case 1: 
                }
                None none = (None)value2;
                return 1;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Some.class, "value", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Some.class, "value", "value"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Some.class, "value", "value"}, this, o);
            }

            @Override
            public T value() {
                return this.value;
            }
        }
    }
}

