/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import java.util.Objects;
import java.util.UUID;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.entity.TradingStation;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.menu.TradingStationMenu;
import juuxel.adorn.trading.Trade;
import juuxel.adorn.trading.TradeOwner;
import juuxel.adorn.util.AdornUtil;
import juuxel.adorn.util.InventoryComponent;
import juuxel.adorn.util.NbtUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class TradingStationBlockEntity
extends BlockEntity
implements MenuProvider,
TradingStation {
    public static final int STORAGE_SIZE = 12;
    public static final String NBT_TRADING_OWNER = "TradingOwner";
    public static final String NBT_TRADING_OWNER_NAME = "TradingOwnerName";
    public static final String NBT_TRADE = "Trade";
    public static final String NBT_STORAGE = "Storage";
    public static final Component UNKNOWN_OWNER = Component.literal((String)"???");
    @Nullable
    private UUID owner = null;
    private Component ownerName = UNKNOWN_OWNER;
    private final Trade trade = Trade.empty();
    private final InventoryComponent storage = new InventoryComponent(12);

    public TradingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AdornBlockEntities.TRADING_STATION.get(), pos, state);
        this.trade.addListener(sender -> this.setChanged());
        this.storage.addListener(sender -> this.setChanged());
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
    }

    public void setOwner(Player player) {
        this.owner = player.getGameProfile().getId();
        this.ownerName = Component.literal((String)player.getGameProfile().getName());
        this.setChanged();
    }

    public boolean isStorageStocked() {
        return this.storage.getCountWithComponents(this.trade.getSelling()) >= this.trade.getSelling().getCount();
    }

    public boolean isOwner(Player player) {
        return player.getGameProfile().getId().equals(this.owner);
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new TradingStationMenu(syncId, playerInventory, AdornUtil.menuContextOf(this));
    }

    public Component getDisplayName() {
        return this.getBlockState().getBlock().getName();
    }

    @Override
    public Component getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(Component ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public Trade getTrade() {
        return this.trade;
    }

    @Override
    public InventoryComponent getStorage() {
        return this.storage;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.hasUUID(NBT_TRADING_OWNER)) {
            this.owner = nbt.getUUID(NBT_TRADING_OWNER);
        }
        this.ownerName = Objects.requireNonNullElse(NbtUtil.getText(nbt, NBT_TRADING_OWNER_NAME, registries), UNKNOWN_OWNER);
        this.trade.readNbt(nbt.getCompound(NBT_TRADE), registries);
        this.storage.readNbt(nbt.getCompound(NBT_STORAGE), registries);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.owner != null) {
            nbt.putUUID(NBT_TRADING_OWNER, this.owner);
        }
        NbtUtil.putText(nbt, NBT_TRADING_OWNER_NAME, this.ownerName, registries);
        nbt.put(NBT_TRADE, (Tag)this.trade.writeNbt(new CompoundTag(), registries));
        nbt.put(NBT_STORAGE, (Tag)this.storage.writeNbt(new CompoundTag(), registries));
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.trade.copyFrom((Trade)components.get((DataComponentType)AdornComponentTypes.TRADE.get()));
        this.storage.copyFrom((ItemContainerContents)components.get(DataComponents.CONTAINER));
        TradeOwner owner = (TradeOwner)components.get((DataComponentType)AdornComponentTypes.TRADE_OWNER.get());
        if (owner != null) {
            this.owner = owner.uuid();
            this.ownerName = owner.name();
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)AdornComponentTypes.TRADE.get(), (Object)this.trade);
        builder.set(DataComponents.CONTAINER, (Object)this.storage.toContainerComponent());
        if (this.owner != null) {
            builder.set((DataComponentType)AdornComponentTypes.TRADE_OWNER.get(), (Object)new TradeOwner(this.owner, this.ownerName));
        }
    }

    public void removeComponentsFromTag(CompoundTag nbt) {
        super.removeComponentsFromTag(nbt);
        nbt.remove(NBT_TRADE);
        nbt.remove(NBT_STORAGE);
        nbt.remove(NBT_TRADING_OWNER);
        nbt.remove(NBT_TRADING_OWNER_NAME);
    }
}

