/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BrewerBlock;
import juuxel.adorn.block.entity.BaseContainerBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.menu.BrewerMenu;
import juuxel.adorn.platform.ItemBridge;
import juuxel.adorn.recipe.AdornRecipeTypes;
import juuxel.adorn.recipe.BrewerInput;
import juuxel.adorn.recipe.BrewingRecipe;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.InventoryWrappingRecipeInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class BrewerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final String NBT_PROGRESS = "Progress";
    public static final int CONTAINER_SIZE = 4;
    public static final int INPUT_SLOT = 0;
    public static final int LEFT_INGREDIENT_SLOT = 1;
    public static final int RIGHT_INGREDIENT_SLOT = 2;
    public static final int FLUID_CONTAINER_SLOT = 3;
    public static final int MAX_PROGRESS = 200;
    public static final int FLUID_CAPACITY_IN_BUCKETS = 2;
    private int progress = 0;
    private final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property: " + index);
                }
            }
            return BrewerBlockEntity.this.progress;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    BrewerBlockEntity.this.progress = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property: " + index);
                }
            }
        }

        public int getCount() {
            return 1;
        }
    };

    public BrewerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AdornBlockEntities.BREWER.get(), pos, state, 4);
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory inv) {
        return new BrewerMenu(syncId, inv, (Container)this, this.propertyDelegate, this.getFluidReference());
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putInt(NBT_PROGRESS, this.progress);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.progress = nbt.getInt(NBT_PROGRESS);
    }

    public int[] getSlotsForFace(Direction side) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)BrewerBlock.FACING);
        if (side == facing.getClockWise()) {
            return new int[]{1};
        }
        if (side == facing.getCounterClockWise()) {
            return new int[]{2};
        }
        if (side == facing.getOpposite()) {
            return new int[]{3};
        }
        if (side == Direction.UP) {
            return new int[]{0};
        }
        if (side == Direction.DOWN) {
            return new int[]{0, 3};
        }
        return new int[0];
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (!(slot != 0 || stack.is((Item)AdornItems.MUG.get()) && this.getItem(slot).isEmpty())) {
            return false;
        }
        return slot != 3 || this.getItem(slot).isEmpty();
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, @Nullable Direction dir) {
        return dir != Direction.DOWN && this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return dir == Direction.DOWN && (slot != 3 || this.canExtractFluidContainer());
    }

    public int calculateComparatorOutput() {
        ItemStack mugStack = this.getItem(0);
        if (!mugStack.isEmpty() && !mugStack.is((Item)AdornItems.MUG.get())) {
            return 15;
        }
        float progressFraction = (float)this.progress / 200.0f;
        float level = progressFraction * 14.0f;
        return Mth.ceil((float)level);
    }

    public abstract FluidReference getFluidReference();

    protected abstract boolean canExtractFluidContainer();

    protected abstract void tryExtractFluidContainer();

    private boolean isActive() {
        return this.progress != 0;
    }

    private static void decrementIngredient(BrewerBlockEntity brewer, int slot) {
        ItemStack stack = brewer.getItem(slot);
        ItemStack remainder = ItemBridge.get().getRecipeRemainder(stack);
        stack.shrink(1);
        if (!remainder.isEmpty()) {
            if (stack.isEmpty()) {
                brewer.setItem(slot, remainder);
            } else {
                Containers.dropItemStack((Level)brewer.level, (double)((double)brewer.worldPosition.getX() + 0.5), (double)((double)brewer.worldPosition.getY() + 0.5), (double)((double)brewer.worldPosition.getZ() + 0.5), (ItemStack)remainder);
            }
        }
    }

    public static void tick(Level world, BlockPos pos, BlockState state, BrewerBlockEntity brewer) {
        boolean hasMug;
        boolean originallyActive = brewer.isActive();
        brewer.tryExtractFluidContainer();
        boolean dirty = false;
        boolean bl = hasMug = !brewer.getItem(0).isEmpty();
        if (hasMug != (Boolean)state.getValue((Property)BrewerBlock.HAS_MUG)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BrewerBlock.HAS_MUG, (Comparable)Boolean.valueOf(hasMug)));
        }
        RecipeInputImpl input = new RecipeInputImpl(brewer);
        BrewingRecipe recipe = world.getRecipeManager().getRecipeFor((RecipeType)AdornRecipeTypes.BREWING.get(), (RecipeInput)input, world).map(RecipeHolder::value).orElse(null);
        if (recipe != null && brewer.getItem(0).is((Item)AdornItems.MUG.get())) {
            if (brewer.progress++ >= 200) {
                BrewerBlockEntity.decrementIngredient(brewer, 1);
                BrewerBlockEntity.decrementIngredient(brewer, 2);
                brewer.setItem(0, recipe.assemble(input, (HolderLookup.Provider)world.registryAccess()));
                if (recipe instanceof FluidBrewingRecipe) {
                    FluidBrewingRecipe fluidRecipe = (FluidBrewingRecipe)recipe;
                    brewer.getFluidReference().decrement(fluidRecipe.fluid().amount(), fluidRecipe.fluid().unit());
                }
            }
            dirty = true;
        } else if (brewer.progress != 0) {
            brewer.progress = 0;
            dirty = true;
        }
        boolean activeNow = brewer.isActive();
        if (originallyActive != activeNow) {
            dirty = true;
            BlockState newState = (BlockState)state.setValue((Property)BrewerBlock.ACTIVE, (Comparable)Boolean.valueOf(activeNow));
            world.setBlockAndUpdate(pos, newState);
        }
        if (dirty) {
            BrewerBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    private static final class RecipeInputImpl
    extends InventoryWrappingRecipeInput<BrewerBlockEntity>
    implements BrewerInput {
        private RecipeInputImpl(BrewerBlockEntity brewer) {
            super(brewer);
        }

        @Override
        public FluidReference getFluidReference() {
            return ((BrewerBlockEntity)this.parent).getFluidReference();
        }
    }
}

