/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.Map;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.util.Shapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class TableLampBlock
extends Block
implements SimpleWaterloggedBlock,
BlockWithDescription {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final String DESCRIPTION_KEY = "block.adorn.table_lamp.description";
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.buildShapeRotationsFromNorth(3, 3, 2, 13, 13, 16);

    public TableLampBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT, WATERLOGGED, FACING});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            world.setBlockAndUpdate(pos, AdornBlocks.TABLE_LAMPS.getEager(dye.getDyeColor()).withPropertiesOf(state));
            world.playSound(player, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (!world.isClientSide) {
                player.awardStat(AdornStats.DYE_TABLE_LAMP);
            }
        } else {
            Boolean wasLit = (Boolean)state.getValue((Property)LIT);
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(wasLit == false)));
            float pitch = wasLit != false ? 0.5f : 0.6f;
            world.playSound(player, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, pitch);
            if (!world.isClientSide) {
                player.awardStat(AdornStats.INTERACT_WITH_TABLE_LAMP);
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)ctx.getClickedFace());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public static BlockBehaviour.Properties createBlockSettings(DyeColor color) {
        return BlockBehaviour.Properties.of().mapColor(color).forceSolidOn().destroyTime(0.3f).explosionResistance(0.3f).sound(SoundType.WOOL).lightLevel(state -> (Boolean)state.getValue((Property)LIT) != false ? 15 : 0);
    }

    static {
        SHAPES.put(Direction.UP, TableLampBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0));
        SHAPES.put(Direction.DOWN, TableLampBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
    }
}

