/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.ArrayList;
import juuxel.adorn.block.AbstractTableBlock;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.variant.BlockVariant;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class TableBlock
extends AbstractTableBlock
implements BlockWithDescription {
    private static final String DESCRIPTION_KEY = "block.adorn.table.description";
    private static final VoxelShape[] SHAPES;

    public TableBlock(BlockVariant variant) {
        super(TableBlock.createSettings(variant));
    }

    private static BlockBehaviour.Properties createSettings(BlockVariant variant) {
        return variant.createSettings().forceSolidOn();
    }

    @Override
    @Nullable
    public ResourceLocation getSittingStat() {
        return null;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    @Override
    protected boolean isSittingEnabled() {
        return false;
    }

    @Override
    protected boolean canConnectTo(BlockState state, Direction sideOfSelf) {
        return state.getBlock() instanceof TableBlock;
    }

    @Override
    protected VoxelShape getShapeForKey(int key) {
        return SHAPES[key];
    }

    private static VoxelShape makeShape(boolean north, boolean east, boolean south, boolean west, boolean hasCarpet, VoxelShape topShape, VoxelShape legX0Z0, VoxelShape legX1Z0, VoxelShape legX0Z1, VoxelShape legX1Z1) {
        ArrayList<VoxelShape> parts = new ArrayList<VoxelShape>();
        parts.add(topShape);
        if (north || east || south || west) {
            int trueCount = 0;
            if (north) {
                ++trueCount;
            }
            if (east) {
                ++trueCount;
            }
            if (south) {
                ++trueCount;
            }
            if (west) {
                ++trueCount;
            }
            if (trueCount == 2) {
                if (north && west) {
                    parts.add(legX1Z1);
                } else if (north && east) {
                    parts.add(legX0Z1);
                } else if (south && west) {
                    parts.add(legX1Z0);
                } else if (south && east) {
                    parts.add(legX0Z0);
                }
            } else if (trueCount == 1) {
                if (north) {
                    parts.add(legX0Z1);
                    parts.add(legX1Z1);
                } else if (south) {
                    parts.add(legX0Z0);
                    parts.add(legX1Z0);
                } else if (east) {
                    parts.add(legX0Z0);
                    parts.add(legX0Z1);
                } else {
                    parts.add(legX1Z0);
                    parts.add(legX1Z1);
                }
            }
        } else {
            parts.add(legX0Z0);
            parts.add(legX1Z0);
            parts.add(legX0Z1);
            parts.add(legX1Z1);
        }
        if (hasCarpet) {
            parts.add(CARPET_SHAPE);
        }
        return (VoxelShape)parts.stream().reduce(Shapes::or).get();
    }

    static {
        boolean[] booleans;
        SHAPES = new VoxelShape[32];
        VoxelShape topShape = TableBlock.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape legX0Z0 = TableBlock.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0);
        VoxelShape legX1Z0 = TableBlock.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0);
        VoxelShape legX0Z1 = TableBlock.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0);
        VoxelShape legX1Z1 = TableBlock.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0);
        for (boolean north : booleans = new boolean[]{true, false}) {
            for (boolean east : booleans) {
                for (boolean south : booleans) {
                    for (boolean west : booleans) {
                        for (boolean hasCarpet : booleans) {
                            VoxelShape shape;
                            int key = TableBlock.getShapeKey(north, east, south, west, hasCarpet);
                            TableBlock.SHAPES[key] = shape = TableBlock.makeShape(north, east, south, west, hasCarpet, topShape, legX0Z0, legX1Z0, legX0Z1, legX1Z1);
                        }
                    }
                }
            }
        }
    }
}

