/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.ArrayList;
import java.util.Map;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.block.SneakClickHandler;
import juuxel.adorn.block.property.FrontConnection;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.lib.AdornStats;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SofaBlock
extends SeatBlock
implements SimpleWaterloggedBlock,
SneakClickHandler,
BlockWithDescription {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty CONNECTED_LEFT = BooleanProperty.create((String)"connected_left");
    public static final BooleanProperty CONNECTED_RIGHT = BooleanProperty.create((String)"connected_right");
    public static final EnumProperty<FrontConnection> FRONT_CONNECTION = EnumProperty.create((String)"front", FrontConnection.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape[] OUTLINE_SHAPES = SofaBlock.buildShapes(false);
    private static final VoxelShape[] COLLISION_SHAPES = SofaBlock.buildShapes(true);
    private static final String DESCRIPTION_KEY = "block.adorn.sofa.description";

    public SofaBlock(BlockVariant variant) {
        super(variant.createSettings());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FRONT_CONNECTION, (Comparable)((Object)FrontConnection.NONE))).setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ResourceLocation getSittingStat() {
        return AdornStats.SIT_ON_SOFA;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            world.setBlockAndUpdate(pos, AdornBlocks.SOFAS.getEager(dye.getDyeColor()).withPropertiesOf(state));
            world.playSound(player, pos, SoundEvents.WOOL_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (!world.isClientSide) {
                player.awardStat(AdornStats.DYE_SOFA);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    @Override
    public InteractionResult onSneakClick(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Direction sleepingDirection = SofaBlock.getSleepingDirection((BlockGetter)world, pos);
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"block.adorn.sofa.occupied"), true);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (BedBlock.canSetSpawn((Level)world) && sleepingDirection != null) {
            if (!world.isClientSide) {
                player.startSleepInBed(pos).ifLeft(reason -> {
                    if (reason.getMessage() != null) {
                        player.displayClientMessage(reason.getMessage(), true);
                    }
                });
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, CONNECTED_LEFT, CONNECTED_RIGHT, FRONT_CONNECTION, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.updateConnections((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER)), (LevelAccessor)ctx.getLevel(), ctx.getClickedPos());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.updateConnections(state, world, pos);
    }

    private BlockState updateConnections(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState leftState = world.getBlockState(pos.relative(direction.getClockWise()));
        BlockState rightState = world.getBlockState(pos.relative(direction.getCounterClockWise()));
        BlockState frontState = world.getBlockState(pos.relative(direction));
        boolean connectedLeft = leftState.getBlock() instanceof SofaBlock && (leftState.getValue((Property)FACING) == direction || leftState.getValue((Property)FACING) == direction.getCounterClockWise() && leftState.getValue(FRONT_CONNECTION) != FrontConnection.NONE);
        boolean connectedRight = rightState.getBlock() instanceof SofaBlock && (rightState.getValue((Property)FACING) == direction || rightState.getValue((Property)FACING) == direction.getClockWise() && rightState.getValue(FRONT_CONNECTION) != FrontConnection.NONE);
        boolean connectedFront = frontState.getBlock() instanceof SofaBlock;
        boolean connectedFrontLeft = connectedFront && !connectedLeft && frontState.getValue((Property)FACING) == direction.getCounterClockWise();
        boolean connectedFrontRight = connectedFront && !connectedRight && frontState.getValue((Property)FACING) == direction.getClockWise();
        FrontConnection frontConnection = FrontConnection.NONE;
        if (connectedFrontLeft) {
            frontConnection = FrontConnection.LEFT;
        } else if (connectedFrontRight) {
            frontConnection = FrontConnection.RIGHT;
        }
        return (BlockState)((BlockState)((BlockState)state.setValue((Property)CONNECTED_LEFT, (Comparable)Boolean.valueOf(connectedLeft))).setValue((Property)CONNECTED_RIGHT, (Comparable)Boolean.valueOf(connectedRight))).setValue(FRONT_CONNECTION, (Comparable)((Object)frontConnection));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return OUTLINE_SHAPES[SofaBlock.getShapeKey((Direction)state.getValue((Property)FACING), (Boolean)state.getValue((Property)CONNECTED_LEFT), (Boolean)state.getValue((Property)CONNECTED_RIGHT), (FrontConnection)((Object)state.getValue(FRONT_CONNECTION)))];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPES[SofaBlock.getShapeKey((Direction)state.getValue((Property)FACING), (Boolean)state.getValue((Property)CONNECTED_LEFT), (Boolean)state.getValue((Property)CONNECTED_RIGHT), (FrontConnection)((Object)state.getValue(FRONT_CONNECTION)))];
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Override
    public double getSittingOffset(Level world, BlockState state, BlockPos pos) {
        return 0.4375;
    }

    private static VoxelShape[] buildShapes(boolean thin) {
        VoxelShape bottom = SofaBlock.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
        Map<Direction, VoxelShape> leftArms = juuxel.adorn.util.Shapes.buildShapeRotations(5, 7, 13, 16, 13, 16);
        Map<Direction, VoxelShape> rightArms = juuxel.adorn.util.Shapes.buildShapeRotations(5, 7, 0, 16, 13, 3);
        Map<Direction, VoxelShape> thinLeftArms = juuxel.adorn.util.Shapes.buildShapeRotations(5, 7, 14, 16, 13, 16);
        Map<Direction, VoxelShape> thinRightArms = juuxel.adorn.util.Shapes.buildShapeRotations(5, 7, 0, 16, 13, 2);
        Map<Direction, VoxelShape> backs = juuxel.adorn.util.Shapes.buildShapeRotations(0, 7, 0, 5, 16, 16);
        Map<Direction, VoxelShape> leftCorners = juuxel.adorn.util.Shapes.buildShapeRotations(5, 7, 11, 16, 16, 16);
        Map<Direction, VoxelShape> rightCorners = juuxel.adorn.util.Shapes.buildShapeRotations(5, 7, 0, 16, 16, 5);
        boolean[] booleans = new boolean[]{true, false};
        VoxelShape[] result = new VoxelShape[48];
        for (Direction facing : FACING.getPossibleValues()) {
            for (boolean left : booleans) {
                for (boolean right : booleans) {
                    for (FrontConnection front : FRONT_CONNECTION.getPossibleValues()) {
                        VoxelShape shape;
                        ArrayList<VoxelShape> parts = new ArrayList<VoxelShape>();
                        parts.add(backs.get(facing));
                        if (!left && front == FrontConnection.NONE) {
                            parts.add(thin ? thinLeftArms.get(facing) : leftArms.get(facing));
                        }
                        if (!right && front == FrontConnection.NONE) {
                            parts.add(thin ? thinRightArms.get(facing) : rightArms.get(facing));
                        }
                        switch (front) {
                            case LEFT: {
                                parts.add(leftCorners.get(facing));
                                break;
                            }
                            case RIGHT: {
                                parts.add(rightCorners.get(facing));
                            }
                        }
                        int key = SofaBlock.getShapeKey(facing, left, right, front);
                        result[key] = shape = Shapes.or((VoxelShape)bottom, (VoxelShape[])((VoxelShape[])parts.toArray(VoxelShape[]::new)));
                    }
                }
            }
        }
        return result;
    }

    private static int getShapeKey(Direction facing, boolean left, boolean right, FrontConnection front) {
        return front.ordinal() << 4 | (left ? 1 : 0) << 3 | (right ? 1 : 0) << 2 | facing.get2DDataValue();
    }

    @Nullable
    public static Direction getSleepingDirection(BlockGetter world, BlockPos pos) {
        return SofaBlock.getSleepingDirection(world, pos, false);
    }

    @Nullable
    public static Direction getSleepingDirection(BlockGetter world, BlockPos pos, boolean ignoreNeighbors) {
        BlockState state = world.getBlockState(pos);
        if (!(state.getBlock() instanceof SofaBlock)) {
            return null;
        }
        boolean connectedLeft = (Boolean)state.getValue((Property)CONNECTED_LEFT);
        boolean connectedRight = (Boolean)state.getValue((Property)CONNECTED_RIGHT);
        FrontConnection frontConnection = (FrontConnection)((Object)state.getValue(FRONT_CONNECTION));
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (!connectedLeft && !connectedRight && frontConnection == FrontConnection.NONE || !ignoreNeighbors && ((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            return null;
        }
        @Nullable Object result = frontConnection != FrontConnection.NONE ? facing : (connectedLeft ? facing.getClockWise() : (connectedRight ? facing.getCounterClockWise() : null));
        if (result != null) {
            if (ignoreNeighbors) {
                return result;
            }
            BlockState neighborState = world.getBlockState(pos.relative(result));
            if (neighborState.getBlock() instanceof SofaBlock && !((Boolean)neighborState.getValue((Property)OCCUPIED)).booleanValue()) {
                return result;
            }
        }
        return null;
    }
}

