/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import juuxel.adorn.criterion.AdornCriteria;
import juuxel.adorn.criterion.SitOnBlockCriterion;
import juuxel.adorn.entity.AdornEntities;
import juuxel.adorn.entity.SeatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class SeatBlock
extends Block {
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;

    public SeatBlock(BlockBehaviour.Properties settings) {
        super(settings);
        if (this.isSittingEnabled()) {
            this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Nullable
    public abstract ResourceLocation getSittingStat();

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        BlockState actualState;
        if (!this.isSittingEnabled()) {
            return super.useWithoutItem(state, world, pos, player, hit);
        }
        BlockPos actualPos = this.getActualSeatPos(world, state, pos);
        BlockState blockState = actualState = pos.equals((Object)actualPos) ? state : world.getBlockState(actualPos);
        if (state != actualState && !(actualState.getBlock() instanceof SeatBlock)) {
            return InteractionResult.PASS;
        }
        Boolean occupied = (Boolean)actualState.getValue((Property)OCCUPIED);
        if (!occupied.booleanValue()) {
            if (!world.isClientSide) {
                SeatEntity entity = (SeatEntity)((EntityType)AdornEntities.SEAT.get()).create(world);
                entity.setPos(actualPos);
                world.addFreshEntity((Entity)entity);
                world.setBlockAndUpdate(actualPos, (BlockState)actualState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)));
                player.startRiding((Entity)entity, true);
                ResourceLocation sittingStat = this.getSittingStat();
                if (sittingStat != null) {
                    player.awardStat(sittingStat);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((SitOnBlockCriterion)((Object)AdornCriteria.SIT_ON_BLOCK.get())).trigger(serverPlayer, pos);
                }
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        super.onRemove(state, world, pos, newState, moved);
        if (!state.is(newState.getBlock())) {
            if (world.isClientSide || !this.isSittingEnabled()) {
                return;
            }
            List seats = world.getEntities((EntityTypeTest)AdornEntities.SEAT.get(), new AABB(this.getActualSeatPos(world, state, pos)), (Predicate)Predicates.alwaysTrue());
            for (SeatEntity seat : seats) {
                seat.ejectPassengers();
                seat.kill();
            }
        }
    }

    protected BlockPos getActualSeatPos(Level world, BlockState state, BlockPos pos) {
        return pos;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        if (this.isSittingEnabled()) {
            builder.add(new Property[]{OCCUPIED});
        }
    }

    protected boolean isSittingEnabled() {
        return true;
    }

    public double getSittingOffset(Level world, BlockState state, BlockPos pos) {
        return state.getCollisionShape((BlockGetter)world, pos).max(Direction.Axis.Y);
    }
}

