/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.variant.BlockVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class PostBlock
extends Block
implements BlockWithDescription,
SimpleWaterloggedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape X_SHAPE = PostBlock.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape Y_SHAPE = PostBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape Z_SHAPE = PostBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    private static final String DESCRIPTION_KEY = "block.adorn.post.description";

    public PostBlock(BlockVariant variant) {
        super(variant.createSettings());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)ctx.getClickedFace().getAxis())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> X_SHAPE;
            case Direction.Axis.Y -> Y_SHAPE;
            case Direction.Axis.Z -> Z_SHAPE;
        };
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        if (rotation == Rotation.COUNTERCLOCKWISE_90 || rotation == Rotation.CLOCKWISE_90) {
            return switch ((Direction.Axis)state.getValue(AXIS)) {
                case Direction.Axis.X -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                case Direction.Axis.Z -> (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                default -> state;
            };
        }
        return state;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }
}

