/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.Map;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.PostBlock;
import juuxel.adorn.util.Shapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class PicketFenceBlock
extends Block
implements SimpleWaterloggedBlock,
BlockWithDescription {
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> STRAIGHT_OUTLINE_SHAPES = Shapes.buildShapeRotationsFromNorth(0, 0, 7, 16, 16, 9);
    private static final Map<Direction, VoxelShape> CORNER_OUTLINE_SHAPES = Shapes.mergeIntoShapeMap(Shapes.mergeShapeMaps(Shapes.buildShapeRotationsFromNorth(0, 0, 7, 9, 16, 9), Shapes.buildShapeRotationsFromNorth(7, 0, 9, 9, 16, 16)), PostBlock.Y_SHAPE);
    private static final Map<Direction, VoxelShape> STRAIGHT_COLLISION_SHAPES = Shapes.buildShapeRotationsFromNorth(0, 0, 7, 16, 24, 9);
    private static final Map<Direction, VoxelShape> CORNER_COLLISION_SHAPES = Shapes.mergeIntoShapeMap(Shapes.mergeShapeMaps(Shapes.buildShapeRotationsFromNorth(0, 0, 7, 9, 24, 9), Shapes.buildShapeRotationsFromNorth(7, 0, 9, 9, 24, 16)), PicketFenceBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)24.0, (double)10.0));

    public PicketFenceBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SHAPE, FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
        return this.updateShape((LevelAccessor)ctx.getLevel(), ctx.getClickedPos(), state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction.getAxis() == ((Direction)state.getValue((Property)FACING)).getAxis()) {
            return this.updateShape(world, pos, state);
        }
        return state;
    }

    private BlockState updateShape(LevelAccessor world, BlockPos pos, BlockState state) {
        Direction fenceFacing = (Direction)state.getValue((Property)FACING);
        for (Direction side : new Direction[]{fenceFacing.getOpposite(), fenceFacing}) {
            PicketFenceBlock picketFence;
            Direction neighborFacing;
            boolean inner = side == fenceFacing;
            BlockState neighborState = world.getBlockState(pos.relative(side));
            Block neighborBlock = neighborState.getBlock();
            Direction direction = neighborFacing = neighborBlock instanceof PicketFenceBlock ? (Direction)neighborState.getValue((Property)FACING) : null;
            Shape shape = neighborFacing == fenceFacing.getClockWise() ? (inner ? Shape.CLOCKWISE_INNER_CORNER : Shape.CLOCKWISE_CORNER) : (neighborFacing == fenceFacing.getCounterClockWise() ? (inner ? Shape.COUNTERCLOCKWISE_INNER_CORNER : Shape.COUNTERCLOCKWISE_CORNER) : Shape.STRAIGHT);
            if (!(neighborBlock instanceof PicketFenceBlock) || !(picketFence = (PicketFenceBlock)neighborBlock).connectsTo(neighborState, side.getOpposite())) {
                shape = Shape.STRAIGHT;
            }
            if (shape == Shape.STRAIGHT) continue;
            return (BlockState)state.setValue(SHAPE, (Comparable)((Object)shape));
        }
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)Shape.STRAIGHT));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> STRAIGHT_OUTLINE_SHAPES.get(state.getValue((Property)FACING));
            case 1 -> CORNER_OUTLINE_SHAPES.get(state.getValue((Property)FACING));
            case 2 -> CORNER_OUTLINE_SHAPES.get(((Direction)state.getValue((Property)FACING)).getCounterClockWise());
            case 3 -> CORNER_OUTLINE_SHAPES.get(((Direction)state.getValue((Property)FACING)).getOpposite());
            case 4 -> CORNER_OUTLINE_SHAPES.get(((Direction)state.getValue((Property)FACING)).getClockWise());
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> STRAIGHT_COLLISION_SHAPES.get(state.getValue((Property)FACING));
            case 1 -> CORNER_COLLISION_SHAPES.get(state.getValue((Property)FACING));
            case 2 -> CORNER_COLLISION_SHAPES.get(((Direction)state.getValue((Property)FACING)).getCounterClockWise());
            case 3 -> CORNER_COLLISION_SHAPES.get(((Direction)state.getValue((Property)FACING)).getOpposite());
            case 4 -> CORNER_COLLISION_SHAPES.get(((Direction)state.getValue((Property)FACING)).getClockWise());
        };
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean sideCoversSmallSquare(BlockState state) {
        return state.getValue(SHAPE) != Shape.STRAIGHT;
    }

    private boolean connectsTo(BlockState state, Direction direction) {
        if (!direction.getAxis().isHorizontal()) {
            return false;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        return switch (((Shape)((Object)state.getValue(SHAPE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (facing.getAxis() != direction.getAxis()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (direction == facing.getCounterClockWise() || direction == facing.getOpposite()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (direction == facing.getClockWise() || direction == facing.getOpposite()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (direction == facing.getClockWise() || direction == facing) {
                    yield true;
                }
                yield false;
            }
            case 4 -> direction == facing.getCounterClockWise() || direction == facing;
        };
    }

    public static enum Shape implements StringRepresentable
    {
        STRAIGHT("straight"),
        CLOCKWISE_CORNER("clockwise_corner"),
        COUNTERCLOCKWISE_CORNER("counterclockwise_corner"),
        CLOCKWISE_INNER_CORNER("clockwise_inner_corner"),
        COUNTERCLOCKWISE_INNER_CORNER("counterclockwise_inner_corner");

        private final String id;

        private Shape(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }
    }
}

