/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.EnumMap;
import java.util.Map;
import juuxel.adorn.block.AbstractKitchenCounterBlock;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.KitchenCounterBlock;
import juuxel.adorn.block.entity.KitchenSinkBlockEntity;
import juuxel.adorn.block.variant.BlockVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class KitchenSinkBlock
extends KitchenCounterBlock
implements EntityBlock,
BlockWithDescription {
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);
    private static final String DESCRIPTION_KEY = "block.adorn.kitchen_sink.description";

    public KitchenSinkBlock(BlockVariant variant) {
        super(variant);
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean successful;
        KitchenSinkBlockEntity entity = world.getBlockEntity(pos, (BlockEntityType)AdornBlockEntities.KITCHEN_SINK.get()).orElse(null);
        if (entity == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.is(Items.SPONGE)) {
            successful = entity.clearFluidsWithSponge();
            if (successful) {
                stack.shrink(1);
                ItemStack wetStack = new ItemStack((ItemLike)Items.WET_SPONGE);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, wetStack);
                } else {
                    player.getInventory().placeItemBackInInventory(wetStack);
                }
            }
        } else {
            successful = entity.interactWithItem(stack, player, hand);
        }
        return successful ? ItemInteractionResult.sidedSuccess((boolean)world.isClientSide) : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        int n;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof KitchenSinkBlockEntity) {
            KitchenSinkBlockEntity sink = (KitchenSinkBlockEntity)blockEntity;
            n = sink.calculateComparatorOutput();
        } else {
            n = 0;
        }
        return n;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)AdornBlockEntities.KITCHEN_SINK.get()).create(pos, state);
    }

    static {
        Map<Direction, VoxelShape> sinkShapes = juuxel.adorn.util.Shapes.buildShapeRotationsFromNorth(2, 7, 3, 14, 16, 14);
        AbstractKitchenCounterBlock.SHAPES.forEach((direction, shape) -> SHAPES.put((Direction)direction, Shapes.join((VoxelShape)shape, (VoxelShape)((VoxelShape)sinkShapes.get(direction)), (BooleanOp)BooleanOp.ONLY_FIRST)));
    }
}

