/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.AbstractKitchenCounterBlock;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.property.FrontConnection;
import juuxel.adorn.block.variant.BlockVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class KitchenCounterBlock
extends AbstractKitchenCounterBlock
implements BlockWithDescription {
    public static final EnumProperty<FrontConnection> FRONT = EnumProperty.create((String)"front", FrontConnection.class);
    private static final String DESCRIPTION_KEY = "block.adorn.kitchen_counter.description";

    public KitchenCounterBlock(BlockVariant variant) {
        super(variant);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FRONT, (Comparable)((Object)FrontConnection.NONE)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FRONT});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.updateShape(super.getStateForPlacement(ctx), null, null, (LevelAccessor)ctx.getLevel(), ctx.getClickedPos(), null);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState frontState = world.getBlockState(pos.relative(facing));
        FrontConnection frontConnection = FrontConnection.NONE;
        if (frontState.getBlock() instanceof AbstractKitchenCounterBlock) {
            Direction frontFacing = (Direction)frontState.getValue((Property)FACING);
            if (frontFacing == facing.getClockWise()) {
                frontConnection = FrontConnection.LEFT;
            } else if (frontFacing == facing.getCounterClockWise()) {
                frontConnection = FrontConnection.RIGHT;
            }
        }
        return (BlockState)state.setValue(FRONT, (Comparable)((Object)frontConnection));
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }
}

