/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.AbstractChimneyBlock;
import juuxel.adorn.block.BlockWithDescription;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public final class ChimneyBlock
extends AbstractChimneyBlock
implements BlockWithDescription {
    public static final EnumProperty<SmokeType> SMOKE_TYPE = EnumProperty.create((String)"smoke_type", SmokeType.class);
    private static final String DESCRIPTION_KEY = "block.adorn.chimney.description";

    public ChimneyBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SMOKE_TYPE, (Comparable)((Object)SmokeType.CAMPFIRE)));
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SMOKE_TYPE});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        world.setBlockAndUpdate(pos, (BlockState)state.cycle(SMOKE_TYPE));
        return InteractionResult.sidedSuccess((boolean)world.isClientSide);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
            return;
        }
        int count = 3 + random.nextInt(2);
        switch (((SmokeType)((Object)state.getValue(SMOKE_TYPE))).ordinal()) {
            case 0: {
                for (int i = 0; i < count; ++i) {
                    world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.3 + random.nextDouble() * 0.4, (double)pos.getY() + 0.9, (double)pos.getZ() + 0.3 + random.nextDouble() * 0.4, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < count; ++i) {
                    world.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, (double)pos.getX() + 0.3 + random.nextDouble() * 0.4, (double)pos.getY() + 0.9 + random.nextDouble(), (double)pos.getZ() + 0.3 + random.nextDouble() * 0.4, 0.0, 0.07, 0.0);
                }
                break;
            }
        }
    }

    public static enum SmokeType implements StringRepresentable
    {
        CLASSIC("classic"),
        CAMPFIRE("campfire");

        private final String id;

        private SmokeType(String id) {
            this.id = id;
        }

        public String getSerializedName() {
            return this.id;
        }
    }
}

