/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.BlockWithDescription;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;

public final class ChainLinkFenceBlock
extends IronBarsBlock
implements BlockWithDescription {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;

    public ChainLinkFenceBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UP, DOWN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = super.getStateForPlacement(ctx);
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        return (BlockState)((BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(ChainLinkFenceBlock.connectsVerticallyTo(world.getBlockState(pos.above()))))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(ChainLinkFenceBlock.connectsVerticallyTo(world.getBlockState(pos.below()))));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        BlockState result = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        if (direction == Direction.UP) {
            result = (BlockState)result.setValue((Property)UP, (Comparable)Boolean.valueOf(ChainLinkFenceBlock.connectsVerticallyTo(neighborState)));
        } else if (direction == Direction.DOWN) {
            result = (BlockState)result.setValue((Property)DOWN, (Comparable)Boolean.valueOf(ChainLinkFenceBlock.connectsVerticallyTo(neighborState)));
        }
        return result;
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        return false;
    }

    private static boolean connectsVerticallyTo(BlockState state) {
        return state.getBlock() instanceof ChainLinkFenceBlock;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean attachsTo(BlockState state, boolean sideSolidFullSquare) {
        return super.attachsTo(state, sideSolidFullSquare) || state.is(BlockTags.FENCE_GATES);
    }
}

