/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.VisibleBlockWithEntity;
import juuxel.adorn.block.entity.BrewerBlockEntity;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.util.Shapes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public final class BrewerBlock
extends VisibleBlockWithEntity
implements BlockWithDescription {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HAS_MUG = BooleanProperty.create((String)"has_mug");
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.mergeShapeMaps(Shapes.buildShapeRotationsFromNorth(4, 0, 2, 12, 2, 12), Shapes.buildShapeRotationsFromNorth(4, 2, 8, 12, 8, 12), Shapes.buildShapeRotationsFromNorth(4, 8, 2, 12, 14, 12));
    private static final double RANDOM_CLOUD_OFFSET = 0.0625;
    private static final double FACING_CLOUD_OFFSET = 0.2;

    public BrewerBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HAS_MUG, (Comparable)Boolean.valueOf(false))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BrewerBlockEntity) {
            BrewerBlockEntity brewer = (BrewerBlockEntity)blockEntity;
            player.openMenu((MenuProvider)brewer);
            player.awardStat(AdornStats.OPEN_BREWER);
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)world, (BlockPos)pos);
        super.onRemove(state, world, pos, newState, moved);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)AdornBlockEntities.BREWER.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return !world.isClientSide ? BrewerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)AdornBlockEntities.BREWER.get()), BrewerBlockEntity::tick) : null;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_MUG, ACTIVE});
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        int n;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BrewerBlockEntity) {
            BrewerBlockEntity brewer = (BrewerBlockEntity)blockEntity;
            n = brewer.calculateComparatorOutput();
        } else {
            n = 0;
        }
        return n;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)ACTIVE)).booleanValue() && random.nextInt(3) == 0) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            double x = (double)pos.getX() + 0.5 + random.nextDouble() * 0.0625 + (double)facing.getStepX() * 0.2;
            double y = (double)pos.getY() + 0.37 + random.nextDouble() * 0.0625;
            double z = (double)pos.getZ() + 0.5 + random.nextDouble() * 0.0625 + (double)facing.getStepZ() * 0.2;
            world.addParticle((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        throw new UnsupportedOperationException();
    }
}

