/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.ArrayList;
import java.util.Map;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.util.AdornUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class BenchBlock
extends SeatBlock
implements SimpleWaterloggedBlock,
BlockWithDescription {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty CONNECTED_N = BooleanProperty.create((String)"connected_n");
    public static final BooleanProperty CONNECTED_P = BooleanProperty.create((String)"connected_p");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final String DESCRIPTION_KEY = "block.adorn.bench.description";
    private static final VoxelShape X_TOP_SHAPE = BenchBlock.box((double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0);
    private static final VoxelShape Z_TOP_SHAPE = BenchBlock.box((double)1.0, (double)8.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[8];

    public BenchBlock(BlockVariant variant) {
        super(variant.createSettings());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Z)).setValue((Property)CONNECTED_N, (Comparable)Boolean.valueOf(false))).setValue((Property)CONNECTED_P, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)AdornUtil.turnHorizontally(ctx.getHorizontalDirection().getAxis()))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
        return this.updateConnections((BlockGetter)ctx.getLevel(), ctx.getClickedPos(), state);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.updateConnections((BlockGetter)world, pos, state);
    }

    private BlockState updateConnections(BlockGetter world, BlockPos pos, BlockState state) {
        for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
            BooleanProperty property = axisDirection == Direction.AxisDirection.NEGATIVE ? CONNECTED_N : CONNECTED_P;
            BlockState neighbor = world.getBlockState(pos.relative((Direction.Axis)state.getValue(AXIS), axisDirection.getStep()));
            boolean connected = neighbor.getBlock() instanceof BenchBlock && neighbor.getValue(AXIS) == state.getValue(AXIS);
            state = (BlockState)state.setValue((Property)property, (Comparable)Boolean.valueOf(connected));
        }
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[BenchBlock.getShapeKey((Direction.Axis)state.getValue(AXIS), (Boolean)state.getValue((Property)CONNECTED_N), (Boolean)state.getValue((Property)CONNECTED_P))];
    }

    private static int getShapeKey(Direction.Axis axis, boolean connectedN, boolean connectedP) {
        return (axis == Direction.Axis.X ? 1 : 0) << 2 | (connectedN ? 1 : 0) << 1 | (connectedP ? 1 : 0);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS, CONNECTED_N, CONNECTED_P, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> (BlockState)state.setValue(AXIS, (Comparable)AdornUtil.turnHorizontally((Direction.Axis)state.getValue(AXIS)));
            default -> state;
        };
    }

    @Override
    public ResourceLocation getSittingStat() {
        return AdornStats.SIT_ON_BENCH;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    static {
        Map<Direction, VoxelShape> legShapes = juuxel.adorn.util.Shapes.buildShapeRotationsFromNorth(2, 0, 2, 14, 8, 4);
        boolean[] booleans = new boolean[]{true, false};
        for (Direction.Axis axis : new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
            VoxelShape topShape = axis == Direction.Axis.X ? X_TOP_SHAPE : Z_TOP_SHAPE;
            VoxelShape negativeLeg = legShapes.get(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
            VoxelShape positiveLeg = legShapes.get(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
            for (boolean connectedN : booleans) {
                for (boolean connectedP : booleans) {
                    ArrayList<VoxelShape> parts = new ArrayList<VoxelShape>();
                    if (!connectedN) {
                        parts.add(negativeLeg);
                    }
                    if (!connectedP) {
                        parts.add(positiveLeg);
                    }
                    int key = BenchBlock.getShapeKey(axis, connectedN, connectedP);
                    BenchBlock.SHAPES[key] = Shapes.or((VoxelShape)topShape, (VoxelShape[])((VoxelShape[])parts.toArray(VoxelShape[]::new)));
                }
            }
        }
    }
}

