/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import juuxel.adorn.block.CarpetedBlock;
import juuxel.adorn.block.property.OptionalProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractTableBlock
extends CarpetedBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public AbstractTableBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected abstract boolean canConnectTo(BlockState var1, Direction var2);

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.updateConnections((BlockState)super.getStateForPlacement(ctx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER)), (LevelAccessor)ctx.getLevel(), ctx.getClickedPos());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return this.updateConnections(super.updateShape(state, direction, neighborState, world, pos, neighborPos), world, pos);
    }

    private BlockState updateConnections(BlockState state, LevelAccessor world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(world.getBlockState(pos.relative(Direction.NORTH)), Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(world.getBlockState(pos.relative(Direction.EAST)), Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(world.getBlockState(pos.relative(Direction.SOUTH)), Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(world.getBlockState(pos.relative(Direction.WEST)), Direction.WEST)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShapeForKey(AbstractTableBlock.getShapeKey((Boolean)state.getValue((Property)NORTH), (Boolean)state.getValue((Property)EAST), (Boolean)state.getValue((Property)SOUTH), (Boolean)state.getValue((Property)WEST), this.isCarpetingEnabled() && ((OptionalProperty.Value)state.getValue((Property)CARPET)).isPresent()));
    }

    protected static int getShapeKey(boolean north, boolean east, boolean south, boolean west, boolean hasCarpet) {
        return (north ? 1 : 0) << 4 | (east ? 1 : 0) << 3 | (south ? 1 : 0) << 2 | (west ? 1 : 0) << 1 | (hasCarpet ? 1 : 0);
    }

    protected abstract VoxelShape getShapeForKey(int var1);

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

