/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class InventoryScannerScreen
extends AbstractContainerScreen<InventoryScannerMenu> {
    private static final ResourceLocation REGULAR_INVENTORY = SecurityCraft.resLoc("textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = SecurityCraft.resLoc("textures/gui/container/inventory_scanner_enhanced_gui.png");
    public final InventoryScannerBlockEntity be;
    private boolean owns = false;
    private boolean hasRedstoneModule = false;
    private boolean hasStorageModule = false;
    private Component infoStringRedstone;
    private Component infoStringStorage;
    private static final Style UNDERLINE = Style.EMPTY.applyFormat(ChatFormatting.UNDERLINE);
    private final Component prohibitedItems = Utils.localize("gui.securitycraft:invScan.prohibitedItems", new Object[0]);
    private final Component adminMode = Utils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]).setStyle(UNDERLINE);
    private final Component viewMode = Utils.localize("gui.securitycraft:invScan.mode.view", new Object[0]).setStyle(UNDERLINE);
    private final Component storage = Utils.localize("gui.securitycraft:invScan.storage", new Object[0]);
    private Component redstoneModuleTooltip = null;
    private Component storageModuleTooltip = null;

    public InventoryScannerScreen(InventoryScannerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.owns = this.be.isOwnedBy((Entity)inv.player);
        this.hasRedstoneModule = this.be.isModuleEnabled(ModuleType.REDSTONE);
        this.hasStorageModule = this.be.isModuleEnabled(ModuleType.STORAGE);
        this.infoStringRedstone = Utils.localize("gui.securitycraft:invScan.emit_redstone", Utils.localize("gui.securitycraft:invScan." + (this.hasRedstoneModule ? "yes" : "no"), new Object[0]));
        this.infoStringStorage = Utils.localize("gui.securitycraft:invScan.check_inv", Utils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0]));
        if (!this.hasRedstoneModule) {
            this.redstoneModuleTooltip = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)((Object)SCContent.REDSTONE_MODULE.get())).getDescriptionId(), new Object[0]));
        }
        if (this.hasStorageModule) {
            this.imageWidth = 246;
        } else {
            this.imageWidth = 190;
            this.storageModuleTooltip = Utils.localize("gui.securitycraft:invScan.notInstalled", Utils.localize(((ModuleItem)((Object)SCContent.STORAGE_MODULE.get())).getDescriptionId(), new Object[0]));
        }
        this.imageHeight = 196;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawWordWrap(this.font, (FormattedText)this.infoStringRedstone, this.leftPos + 28, this.topPos + 45, 150, 0x404040);
        guiGraphics.drawWordWrap(this.font, (FormattedText)this.infoStringStorage, this.leftPos + 28, this.topPos + 75, 150, 0x404040);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.REDSTONE, this.redstoneModuleTooltip, this.hasRedstoneModule, this.leftPos + 8, this.topPos + 45, mouseX, mouseY);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.STORAGE, this.storageModuleTooltip, this.hasStorageModule, this.leftPos + 8, this.topPos + 75, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.prohibitedItems, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.be.isOwnedBy((Entity)this.minecraft.player) ? this.adminMode : this.viewMode, 112, 6, 0x404040, false);
        if (this.hasStorageModule && this.owns) {
            guiGraphics.drawString(this.font, this.storage, 188, 18, 0x404040, false);
        }
        guiGraphics.drawString(this.font, Utils.INVENTORY_TEXT, 15, this.imageHeight - 93, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(this.hasStorageModule && this.owns ? ENHANCED_INVENTORY : REGULAR_INVENTORY, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight + 30);
    }
}

