/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ToggleModule
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ToggleModule> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("toggle_module"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleModule> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ToggleModule>(){

        public ToggleModule decode(RegistryFriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return new ToggleModule(buf.readBlockPos(), (ModuleType)buf.readEnum(ModuleType.class));
            }
            return new ToggleModule(buf.readVarInt(), (ModuleType)buf.readEnum(ModuleType.class));
        }

        public void encode(RegistryFriendlyByteBuf buf, ToggleModule packet) {
            boolean hasPos = packet.pos != null;
            buf.writeBoolean(hasPos);
            if (hasPos) {
                buf.writeBlockPos(packet.pos);
            } else {
                buf.writeVarInt(packet.entityId);
            }
            buf.writeEnum((Enum)packet.moduleType);
        }
    };
    private BlockPos pos;
    private ModuleType moduleType;
    private int entityId;

    public ToggleModule(BlockPos pos, ModuleType moduleType) {
        this.pos = pos;
        this.moduleType = moduleType;
    }

    public ToggleModule(int entityId, ModuleType moduleType) {
        this.entityId = entityId;
        this.moduleType = moduleType;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        IOwnable ownable;
        Player player = ctx.player();
        Level level = player.level();
        IModuleInventory moduleInv = this.getModuleInventory(level);
        if (!(player.isSpectator() || moduleInv == null || moduleInv instanceof IOwnable && !(ownable = (IOwnable)((Object)moduleInv)).isOwnedBy((Entity)player))) {
            if (moduleInv.isModuleEnabled(this.moduleType)) {
                moduleInv.removeModule(this.moduleType, true);
                if (moduleInv instanceof LinkableBlockEntity) {
                    linkable = (LinkableBlockEntity)moduleInv;
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(this.moduleType, true), linkable);
                }
            } else {
                moduleInv.insertModule(moduleInv.getModule(this.moduleType), true);
                if (moduleInv instanceof LinkableBlockEntity) {
                    linkable = (LinkableBlockEntity)moduleInv;
                    ItemStack stack = moduleInv.getModule(this.moduleType);
                    linkable.propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, (ModuleItem)stack.getItem(), true), linkable);
                }
            }
            if (moduleInv instanceof BlockEntity) {
                BlockEntity be = (BlockEntity)moduleInv;
                player.level().sendBlockUpdated(this.pos, be.getBlockState(), be.getBlockState(), 3);
            }
        }
    }

    private IModuleInventory getModuleInventory(Level level) {
        if (this.pos != null) {
            BlockEntity blockEntity = level.getBlockEntity(this.pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory be = (IModuleInventory)blockEntity;
                return be;
            }
        } else {
            Entity entity = level.getEntity(this.entityId);
            if (entity instanceof IModuleInventory) {
                IModuleInventory entity2 = (IModuleInventory)entity;
                return entity2;
            }
        }
        return null;
    }
}

