/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;

public class BlockMineModel
implements BakedModel {
    private final BakedModel defaultModel;
    private final BakedModel guiModel;

    public BlockMineModel(BakedModel defaultModel, BakedModel guiModel) {
        this.defaultModel = defaultModel;
        this.guiModel = guiModel;
    }

    public BakedModel applyTransform(ItemDisplayContext displayContext, PoseStack pose, boolean applyLeftHandTransform) {
        if (displayContext == ItemDisplayContext.GUI || displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            this.guiModel.getTransforms().getTransform(displayContext).apply(applyLeftHandTransform, pose);
            return this.guiModel;
        }
        this.defaultModel.getTransforms().getTransform(displayContext).apply(applyLeftHandTransform, pose);
        return this.defaultModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand) {
        return this.defaultModel == null ? new ArrayList<BakedQuad>() : this.defaultModel.getQuads(state, side, rand);
    }

    public boolean useAmbientOcclusion() {
        return this.defaultModel == null || this.defaultModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.defaultModel != null && this.defaultModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.defaultModel.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return this.defaultModel != null && this.defaultModel.isCustomRenderer();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.defaultModel == null ? (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MissingTextureAtlasSprite.getLocation()) : this.defaultModel.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return this.defaultModel == null ? ItemOverrides.EMPTY : this.defaultModel.getOverrides();
    }
}

