/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class UniversalBlockModifierItem
extends Item {
    public UniversalBlockModifierItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        DisplayCaseBlockEntity displayCase;
        final Level level = ctx.getLevel();
        final BlockPos pos = ctx.getClickedPos();
        final BlockEntity be = level.getBlockEntity(pos);
        Player player = ctx.getPlayer();
        if (be instanceof DisplayCaseBlockEntity && (displayCase = (DisplayCaseBlockEntity)be).isOpen() && displayCase.getDisplayedStack().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (be instanceof IModuleInventory) {
            IOwnable ownable;
            if (be instanceof IOwnable && !(ownable = (IOwnable)be).isOwnedBy((Entity)player)) {
                IDisguisable db;
                Block block = be.getBlockState().getBlock();
                if (!(block instanceof IDisguisable) || ((BlockItem)(db = (IDisguisable)block).getDisguisedStack((BlockGetter)level, pos).getItem()).getBlock() instanceof IDisguisable) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(ownable.getOwner())), ChatFormatting.RED);
                }
                return InteractionResult.FAIL;
            }
            if (!ctx.getLevel().isClientSide) {
                player.openMenu(new MenuProvider(){

                    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                        return new CustomizeBlockMenu(windowId, level, pos, inv);
                    }

                    public Component getDisplayName() {
                        if (be instanceof Nameable) {
                            Nameable nameable = (Nameable)be;
                            return nameable.getDisplayName();
                        }
                        return Component.translatable((String)be.getBlockState().getBlock().getDescriptionId());
                    }

                    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
                        super.writeClientSideData(menu, buffer);
                        buffer.writeBlockPos(pos);
                    }
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

