/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.components.OwnerData;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class KeycardItem
extends Item {
    private static final Component LINK_INFO = Component.translatable((String)"tooltip.securitycraft:keycard.link_info").setStyle(Utils.GRAY_STYLE);
    public static final Component LIMITED_INFO = Component.translatable((String)"tooltip.securitycraft:keycard.limited_info").setStyle(Utils.GRAY_STYLE);
    private final int level;

    public KeycardItem(Item.Properties properties, int level) {
        super(properties);
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        if (this != SCContent.LIMITED_USE_KEYCARD.get()) {
            OwnerData ownerData = (OwnerData)stack.getOrDefault(SCContent.OWNER_DATA, (Object)OwnerData.DEFAULT);
            KeycardData keycardData = (KeycardData)stack.get(SCContent.KEYCARD_DATA);
            if (ownerData != null && !ownerData.showInTooltip()) {
                list.add((Component)Component.translatable((String)"tooltip.securitycraft:keycard.reader_owner", (Object[])new Object[]{ownerData.name()}).setStyle(Utils.GRAY_STYLE));
            }
            if (keycardData != null) {
                keycardData.addToTooltip(ctx, list::add, flag);
            } else {
                list.add(LINK_INFO);
                list.add(LIMITED_INFO);
            }
        }
    }
}

