/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class KeyPanelItem
extends BlockItem {
    public KeyPanelItem(Item.Properties properties) {
        super((Block)SCContent.KEY_PANEL_BLOCK.get(), properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        IOwnable ownable;
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IOwnable) || (ownable = (IOwnable)blockEntity).isOwnedBy((Entity)player)) {
            for (IPasscodeConvertible pc : SecurityCraftAPI.getRegisteredPasscodeConvertibles()) {
                if (!pc.isUnprotectedBlock(state)) continue;
                int requiredKeyPanels = pc.getRequiredKeyPanels(state);
                if (requiredKeyPanels > stack.getCount()) {
                    PlayerUtils.sendMessageToPlayer(player, Component.literal((String)"SecurityCraft"), Component.translatable((String)"messages.securitycraft:notEnoughKeyPanels", (Object[])new Object[]{requiredKeyPanels}), ChatFormatting.RED);
                    return InteractionResult.FAIL;
                }
                if (pc.protect(player, level, pos)) {
                    if (!player.isCreative()) {
                        stack.shrink(requiredKeyPanels);
                    }
                    level.playSound(null, pos, SCSounds.LOCK.event, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
        }
        return super.useOn(ctx);
    }
}

