/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.items.UniversalBlockRemoverItem;
import net.geforcemods.securitycraft.items.UniversalKeyChangerItem;
import net.geforcemods.securitycraft.items.UniversalOwnerChangerItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public class SecuritySeaBoat
extends ChestBoat
implements IOwnable,
IPasscodeProtected,
IModuleInventory,
ICustomizable {
    private static final EntityDataAccessor<Owner> OWNER = SynchedEntityData.defineId(SecuritySeaBoat.class, Owner.getSerializer());
    private static final EntityDataAccessor<Boolean> SEND_ALLOWLIST_MESSAGE = SynchedEntityData.defineId(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SEND_DENYLIST_MESSAGE = SynchedEntityData.defineId(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> SMART_MODULE_COOLDOWN = SynchedEntityData.defineId(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Long> COOLDOWN_END = SynchedEntityData.defineId(SecuritySeaBoat.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final EntityDataAccessor<Map<ModuleType, Boolean>> MODULE_STATES = SynchedEntityData.defineId(SecuritySeaBoat.class, (EntityDataSerializer)((EntityDataSerializer)SCContent.MODULE_STATES_SERIALIZER.get()));
    private static final EntityDataAccessor<NonNullList<ItemStack>> MODULES = SynchedEntityData.defineId(SecuritySeaBoat.class, (EntityDataSerializer)((EntityDataSerializer)SCContent.ITEM_STACK_LIST_SERIALIZER.get()));
    private byte[] passcode;
    private UUID saltKey;
    private boolean saveSalt = false;
    private Option.EntityDataWrappedOption<Boolean> sendAllowlistMessage = new Option.SendAllowlistMessageOption(false).wrapForEntityData(SEND_ALLOWLIST_MESSAGE, () -> this.entityData);
    private Option.EntityDataWrappedOption<Boolean> sendDenylistMessage = new Option.SendDenylistMessageOption(true).wrapForEntityData(SEND_DENYLIST_MESSAGE, () -> this.entityData);
    private Option.EntityDataWrappedOption<Integer> smartModuleCooldown = new Option.SmartModuleCooldownOption().wrapForEntityData(SMART_MODULE_COOLDOWN, () -> this.entityData);
    private boolean isInLava = false;

    public SecuritySeaBoat(EntityType<? extends Boat> type, Level level) {
        super((EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), level);
    }

    public SecuritySeaBoat(Level level, double x, double y, double z) {
        super((EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), level);
        this.setPos(x, y, z);
        this.xo = y;
        this.yo = y;
        this.zo = z;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER, (Object)new Owner());
        builder.define(SEND_ALLOWLIST_MESSAGE, (Object)false);
        builder.define(SEND_DENYLIST_MESSAGE, (Object)true);
        builder.define(SMART_MODULE_COOLDOWN, (Object)100);
        builder.define(COOLDOWN_END, (Object)0L);
        builder.define(MODULE_STATES, new EnumMap(ModuleType.class));
        builder.define(MODULES, (Object)NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY));
    }

    public boolean canAddPassenger(Entity passenger) {
        return super.canAddPassenger(passenger) && (this.isOwnedBy(passenger) || this.isAllowed(passenger)) && !this.isDenied(passenger);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        final Level level = player.level();
        if (!(!this.isDenied((Entity)player) || this.isOwnedBy((Entity)player) || player.isSecondaryUseActive() && stack.is((Item)SCContent.CODEBREAKER.get()))) {
            if (this.sendsDenylistMessage()) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getType().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (player.isSecondaryUseActive()) {
            if (stack.is((Item)SCContent.CODEBREAKER.get())) {
                if (!level.isClientSide) {
                    this.handleCodebreaking(player, player.getMainHandItem().is((Item)SCContent.CODEBREAKER.get()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.is((Item)SCContent.UNIVERSAL_KEY_CHANGER.get())) {
                if (!level.isClientSide) {
                    if (this.isOwnedBy((Entity)player) || player.isCreative()) {
                        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.CHANGE_PASSCODE_FOR_ENTITY, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalKeyChangerItem)((Object)SCContent.UNIVERSAL_KEY_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                    }
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.is((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()) && this.isOwnedBy((Entity)player)) {
                if (!level.isClientSide) {
                    String newOwner = stack.getHoverName().getString();
                    if (FMLEnvironment.production) {
                        this.dropAllModules();
                    }
                    this.setOwner(PlayerUtils.isPlayerOnline(newOwner) ? PlayerUtils.getPlayerFromName(newOwner).getUUID().toString() : "ownerUUID", newOwner);
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), ChatFormatting.GREEN);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.is((Item)SCContent.UNIVERSAL_BLOCK_MODIFIER.get())) {
                if (this.isOwnedBy((Entity)player)) {
                    if (!level.isClientSide) {
                        final BlockPos pos = this.blockPosition();
                        player.openMenu(new MenuProvider(){

                            public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                                return new CustomizeBlockMenu(windowId, level, pos, SecuritySeaBoat.super.getId(), inv);
                            }

                            public Component getDisplayName() {
                                return SecuritySeaBoat.super.getDisplayName();
                            }

                            public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
                                buffer.writeBlockPos(pos);
                                buffer.writeVarInt(SecuritySeaBoat.super.getId());
                            }
                        });
                    }
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalOwnerChangerItem)((Object)SCContent.UNIVERSAL_OWNER_CHANGER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.is((Item)SCContent.UNIVERSAL_BLOCK_REMOVER.get())) {
                if (this.isOwnedBy((Entity)player) || player.isCreative()) {
                    this.destroy(this.damageSources().playerAttack(player));
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((UniversalBlockRemoverItem)((Object)SCContent.UNIVERSAL_BLOCK_REMOVER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                }
            }
        } else if (!this.canAddPassenger((Entity)player)) {
            if (this.isDenied((Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getType().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getType().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:security_sea_boat.cant_enter", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.interact(player, hand);
    }

    public InteractionResult interactWithContainerVehicle(Player player) {
        Level level = this.level();
        BlockPos pos = this.blockPosition();
        if (!level.isClientSide && this.verifyPasscodeSet(level, pos, this, player)) {
            if (this.isDenied((Entity)player)) {
                if (this.sendsDenylistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getType().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else if (this.isAllowed((Entity)player)) {
                if (this.sendsAllowlistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getType().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                }
                this.activate(player);
            } else {
                this.openPasscodeGUI(level, pos, player);
            }
        }
        return !level.isClientSide ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
    }

    public void openCustomInventoryScreen(Player player) {
        this.interactWithContainerVehicle(player);
    }

    @Override
    public void openPasscodeGUI(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide && this.getPasscode() != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.CHECK_PASSCODE_FOR_ENTITY, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void openSetPasscodeScreen(ServerPlayer player, BlockPos pos) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.SET_PASSCODE_FOR_ENTITY, this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean canBoatInFluid(FluidState state) {
        return super.canBoatInFluid(state) || state.is((Fluid)Fluids.LAVA);
    }

    public boolean canBoatInFluid(FluidType type) {
        return super.canBoatInFluid(type) || type == NeoForgeMod.LAVA_TYPE;
    }

    public boolean checkInWater() {
        this.isInLava = this.level().getFluidState(this.blockPosition()).is((Fluid)Fluids.LAVA);
        return super.checkInWater();
    }

    public void setDeltaMovement(Vec3 deltaMovement) {
        if (this.isInLava) {
            super.setDeltaMovement(deltaMovement.scale(0.5));
        } else {
            super.setDeltaMovement(deltaMovement);
        }
    }

    public void tick() {
        Entity passenger;
        super.tick();
        if (!this.level().isClientSide && this.isInLava && (passenger = this.getFirstPassenger()) != null) {
            if (!passenger.fireImmune()) {
                passenger.setRemainingFireTicks(passenger.getRemainingFireTicks() + 1);
                if (passenger.getRemainingFireTicks() == 0) {
                    passenger.igniteForSeconds(8.0f);
                }
            }
            passenger.hurt(this.level().damageSources().inFire(), 1.0f);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        Entity entity = source.getEntity();
        if (!(entity instanceof Player) || this.isOwnedBy((Entity)(player = (Player)entity)) || player.isCreative()) {
            return super.hurt(source, amount);
        }
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return !source.is(SCTags.DamageTypes.SECURITY_SEA_BOAT_VULNERABLE_TO) || super.isInvulnerableTo(source);
    }

    public Item getDropItem() {
        return (Item)(switch (this.getVariant()) {
            case Boat.Type.SPRUCE -> SCContent.SPRUCE_SECURITY_SEA_BOAT;
            case Boat.Type.BIRCH -> SCContent.BIRCH_SECURITY_SEA_BOAT;
            case Boat.Type.JUNGLE -> SCContent.JUNGLE_SECURITY_SEA_BOAT;
            case Boat.Type.ACACIA -> SCContent.ACACIA_SECURITY_SEA_BOAT;
            case Boat.Type.DARK_OAK -> SCContent.DARK_OAK_SECURITY_SEA_BOAT;
            case Boat.Type.MANGROVE -> SCContent.MANGROVE_SECURITY_SEA_BOAT;
            case Boat.Type.CHERRY -> SCContent.CHERRY_SECURITY_SEA_BOAT;
            case Boat.Type.BAMBOO -> SCContent.BAMBOO_SECURITY_SEA_RAFT;
            default -> SCContent.OAK_SECURITY_SEA_BOAT;
        }).get();
    }

    public void remove(Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (BlockPos)this.blockPosition(), this.getInventory());
            SaltData.removeSalt(this.getSaltKey());
        }
        super.remove(reason);
    }

    public static IItemHandler getCapability(SecuritySeaBoat boat, Direction direction) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(direction, boat, boat.level(), boat.blockPosition()) ? new InvWrapper((Container)boat) : new InsertOnlyInvWrapper((Container)boat);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        CompoundTag ownerTag = new CompoundTag();
        super.addAdditionalSaveData(tag);
        this.writeModuleInventory(tag, (HolderLookup.Provider)this.registryAccess());
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.putLong("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        this.getOwner().save(ownerTag, this.needsValidation());
        tag.put("owner", (Tag)ownerTag);
        this.savePasscodeAndSalt(tag);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(MODULES, (Object)this.readModuleInventory(tag, (HolderLookup.Provider)this.registryAccess()));
        this.entityData.set(MODULE_STATES, (Object)this.readModuleStates(tag));
        this.readOptions(tag);
        this.entityData.set(COOLDOWN_END, (Object)(System.currentTimeMillis() + tag.getLong("cooldownLeft")));
        this.entityData.set(OWNER, (Object)Owner.fromCompound(tag.getCompound("owner")));
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (!this.level().isClientSide) {
            this.entityData.set(((Option.EntityDataWrappedOption)option).getEntityDataKey(), option.get());
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (this.level().isClientSide) {
            if (key == SEND_ALLOWLIST_MESSAGE) {
                this.sendAllowlistMessage.setValue((Boolean)this.entityData.get(SEND_ALLOWLIST_MESSAGE));
            } else if (key == SEND_DENYLIST_MESSAGE) {
                this.sendDenylistMessage.setValue((Boolean)this.entityData.get(SEND_DENYLIST_MESSAGE));
            } else if (key == SMART_MODULE_COOLDOWN) {
                this.smartModuleCooldown.setValue((Integer)this.entityData.get(SMART_MODULE_COOLDOWN));
            }
        }
        super.onSyncedDataUpdated(key);
    }

    public void setOwner(Player player) {
        if (player != null) {
            this.setOwner(player.getGameProfile().getId().toString(), player.getName().getString());
        }
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.entityData.set(OWNER, (Object)new Owner(name, uuid));
    }

    @Override
    public Owner getOwner() {
        return (Owner)this.entityData.get(OWNER);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
    }

    @Override
    public void activate(Player player) {
        super.openCustomInventoryScreen(player);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setSaveSalt(boolean saveSalt) {
        this.saveSalt = saveSalt;
    }

    @Override
    public boolean shouldSaveSalt() {
        return this.saveSalt;
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.entityData.set(COOLDOWN_END, (Object)(System.currentTimeMillis() + (long)(this.smartModuleCooldown.get() * 50)));
        }
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public long getCooldownEnd() {
        return (Long)this.entityData.get(COOLDOWN_END);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.smartModuleCooldown};
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return (NonNullList)this.entityData.get(MODULES);
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING};
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && ((Map)this.entityData.get(MODULE_STATES)).get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        Map moduleStates = (Map)this.entityData.get(MODULE_STATES);
        moduleStates.put(module, shouldBeEnabled);
        this.entityData.set(MODULE_STATES, (Object)moduleStates);
    }

    @Override
    public String getModuleDescriptionId(String denotation, ModuleType module) {
        return IModuleInventory.super.getModuleDescriptionId("generic." + denotation, module);
    }

    @Override
    public Level myLevel() {
        return this.level();
    }

    @Override
    public BlockPos myPos() {
        return this.blockPosition();
    }

    public boolean sendsAllowlistMessage() {
        return this.sendAllowlistMessage.get();
    }

    public void setSendsAllowlistMessage(boolean value) {
        this.sendAllowlistMessage.setValue(value);
    }

    public boolean sendsDenylistMessage() {
        return this.sendDenylistMessage.get();
    }

    public void setSendsDenylistMessage(boolean value) {
        this.sendDenylistMessage.setValue(value);
    }
}

