/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ReinforcedFallingBlock
extends BaseReinforcedBlock
implements Fallable {
    public ReinforcedFallingBlock(BlockBehaviour.Properties properties, Block vB) {
        super(properties, vB);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean flag) {
        level.scheduleTick(pos, (Block)this, 2);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        level.scheduleTick(currentPos, (Block)this, 2);
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinBuildHeight()) {
            BlockEntity be = level.getBlockEntity(pos);
            FallingBlockEntity entity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)level.getBlockState(pos));
            entity.blockData = be.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            level.addFreshEntity((Entity)entity);
        }
    }
}

