/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface IReinforcedBlock {
    public static final Map<Block, Block> VANILLA_TO_SECURITYCRAFT = new LinkedHashMap<Block, Block>();
    public static final Map<Block, Block> SECURITYCRAFT_TO_VANILLA = new LinkedHashMap<Block, Block>();

    public Block getVanillaBlock();

    default public BlockState convertToReinforced(Level level, BlockPos pos, BlockState vanillaState) {
        BlockState defaultBlockState = ((Block)this).defaultBlockState();
        for (Property property : vanillaState.getProperties()) {
            if (!defaultBlockState.hasProperty(property)) continue;
            defaultBlockState = (BlockState)defaultBlockState.setValue(property, vanillaState.getValue(property));
        }
        return defaultBlockState;
    }

    default public BlockState convertToVanilla(Level level, BlockPos pos, BlockState reinforcedState) {
        BlockState defaultBlockState = this.getVanillaBlock().defaultBlockState();
        for (Property property : reinforcedState.getProperties()) {
            if (!defaultBlockState.hasProperty(property)) continue;
            defaultBlockState = (BlockState)defaultBlockState.setValue(property, reinforcedState.getValue(property));
        }
        return defaultBlockState;
    }
}

