/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.loot;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class BlockLootSubProvider
implements LootTableSubProvider {
    protected static final LootItemCondition.Builder HAS_SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
    protected final HolderLookup.Provider registries;
    protected final Set<Item> explosionResistant;
    protected final FeatureFlagSet enabledFeatures;
    protected final Map<ResourceKey<LootTable>, LootTable.Builder> map;
    protected static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    protected LootItemCondition.Builder hasSilkTouch() {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)registrylookup.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))));
    }

    protected LootItemCondition.Builder doesNotHaveSilkTouch() {
        return this.hasSilkTouch().invert();
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return HAS_SHEARS.or(this.hasSilkTouch());
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
        return this.hasShearsOrSilkTouch().invert();
    }

    protected BlockLootSubProvider(Set<Item> p_249153_, FeatureFlagSet p_251215_, HolderLookup.Provider p_344943_) {
        this(p_249153_, p_251215_, new HashMap<ResourceKey<LootTable>, LootTable.Builder>(), p_344943_);
    }

    protected BlockLootSubProvider(Set<Item> p_281507_, FeatureFlagSet p_283552_, Map<ResourceKey<LootTable>, LootTable.Builder> p_282212_, HolderLookup.Provider p_345191_) {
        this.explosionResistant = p_281507_;
        this.enabledFeatures = p_283552_;
        this.map = p_282212_;
        this.registries = p_345191_;
    }

    protected <T extends FunctionUserBuilder<T>> T applyExplosionDecay(ItemLike p_248695_, FunctionUserBuilder<T> p_248548_) {
        return (T)(!this.explosionResistant.contains(p_248695_.asItem()) ? p_248548_.apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()) : p_248548_.unwrap());
    }

    protected <T extends ConditionUserBuilder<T>> T applyExplosionCondition(ItemLike p_249717_, ConditionUserBuilder<T> p_248851_) {
        return (T)(!this.explosionResistant.contains(p_249717_.asItem()) ? p_248851_.when(ExplosionCondition.survivesExplosion()) : p_248851_.unwrap());
    }

    public LootTable.Builder createSingleItemTable(ItemLike p_251912_) {
        return LootTable.lootTable().withPool(this.applyExplosionCondition(p_251912_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_251912_))));
    }

    protected static LootTable.Builder createSelfDropDispatchTable(Block p_252253_, LootItemCondition.Builder p_248764_, LootPoolEntryContainer.Builder<?> p_249146_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)p_252253_).when(p_248764_)).otherwise(p_249146_)));
    }

    protected LootTable.Builder createSilkTouchDispatchTable(Block p_250203_, LootPoolEntryContainer.Builder<?> p_252089_) {
        return BlockLootSubProvider.createSelfDropDispatchTable(p_250203_, this.hasSilkTouch(), p_252089_);
    }

    protected LootTable.Builder createShearsDispatchTable(Block p_252195_, LootPoolEntryContainer.Builder<?> p_250102_) {
        return BlockLootSubProvider.createSelfDropDispatchTable(p_252195_, HAS_SHEARS, p_250102_);
    }

    protected LootTable.Builder createSilkTouchOrShearsDispatchTable(Block p_250539_, LootPoolEntryContainer.Builder<?> p_251459_) {
        return BlockLootSubProvider.createSelfDropDispatchTable(p_250539_, this.hasShearsOrSilkTouch(), p_251459_);
    }

    protected LootTable.Builder createSingleItemTableWithSilkTouch(Block p_249305_, ItemLike p_251905_) {
        return this.createSilkTouchDispatchTable(p_249305_, (LootPoolEntryContainer.Builder)this.applyExplosionCondition(p_249305_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)p_251905_)));
    }

    protected LootTable.Builder createSingleItemTable(ItemLike p_251584_, NumberProvider p_249865_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_251584_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)p_251584_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)p_249865_)))));
    }

    protected LootTable.Builder createSingleItemTableWithSilkTouch(Block p_251449_, ItemLike p_248558_, NumberProvider p_250047_) {
        return this.createSilkTouchDispatchTable(p_251449_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_251449_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)p_248558_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)p_250047_))));
    }

    protected LootTable.Builder createSilkTouchOnlyTable(ItemLike p_252216_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_252216_)));
    }

    protected LootTable.Builder createPotFlowerItemTable(ItemLike p_249395_) {
        return LootTable.lootTable().withPool(this.applyExplosionCondition(Blocks.FLOWER_POT, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Blocks.FLOWER_POT)))).withPool(this.applyExplosionCondition(p_249395_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_249395_))));
    }

    protected LootTable.Builder createSlabItemTable(Block p_251313_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_251313_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)p_251313_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_251313_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))))));
    }

    protected <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(Block p_252154_, Property<T> p_250272_, T p_250292_) {
        return LootTable.lootTable().withPool(this.applyExplosionCondition(p_252154_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)p_252154_).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_252154_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(p_250272_, p_250292_))))));
    }

    protected LootTable.Builder createNameableBlockEntityTable(Block p_252291_) {
        return LootTable.lootTable().withPool(this.applyExplosionCondition(p_252291_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_252291_).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME)))));
    }

    protected LootTable.Builder createShulkerBoxDrop(Block p_252164_) {
        return LootTable.lootTable().withPool(this.applyExplosionCondition(p_252164_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_252164_).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME).include(DataComponents.CONTAINER).include(DataComponents.LOCK).include(DataComponents.CONTAINER_LOOT)))));
    }

    protected LootTable.Builder createCopperOreDrops(Block p_251306_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_251306_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_251306_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.RAW_COPPER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createLapisOreDrops(Block p_251511_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_251511_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_251511_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.LAPIS_LAZULI).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)9.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createRedstoneOreDrops(Block p_251906_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_251906_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_251906_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)5.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createBannerDrop(Block p_249810_) {
        return LootTable.lootTable().withPool(this.applyExplosionCondition(p_249810_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_249810_).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.CUSTOM_NAME).include(DataComponents.ITEM_NAME).include(DataComponents.HIDE_ADDITIONAL_TOOLTIP).include(DataComponents.BANNER_PATTERNS)))));
    }

    protected LootTable.Builder createBeeNestDrop(Block p_250988_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(this.hasSilkTouch()).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_250988_).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BEES)).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)p_250988_).copy((Property)BeehiveBlock.HONEY_LEVEL))));
    }

    protected LootTable.Builder createBeeHiveDrop(Block p_248770_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)p_248770_).when(this.hasSilkTouch())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BEES)).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)p_248770_).copy((Property)BeehiveBlock.HONEY_LEVEL)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)p_248770_))));
    }

    protected LootTable.Builder createCaveVinesDrop(Block p_251070_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.GLOW_BERRIES)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_251070_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CaveVines.BERRIES, true))));
    }

    protected LootTable.Builder createOreDrop(Block p_250450_, Item p_249745_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(p_250450_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_250450_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)p_249745_).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected LootTable.Builder createMushroomBlockDrop(Block p_249959_, ItemLike p_249315_) {
        return this.createSilkTouchDispatchTable(p_249959_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_249959_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)p_249315_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)-6.0f, (float)2.0f))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0)))));
    }

    protected LootTable.Builder createGrassDrops(Block p_252139_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createShearsDispatchTable(p_252139_, (LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_252139_, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (int)2))));
    }

    public LootTable.Builder createStemDrops(Block p_250957_, Item p_249098_) {
        return LootTable.lootTable().withPool(this.applyExplosionDecay(p_250957_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)p_249098_).apply((Iterable)StemBlock.AGE.getPossibleValues(), p_249795_ -> SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)((float)(p_249795_ + 1) / 15.0f))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_250957_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)StemBlock.AGE, p_249795_.intValue())))))));
    }

    public LootTable.Builder createAttachedStemDrops(Block p_249778_, Item p_250678_) {
        return LootTable.lootTable().withPool(this.applyExplosionDecay(p_249778_, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_250678_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.53333336f))))));
    }

    protected static LootTable.Builder createShearsOnlyDrop(ItemLike p_250684_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_250684_)));
    }

    protected LootTable.Builder createMultifaceBlockDrops(Block p_249088_, LootItemCondition.Builder p_251535_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_249088_, (FunctionUserBuilder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)p_249088_).when(p_251535_)).apply((Object[])Direction.values(), p_251536_ -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_249088_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MultifaceBlock.getFaceProperty((Direction)p_251536_), true))))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)-1.0f), (boolean)true)))));
    }

    protected LootTable.Builder createLeavesDrops(Block p_250088_, Block p_250731_, float ... p_248949_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(p_250088_, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition(p_250088_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)p_250731_))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])p_248949_))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay(p_250088_, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES))));
    }

    protected LootTable.Builder createOakLeavesDrops(Block p_249535_, Block p_251505_, float ... p_250753_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createLeavesDrops(p_249535_, p_251505_, p_250753_).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition(p_249535_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.APPLE))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    protected LootTable.Builder createMangroveLeavesDrops(Block p_251103_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(p_251103_, ((LootPoolSingletonContainer.Builder)this.applyExplosionDecay(Blocks.MANGROVE_LEAVES, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])NORMAL_LEAVES_STICK_CHANCES)));
    }

    protected LootTable.Builder createCropDrops(Block p_249457_, Item p_248599_, Item p_251915_, LootItemCondition.Builder p_252202_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.applyExplosionDecay(p_249457_, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder<?>)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)p_248599_).when(p_252202_)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)p_251915_)))).withPool(LootPool.lootPool().when(p_252202_).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_251915_).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3)))));
    }

    protected LootTable.Builder createDoublePlantShearsDrop(Block p_248678_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(HAS_SHEARS).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_248678_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))));
    }

    protected LootTable.Builder createDoublePlantWithSeedDrops(Block p_248590_, Block p_248735_) {
        AlternativesEntry.Builder builder = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)p_248735_).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f))).when(HAS_SHEARS)).otherwise(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition(p_248590_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)Items.WHEAT_SEEDS))).when(LootItemRandomChanceCondition.randomChance((float)0.125f)));
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder<?>)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_248590_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{p_248590_}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder<?>)builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_248590_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{p_248590_}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    protected LootTable.Builder createCandleDrops(Block p_250896_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_250896_, LootItem.lootTableItem((ItemLike)p_250896_).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), p_249985_ -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)p_249985_.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_250896_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CandleBlock.CANDLES, p_249985_.intValue())))))));
    }

    protected LootTable.Builder createPetalsDrops(Block p_273240_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay(p_273240_, LootItem.lootTableItem((ItemLike)p_273240_).apply(IntStream.rangeClosed(1, 4).boxed().toList(), p_272348_ -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)p_272348_.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)p_273240_).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PinkPetalsBlock.AMOUNT, p_272348_.intValue())))))));
    }

    protected static LootTable.Builder createCandleCakeDrops(Block p_250280_) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)p_250280_)));
    }

    public static LootTable.Builder noDrop() {
        return LootTable.lootTable();
    }

    protected abstract void generate();

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK;
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> p_249322_) {
        this.generate();
        HashSet<ResourceKey<LootTable>> set = new HashSet<ResourceKey<LootTable>>();
        for (Block block : this.getKnownBlocks()) {
            ResourceKey<LootTable> resourcekey;
            if (!block.isEnabled(this.enabledFeatures) || (resourcekey = block.getLootTable()) == BuiltInLootTables.EMPTY || !set.add(resourcekey)) continue;
            LootTable.Builder loottable$builder = this.map.remove(resourcekey);
            if (loottable$builder == null) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourcekey.location(), BuiltInRegistries.BLOCK.getKey((Object)block)));
            }
            p_249322_.accept(resourcekey, loottable$builder);
        }
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created block loot tables for non-blocks: " + String.valueOf(this.map.keySet()));
        }
    }

    protected void addNetherVinesDropTable(Block p_252269_, Block p_250696_) {
        HolderLookup.RegistryLookup<Enchantment> registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        LootTable.Builder loottable$builder = this.createSilkTouchOrShearsDispatchTable(p_252269_, LootItem.lootTableItem((ItemLike)p_252269_).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.33f, 0.55f, 0.77f, 1.0f})));
        this.add(p_252269_, loottable$builder);
        this.add(p_250696_, loottable$builder);
    }

    protected LootTable.Builder createDoorTable(Block p_252166_) {
        return this.createSinglePropConditionTable(p_252166_, (Property)DoorBlock.HALF, (Comparable<T> & StringRepresentable)DoubleBlockHalf.LOWER);
    }

    protected void dropPottedContents(Block p_251064_) {
        this.add(p_251064_, (Block p_304146_) -> this.createPotFlowerItemTable(((FlowerPotBlock)p_304146_).getPotted()));
    }

    protected void otherWhenSilkTouch(Block p_249932_, Block p_252053_) {
        this.add(p_249932_, this.createSilkTouchOnlyTable(p_252053_));
    }

    protected void dropOther(Block p_248885_, ItemLike p_251883_) {
        this.add(p_248885_, this.createSingleItemTable(p_251883_));
    }

    protected void dropWhenSilkTouch(Block p_250855_) {
        this.otherWhenSilkTouch(p_250855_, p_250855_);
    }

    protected void dropSelf(Block p_249181_) {
        this.dropOther(p_249181_, p_249181_);
    }

    protected void add(Block p_251966_, Function<Block, LootTable.Builder> p_251699_) {
        this.add(p_251966_, p_251699_.apply(p_251966_));
    }

    protected void add(Block p_250610_, LootTable.Builder p_249817_) {
        this.map.put(p_250610_.getLootTable(), p_249817_);
    }
}

