/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.StringRepresentable;

public class ClickEvent {
    public static final Codec<ClickEvent> CODEC = RecordCodecBuilder.create(p_304457_ -> p_304457_.group((App)Action.CODEC.forGetter(p_304573_ -> p_304573_.action), (App)Codec.STRING.fieldOf("value").forGetter(p_304481_ -> p_304481_.value)).apply((Applicative)p_304457_, ClickEvent::new));
    private final Action action;
    private final String value;

    public ClickEvent(Action p_130620_, String p_130621_) {
        this.action = p_130620_;
        this.value = p_130621_;
    }

    public Action getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object p_130625_) {
        if (this == p_130625_) {
            return true;
        }
        if (p_130625_ == null || this.getClass() != p_130625_.getClass()) {
            return false;
        }
        ClickEvent $$1 = (ClickEvent)p_130625_;
        return this.action == $$1.action && this.value.equals($$1.value);
    }

    public String toString() {
        return "ClickEvent{action=" + String.valueOf(this.action) + ", value='" + this.value + "'}";
    }

    public int hashCode() {
        int $$0 = this.action.hashCode();
        $$0 = 31 * $$0 + this.value.hashCode();
        return $$0;
    }

    public static enum Action implements StringRepresentable
    {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true),
        COPY_TO_CLIPBOARD("copy_to_clipboard", true);

        public static final MapCodec<Action> UNSAFE_CODEC;
        public static final MapCodec<Action> CODEC;
        private final boolean allowFromServer;
        private final String name;

        private Action(String p_130642_, boolean p_130643_) {
            this.name = p_130642_;
            this.allowFromServer = p_130643_;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static DataResult<Action> filterForSerialization(Action p_304789_) {
            if (!p_304789_.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf(p_304789_));
            }
            return DataResult.success((Object)p_304789_, (Lifecycle)Lifecycle.stable());
        }

        static {
            UNSAFE_CODEC = StringRepresentable.fromEnum(Action::values).fieldOf("action");
            CODEC = UNSAFE_CODEC.validate(Action::filterForSerialization);
        }
    }
}

