/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.searchtree;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.searchtree.SuffixArray;
import net.minecraft.resources.ResourceLocation;

public interface ResourceLocationSearchTree<T> {
    public static <T> ResourceLocationSearchTree<T> empty() {
        return new ResourceLocationSearchTree<T>(){

            @Override
            public List<T> searchNamespace(String p_235218_) {
                return List.of();
            }

            @Override
            public List<T> searchPath(String p_235220_) {
                return List.of();
            }
        };
    }

    public static <T> ResourceLocationSearchTree<T> create(List<T> p_235213_, Function<T, Stream<ResourceLocation>> p_235214_) {
        if (p_235213_.isEmpty()) {
            return ResourceLocationSearchTree.empty();
        }
        final SuffixArray $$2 = new SuffixArray();
        final SuffixArray $$3 = new SuffixArray();
        for (Object $$4 : p_235213_) {
            p_235214_.apply($$4).forEach(p_235210_ -> {
                $$2.add($$4, p_235210_.getNamespace().toLowerCase(Locale.ROOT));
                $$3.add($$4, p_235210_.getPath().toLowerCase(Locale.ROOT));
            });
        }
        $$2.generate();
        $$3.generate();
        return new ResourceLocationSearchTree<T>(){

            @Override
            public List<T> searchNamespace(String p_235227_) {
                return $$2.search(p_235227_);
            }

            @Override
            public List<T> searchPath(String p_235229_) {
                return $$3.search(p_235229_);
            }
        };
    }

    public List<T> searchNamespace(String var1);

    public List<T> searchPath(String var1);
}

