/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.slf4j.Logger;

public abstract class LivingEntityRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float EYE_BED_OFFSET = 0.1f;
    protected M model;
    protected final List<RenderLayer<T, M>> layers = Lists.newArrayList();

    public LivingEntityRenderer(EntityRendererProvider.Context p_174289_, M p_174290_, float p_174291_) {
        super(p_174289_);
        this.model = p_174290_;
        this.shadowRadius = p_174291_;
    }

    protected final boolean addLayer(RenderLayer<T, M> p_115327_) {
        return this.layers.add(p_115327_);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public void render(T p_115308_, float p_115309_, float p_115310_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        Direction $$12;
        Entity entity;
        p_115311_.pushPose();
        ((EntityModel)this.model).attackTime = this.getAttackAnim(p_115308_, p_115310_);
        ((EntityModel)this.model).riding = ((Entity)p_115308_).isPassenger();
        ((EntityModel)this.model).young = ((LivingEntity)p_115308_).isBaby();
        float $$6 = Mth.rotLerp(p_115310_, ((LivingEntity)p_115308_).yBodyRotO, ((LivingEntity)p_115308_).yBodyRot);
        float $$7 = Mth.rotLerp(p_115310_, ((LivingEntity)p_115308_).yHeadRotO, ((LivingEntity)p_115308_).yHeadRot);
        float $$8 = $$7 - $$6;
        if (((Entity)p_115308_).isPassenger() && (entity = ((Entity)p_115308_).getVehicle()) instanceof LivingEntity) {
            LivingEntity $$9 = (LivingEntity)entity;
            $$6 = Mth.rotLerp(p_115310_, $$9.yBodyRotO, $$9.yBodyRot);
            $$8 = $$7 - $$6;
            float $$10 = Mth.wrapDegrees($$8);
            if ($$10 < -85.0f) {
                $$10 = -85.0f;
            }
            if ($$10 >= 85.0f) {
                $$10 = 85.0f;
            }
            $$6 = $$7 - $$10;
            if ($$10 * $$10 > 2500.0f) {
                $$6 += $$10 * 0.2f;
            }
            $$8 = $$7 - $$6;
        }
        float $$11 = Mth.lerp(p_115310_, ((LivingEntity)p_115308_).xRotO, ((Entity)p_115308_).getXRot());
        if (LivingEntityRenderer.isEntityUpsideDown(p_115308_)) {
            $$11 *= -1.0f;
            $$8 *= -1.0f;
        }
        $$8 = Mth.wrapDegrees($$8);
        if (((Entity)p_115308_).hasPose(Pose.SLEEPING) && ($$12 = ((LivingEntity)p_115308_).getBedOrientation()) != null) {
            float $$13 = ((Entity)p_115308_).getEyeHeight(Pose.STANDING) - 0.1f;
            p_115311_.translate((float)(-$$12.getStepX()) * $$13, 0.0f, (float)(-$$12.getStepZ()) * $$13);
        }
        float $$14 = ((LivingEntity)p_115308_).getScale();
        p_115311_.scale($$14, $$14, $$14);
        float $$15 = this.getBob(p_115308_, p_115310_);
        this.setupRotations(p_115308_, p_115311_, $$15, $$6, p_115310_, $$14);
        p_115311_.scale(-1.0f, -1.0f, 1.0f);
        this.scale(p_115308_, p_115311_, p_115310_);
        p_115311_.translate(0.0f, -1.501f, 0.0f);
        float $$16 = 0.0f;
        float $$17 = 0.0f;
        if (!((Entity)p_115308_).isPassenger() && ((LivingEntity)p_115308_).isAlive()) {
            $$16 = ((LivingEntity)p_115308_).walkAnimation.speed(p_115310_);
            $$17 = ((LivingEntity)p_115308_).walkAnimation.position(p_115310_);
            if (((LivingEntity)p_115308_).isBaby()) {
                $$17 *= 3.0f;
            }
            if ($$16 > 1.0f) {
                $$16 = 1.0f;
            }
        }
        ((EntityModel)this.model).prepareMobModel(p_115308_, $$17, $$16, p_115310_);
        ((EntityModel)this.model).setupAnim(p_115308_, $$17, $$16, $$15, $$8, $$11);
        Minecraft $$18 = Minecraft.getInstance();
        boolean $$19 = this.isBodyVisible(p_115308_);
        boolean $$20 = !$$19 && !((Entity)p_115308_).isInvisibleTo($$18.player);
        boolean $$21 = $$18.shouldEntityAppearGlowing((Entity)p_115308_);
        RenderType $$22 = this.getRenderType(p_115308_, $$19, $$20, $$21);
        if ($$22 != null) {
            VertexConsumer $$23 = p_115312_.getBuffer($$22);
            int $$24 = LivingEntityRenderer.getOverlayCoords(p_115308_, this.getWhiteOverlayProgress(p_115308_, p_115310_));
            ((Model)this.model).renderToBuffer(p_115311_, $$23, p_115313_, $$24, $$20 ? 0x26FFFFFF : -1);
        }
        if (!((Entity)p_115308_).isSpectator()) {
            for (RenderLayer<T, M> $$25 : this.layers) {
                $$25.render(p_115311_, p_115312_, p_115313_, p_115308_, $$17, $$16, p_115310_, $$15, $$8, $$11);
            }
        }
        p_115311_.popPose();
        super.render(p_115308_, p_115309_, p_115310_, p_115311_, p_115312_, p_115313_);
    }

    @Nullable
    protected RenderType getRenderType(T p_115322_, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation $$4 = this.getTextureLocation(p_115322_);
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull($$4);
        }
        if (p_115323_) {
            return ((Model)this.model).renderType($$4);
        }
        if (p_115325_) {
            return RenderType.outline($$4);
        }
        return null;
    }

    public static int getOverlayCoords(LivingEntity p_115339_, float p_115340_) {
        return OverlayTexture.pack(OverlayTexture.u(p_115340_), OverlayTexture.v(p_115339_.hurtTime > 0 || p_115339_.deathTime > 0));
    }

    protected boolean isBodyVisible(T p_115341_) {
        return !((Entity)p_115341_).isInvisible();
    }

    private static float sleepDirectionToRotation(Direction p_115329_) {
        switch (p_115329_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    protected boolean isShaking(T p_115304_) {
        return ((Entity)p_115304_).isFullyFrozen();
    }

    protected void setupRotations(T p_115317_, PoseStack p_115318_, float p_115319_, float p_115320_, float p_115321_, float p_320045_) {
        if (this.isShaking(p_115317_)) {
            p_115320_ += (float)(Math.cos((double)((LivingEntity)p_115317_).tickCount * 3.25) * Math.PI * (double)0.4f);
        }
        if (!((Entity)p_115317_).hasPose(Pose.SLEEPING)) {
            p_115318_.mulPose(Axis.YP.rotationDegrees(180.0f - p_115320_));
        }
        if (((LivingEntity)p_115317_).deathTime > 0) {
            float $$6 = ((float)((LivingEntity)p_115317_).deathTime + p_115321_ - 1.0f) / 20.0f * 1.6f;
            if (($$6 = Mth.sqrt($$6)) > 1.0f) {
                $$6 = 1.0f;
            }
            p_115318_.mulPose(Axis.ZP.rotationDegrees($$6 * this.getFlipDegrees(p_115317_)));
        } else if (((LivingEntity)p_115317_).isAutoSpinAttack()) {
            p_115318_.mulPose(Axis.XP.rotationDegrees(-90.0f - ((Entity)p_115317_).getXRot()));
            p_115318_.mulPose(Axis.YP.rotationDegrees(((float)((LivingEntity)p_115317_).tickCount + p_115321_) * -75.0f));
        } else if (((Entity)p_115317_).hasPose(Pose.SLEEPING)) {
            Direction $$7 = ((LivingEntity)p_115317_).getBedOrientation();
            float $$8 = $$7 != null ? LivingEntityRenderer.sleepDirectionToRotation($$7) : p_115320_;
            p_115318_.mulPose(Axis.YP.rotationDegrees($$8));
            p_115318_.mulPose(Axis.ZP.rotationDegrees(this.getFlipDegrees(p_115317_)));
            p_115318_.mulPose(Axis.YP.rotationDegrees(270.0f));
        } else if (LivingEntityRenderer.isEntityUpsideDown(p_115317_)) {
            p_115318_.translate(0.0f, (((Entity)p_115317_).getBbHeight() + 0.1f) / p_320045_, 0.0f);
            p_115318_.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected float getAttackAnim(T p_115343_, float p_115344_) {
        return ((LivingEntity)p_115343_).getAttackAnim(p_115344_);
    }

    protected float getBob(T p_115305_, float p_115306_) {
        return (float)((LivingEntity)p_115305_).tickCount + p_115306_;
    }

    protected float getFlipDegrees(T p_115337_) {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(T p_115334_, float p_115335_) {
        return 0.0f;
    }

    protected void scale(T p_115314_, PoseStack p_115315_, float p_115316_) {
    }

    @Override
    protected boolean shouldShowName(T p_115333_) {
        boolean $$5;
        float $$2;
        double $$1 = this.entityRenderDispatcher.distanceToSqr((Entity)p_115333_);
        float f = $$2 = ((Entity)p_115333_).isDiscrete() ? 32.0f : 64.0f;
        if ($$1 >= (double)($$2 * $$2)) {
            return false;
        }
        Minecraft $$3 = Minecraft.getInstance();
        LocalPlayer $$4 = $$3.player;
        boolean bl = $$5 = !((Entity)p_115333_).isInvisibleTo($$4);
        if (p_115333_ != $$4) {
            PlayerTeam $$6 = ((Entity)p_115333_).getTeam();
            PlayerTeam $$7 = $$4.getTeam();
            if ($$6 != null) {
                Team.Visibility $$8 = ((Team)$$6).getNameTagVisibility();
                switch ($$8) {
                    case ALWAYS: {
                        return $$5;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return $$7 == null ? $$5 : $$6.isAlliedTo($$7) && (((Team)$$6).canSeeFriendlyInvisibles() || $$5);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return $$7 == null ? $$5 : !$$6.isAlliedTo($$7) && $$5;
                    }
                }
                return true;
            }
        }
        return Minecraft.renderNames() && p_115333_ != $$3.getCameraEntity() && $$5 && !((Entity)p_115333_).isVehicle();
    }

    public static boolean isEntityUpsideDown(LivingEntity p_194454_) {
        String $$1;
        if ((p_194454_ instanceof Player || p_194454_.hasCustomName()) && ("Dinnerbone".equals($$1 = ChatFormatting.stripFormatting(p_194454_.getName().getString())) || "Grumm".equals($$1))) {
            return !(p_194454_ instanceof Player) || ((Player)p_194454_).isModelPartShown(PlayerModelPart.CAPE);
        }
        return false;
    }

    @Override
    protected float getShadowRadius(T p_316722_) {
        return super.getShadowRadius(p_316722_) * ((LivingEntity)p_316722_).getScale();
    }

    @Override
    protected /* synthetic */ float getShadowRadius(Entity entity) {
        return this.getShadowRadius((T)((LivingEntity)entity));
    }
}

