/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.slf4j.Logger;

public class GameRenderer
implements AutoCloseable {
    private static final ResourceLocation NAUSEA_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/nausea.png");
    private static final ResourceLocation BLUR_LOCATION = ResourceLocation.withDefaultNamespace("shaders/post/blur.json");
    public static final int MAX_BLUR_RADIUS = 10;
    static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEPTH_BUFFER_DEBUG = false;
    public static final float PROJECTION_Z_NEAR = 0.05f;
    private static final float GUI_Z_NEAR = 1000.0f;
    final Minecraft minecraft;
    private final ResourceManager resourceManager;
    private final RandomSource random = RandomSource.create();
    private float renderDistance;
    public final ItemInHandRenderer itemInHandRenderer;
    private final MapRenderer mapRenderer;
    private final RenderBuffers renderBuffers;
    private int confusionAnimationTick;
    private float fov;
    private float oldFov;
    private float darkenWorldAmount;
    private float darkenWorldAmountO;
    private boolean renderHand = true;
    private boolean renderBlockOutline = true;
    private long lastScreenshotAttempt;
    private boolean hasWorldScreenshot;
    private long lastActiveTime = Util.getMillis();
    private final LightTexture lightTexture;
    private final OverlayTexture overlayTexture = new OverlayTexture();
    private boolean panoramicMode;
    private float zoom = 1.0f;
    private float zoomX;
    private float zoomY;
    public static final int ITEM_ACTIVATION_ANIMATION_LENGTH = 40;
    @Nullable
    private ItemStack itemActivationItem;
    private int itemActivationTicks;
    private float itemActivationOffX;
    private float itemActivationOffY;
    @Nullable
    PostChain postEffect;
    @Nullable
    private PostChain blurEffect;
    private boolean effectActive;
    private final Camera mainCamera = new Camera();
    @Nullable
    public ShaderInstance blitShader;
    private final Map<String, ShaderInstance> shaders = Maps.newHashMap();
    @Nullable
    private static ShaderInstance positionShader;
    @Nullable
    private static ShaderInstance positionColorShader;
    @Nullable
    private static ShaderInstance positionTexShader;
    @Nullable
    private static ShaderInstance positionTexColorShader;
    @Nullable
    private static ShaderInstance particleShader;
    @Nullable
    private static ShaderInstance positionColorLightmapShader;
    @Nullable
    private static ShaderInstance positionColorTexLightmapShader;
    @Nullable
    private static ShaderInstance rendertypeSolidShader;
    @Nullable
    private static ShaderInstance rendertypeCutoutMippedShader;
    @Nullable
    private static ShaderInstance rendertypeCutoutShader;
    @Nullable
    private static ShaderInstance rendertypeTranslucentShader;
    @Nullable
    private static ShaderInstance rendertypeTranslucentMovingBlockShader;
    @Nullable
    private static ShaderInstance rendertypeArmorCutoutNoCullShader;
    @Nullable
    private static ShaderInstance rendertypeEntitySolidShader;
    @Nullable
    private static ShaderInstance rendertypeEntityCutoutShader;
    @Nullable
    private static ShaderInstance rendertypeEntityCutoutNoCullShader;
    @Nullable
    private static ShaderInstance rendertypeEntityCutoutNoCullZOffsetShader;
    @Nullable
    private static ShaderInstance rendertypeItemEntityTranslucentCullShader;
    @Nullable
    private static ShaderInstance rendertypeEntityTranslucentCullShader;
    @Nullable
    private static ShaderInstance rendertypeEntityTranslucentShader;
    @Nullable
    private static ShaderInstance rendertypeEntityTranslucentEmissiveShader;
    @Nullable
    private static ShaderInstance rendertypeEntitySmoothCutoutShader;
    @Nullable
    private static ShaderInstance rendertypeBeaconBeamShader;
    @Nullable
    private static ShaderInstance rendertypeEntityDecalShader;
    @Nullable
    private static ShaderInstance rendertypeEntityNoOutlineShader;
    @Nullable
    private static ShaderInstance rendertypeEntityShadowShader;
    @Nullable
    private static ShaderInstance rendertypeEntityAlphaShader;
    @Nullable
    private static ShaderInstance rendertypeEyesShader;
    @Nullable
    private static ShaderInstance rendertypeEnergySwirlShader;
    @Nullable
    private static ShaderInstance rendertypeBreezeWindShader;
    @Nullable
    private static ShaderInstance rendertypeLeashShader;
    @Nullable
    private static ShaderInstance rendertypeWaterMaskShader;
    @Nullable
    private static ShaderInstance rendertypeOutlineShader;
    @Nullable
    private static ShaderInstance rendertypeArmorGlintShader;
    @Nullable
    private static ShaderInstance rendertypeArmorEntityGlintShader;
    @Nullable
    private static ShaderInstance rendertypeGlintTranslucentShader;
    @Nullable
    private static ShaderInstance rendertypeGlintShader;
    @Nullable
    private static ShaderInstance rendertypeGlintDirectShader;
    @Nullable
    private static ShaderInstance rendertypeEntityGlintShader;
    @Nullable
    private static ShaderInstance rendertypeEntityGlintDirectShader;
    @Nullable
    private static ShaderInstance rendertypeTextShader;
    @Nullable
    private static ShaderInstance rendertypeTextBackgroundShader;
    @Nullable
    private static ShaderInstance rendertypeTextIntensityShader;
    @Nullable
    private static ShaderInstance rendertypeTextSeeThroughShader;
    @Nullable
    private static ShaderInstance rendertypeTextBackgroundSeeThroughShader;
    @Nullable
    private static ShaderInstance rendertypeTextIntensitySeeThroughShader;
    @Nullable
    private static ShaderInstance rendertypeLightningShader;
    @Nullable
    private static ShaderInstance rendertypeTripwireShader;
    @Nullable
    private static ShaderInstance rendertypeEndPortalShader;
    @Nullable
    private static ShaderInstance rendertypeEndGatewayShader;
    @Nullable
    private static ShaderInstance rendertypeCloudsShader;
    @Nullable
    private static ShaderInstance rendertypeLinesShader;
    @Nullable
    private static ShaderInstance rendertypeCrumblingShader;
    @Nullable
    private static ShaderInstance rendertypeGuiShader;
    @Nullable
    private static ShaderInstance rendertypeGuiOverlayShader;
    @Nullable
    private static ShaderInstance rendertypeGuiTextHighlightShader;
    @Nullable
    private static ShaderInstance rendertypeGuiGhostRecipeOverlayShader;

    public GameRenderer(Minecraft p_234219_, ItemInHandRenderer p_234220_, ResourceManager p_234221_, RenderBuffers p_234222_) {
        this.minecraft = p_234219_;
        this.resourceManager = p_234221_;
        this.itemInHandRenderer = p_234220_;
        this.mapRenderer = new MapRenderer(p_234219_.getTextureManager(), p_234219_.getMapDecorationTextures());
        this.lightTexture = new LightTexture(this, p_234219_);
        this.renderBuffers = p_234222_;
        this.postEffect = null;
    }

    @Override
    public void close() {
        this.lightTexture.close();
        this.mapRenderer.close();
        this.overlayTexture.close();
        this.shutdownEffect();
        this.shutdownShaders();
        if (this.blurEffect != null) {
            this.blurEffect.close();
        }
        if (this.blitShader != null) {
            this.blitShader.close();
        }
    }

    public void setRenderHand(boolean p_172737_) {
        this.renderHand = p_172737_;
    }

    public void setRenderBlockOutline(boolean p_172776_) {
        this.renderBlockOutline = p_172776_;
    }

    public void setPanoramicMode(boolean p_172780_) {
        this.panoramicMode = p_172780_;
    }

    public boolean isPanoramicMode() {
        return this.panoramicMode;
    }

    public void shutdownEffect() {
        if (this.postEffect != null) {
            this.postEffect.close();
        }
        this.postEffect = null;
    }

    public void togglePostEffect() {
        this.effectActive = !this.effectActive;
    }

    public void checkEntityPostEffect(@Nullable Entity p_109107_) {
        if (this.postEffect != null) {
            this.postEffect.close();
        }
        this.postEffect = null;
        if (p_109107_ instanceof Creeper) {
            this.loadEffect(ResourceLocation.withDefaultNamespace("shaders/post/creeper.json"));
        } else if (p_109107_ instanceof Spider) {
            this.loadEffect(ResourceLocation.withDefaultNamespace("shaders/post/spider.json"));
        } else if (p_109107_ instanceof EnderMan) {
            this.loadEffect(ResourceLocation.withDefaultNamespace("shaders/post/invert.json"));
        }
    }

    private void loadEffect(ResourceLocation p_109129_) {
        if (this.postEffect != null) {
            this.postEffect.close();
        }
        try {
            this.postEffect = new PostChain(this.minecraft.getTextureManager(), this.resourceManager, this.minecraft.getMainRenderTarget(), p_109129_);
            this.postEffect.resize(this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight());
            this.effectActive = true;
        }
        catch (IOException $$1) {
            LOGGER.warn("Failed to load shader: {}", (Object)p_109129_, (Object)$$1);
            this.effectActive = false;
        }
        catch (JsonSyntaxException $$2) {
            LOGGER.warn("Failed to parse shader: {}", (Object)p_109129_, (Object)$$2);
            this.effectActive = false;
        }
    }

    private void loadBlurEffect(ResourceProvider p_341650_) {
        if (this.blurEffect != null) {
            this.blurEffect.close();
        }
        try {
            this.blurEffect = new PostChain(this.minecraft.getTextureManager(), p_341650_, this.minecraft.getMainRenderTarget(), BLUR_LOCATION);
            this.blurEffect.resize(this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight());
        }
        catch (IOException $$1) {
            LOGGER.warn("Failed to load shader: {}", (Object)BLUR_LOCATION, (Object)$$1);
        }
        catch (JsonSyntaxException $$2) {
            LOGGER.warn("Failed to parse shader: {}", (Object)BLUR_LOCATION, (Object)$$2);
        }
    }

    public void processBlurEffect(float p_331160_) {
        float $$1 = this.minecraft.options.getMenuBackgroundBlurriness();
        if (this.blurEffect != null && $$1 >= 1.0f) {
            this.blurEffect.setUniform("Radius", $$1);
            this.blurEffect.process(p_331160_);
        }
    }

    public PreparableReloadListener createReloadListener() {
        return new SimplePreparableReloadListener<ResourceCache>(){

            @Override
            protected ResourceCache prepare(ResourceManager p_251213_, ProfilerFiller p_251006_) {
                Map<ResourceLocation, Resource> $$2 = p_251213_.listResources("shaders", p_251575_ -> {
                    String $$1 = p_251575_.getPath();
                    return $$1.endsWith(".json") || $$1.endsWith(Program.Type.FRAGMENT.getExtension()) || $$1.endsWith(Program.Type.VERTEX.getExtension()) || $$1.endsWith(".glsl");
                });
                HashMap<ResourceLocation, Resource> $$3 = new HashMap<ResourceLocation, Resource>();
                $$2.forEach((p_250354_, p_250712_) -> {
                    try (InputStream $$3 = p_250712_.open();){
                        byte[] $$4 = $$3.readAllBytes();
                        $$3.put((ResourceLocation)p_250354_, new Resource(p_250712_.source(), () -> new ByteArrayInputStream($$4)));
                    }
                    catch (Exception $$5) {
                        LOGGER.warn("Failed to read resource {}", p_250354_, (Object)$$5);
                    }
                });
                return new ResourceCache(p_251213_, $$3);
            }

            @Override
            protected void apply(ResourceCache p_251168_, ResourceManager p_248902_, ProfilerFiller p_251909_) {
                GameRenderer.this.reloadShaders(p_251168_);
                if (GameRenderer.this.postEffect != null) {
                    GameRenderer.this.postEffect.close();
                }
                GameRenderer.this.postEffect = null;
                GameRenderer.this.checkEntityPostEffect(GameRenderer.this.minecraft.getCameraEntity());
            }

            @Override
            public String getName() {
                return "Shader Loader";
            }

            @Override
            protected /* synthetic */ Object prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
                return this.prepare(resourceManager, profilerFiller);
            }
        };
    }

    public void preloadUiShader(ResourceProvider p_172723_) {
        if (this.blitShader != null) {
            throw new RuntimeException("Blit shader already preloaded");
        }
        try {
            this.blitShader = new ShaderInstance(p_172723_, "blit_screen", DefaultVertexFormat.BLIT_SCREEN);
        }
        catch (IOException $$1) {
            throw new RuntimeException("could not preload blit shader", $$1);
        }
        rendertypeGuiShader = this.preloadShader(p_172723_, "rendertype_gui", DefaultVertexFormat.POSITION_COLOR);
        rendertypeGuiOverlayShader = this.preloadShader(p_172723_, "rendertype_gui_overlay", DefaultVertexFormat.POSITION_COLOR);
        positionShader = this.preloadShader(p_172723_, "position", DefaultVertexFormat.POSITION);
        positionColorShader = this.preloadShader(p_172723_, "position_color", DefaultVertexFormat.POSITION_COLOR);
        positionTexShader = this.preloadShader(p_172723_, "position_tex", DefaultVertexFormat.POSITION_TEX);
        positionTexColorShader = this.preloadShader(p_172723_, "position_tex_color", DefaultVertexFormat.POSITION_TEX_COLOR);
        rendertypeTextShader = this.preloadShader(p_172723_, "rendertype_text", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP);
    }

    private ShaderInstance preloadShader(ResourceProvider p_172725_, String p_172726_, VertexFormat p_172727_) {
        try {
            ShaderInstance $$3 = new ShaderInstance(p_172725_, p_172726_, p_172727_);
            this.shaders.put(p_172726_, $$3);
            return $$3;
        }
        catch (Exception $$4) {
            throw new IllegalStateException("could not preload shader " + p_172726_, $$4);
        }
    }

    void reloadShaders(ResourceProvider p_250719_) {
        RenderSystem.assertOnRenderThread();
        ArrayList $$1 = Lists.newArrayList();
        $$1.addAll(Program.Type.FRAGMENT.getPrograms().values());
        $$1.addAll(Program.Type.VERTEX.getPrograms().values());
        $$1.forEach(Program::close);
        ArrayList $$2 = Lists.newArrayListWithCapacity((int)this.shaders.size());
        try {
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "particle", DefaultVertexFormat.PARTICLE), p_172714_ -> {
                particleShader = p_172714_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "position", DefaultVertexFormat.POSITION), p_172711_ -> {
                positionShader = p_172711_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "position_color", DefaultVertexFormat.POSITION_COLOR), p_172708_ -> {
                positionColorShader = p_172708_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "position_color_lightmap", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP), p_172705_ -> {
                positionColorLightmapShader = p_172705_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "position_color_tex_lightmap", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), p_172699_ -> {
                positionColorTexLightmapShader = p_172699_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "position_tex", DefaultVertexFormat.POSITION_TEX), p_172696_ -> {
                positionTexShader = p_172696_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "position_tex_color", DefaultVertexFormat.POSITION_TEX_COLOR), p_172693_ -> {
                positionTexColorShader = p_172693_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_solid", DefaultVertexFormat.BLOCK), p_172684_ -> {
                rendertypeSolidShader = p_172684_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_cutout_mipped", DefaultVertexFormat.BLOCK), p_172681_ -> {
                rendertypeCutoutMippedShader = p_172681_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_cutout", DefaultVertexFormat.BLOCK), p_172678_ -> {
                rendertypeCutoutShader = p_172678_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_translucent", DefaultVertexFormat.BLOCK), p_172675_ -> {
                rendertypeTranslucentShader = p_172675_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_translucent_moving_block", DefaultVertexFormat.BLOCK), p_172672_ -> {
                rendertypeTranslucentMovingBlockShader = p_172672_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_armor_cutout_no_cull", DefaultVertexFormat.NEW_ENTITY), p_172666_ -> {
                rendertypeArmorCutoutNoCullShader = p_172666_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_solid", DefaultVertexFormat.NEW_ENTITY), p_172663_ -> {
                rendertypeEntitySolidShader = p_172663_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_cutout", DefaultVertexFormat.NEW_ENTITY), p_172660_ -> {
                rendertypeEntityCutoutShader = p_172660_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_cutout_no_cull", DefaultVertexFormat.NEW_ENTITY), p_172657_ -> {
                rendertypeEntityCutoutNoCullShader = p_172657_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_cutout_no_cull_z_offset", DefaultVertexFormat.NEW_ENTITY), p_172654_ -> {
                rendertypeEntityCutoutNoCullZOffsetShader = p_172654_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_item_entity_translucent_cull", DefaultVertexFormat.NEW_ENTITY), p_172651_ -> {
                rendertypeItemEntityTranslucentCullShader = p_172651_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_translucent_cull", DefaultVertexFormat.NEW_ENTITY), p_172648_ -> {
                rendertypeEntityTranslucentCullShader = p_172648_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_translucent", DefaultVertexFormat.NEW_ENTITY), p_172645_ -> {
                rendertypeEntityTranslucentShader = p_172645_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_translucent_emissive", DefaultVertexFormat.NEW_ENTITY), p_172642_ -> {
                rendertypeEntityTranslucentEmissiveShader = p_172642_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_smooth_cutout", DefaultVertexFormat.NEW_ENTITY), p_172639_ -> {
                rendertypeEntitySmoothCutoutShader = p_172639_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_beacon_beam", DefaultVertexFormat.BLOCK), p_172840_ -> {
                rendertypeBeaconBeamShader = p_172840_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_decal", DefaultVertexFormat.NEW_ENTITY), p_172837_ -> {
                rendertypeEntityDecalShader = p_172837_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_no_outline", DefaultVertexFormat.NEW_ENTITY), p_172834_ -> {
                rendertypeEntityNoOutlineShader = p_172834_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_shadow", DefaultVertexFormat.NEW_ENTITY), p_172831_ -> {
                rendertypeEntityShadowShader = p_172831_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_alpha", DefaultVertexFormat.NEW_ENTITY), p_172828_ -> {
                rendertypeEntityAlphaShader = p_172828_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_eyes", DefaultVertexFormat.NEW_ENTITY), p_172825_ -> {
                rendertypeEyesShader = p_172825_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_energy_swirl", DefaultVertexFormat.NEW_ENTITY), p_172822_ -> {
                rendertypeEnergySwirlShader = p_172822_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_leash", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP), p_172819_ -> {
                rendertypeLeashShader = p_172819_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_water_mask", DefaultVertexFormat.POSITION), p_172816_ -> {
                rendertypeWaterMaskShader = p_172816_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_outline", DefaultVertexFormat.POSITION_TEX_COLOR), p_172813_ -> {
                rendertypeOutlineShader = p_172813_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_armor_entity_glint", DefaultVertexFormat.POSITION_TEX), p_172807_ -> {
                rendertypeArmorEntityGlintShader = p_172807_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_glint_translucent", DefaultVertexFormat.POSITION_TEX), p_172805_ -> {
                rendertypeGlintTranslucentShader = p_172805_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_glint", DefaultVertexFormat.POSITION_TEX), p_172803_ -> {
                rendertypeGlintShader = p_172803_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_glint", DefaultVertexFormat.POSITION_TEX), p_172799_ -> {
                rendertypeEntityGlintShader = p_172799_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_entity_glint_direct", DefaultVertexFormat.POSITION_TEX), p_172796_ -> {
                rendertypeEntityGlintDirectShader = p_172796_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_text", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), p_172794_ -> {
                rendertypeTextShader = p_172794_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_text_background", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP), p_269657_ -> {
                rendertypeTextBackgroundShader = p_269657_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_text_intensity", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), p_172792_ -> {
                rendertypeTextIntensityShader = p_172792_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_text_see_through", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), p_172789_ -> {
                rendertypeTextSeeThroughShader = p_172789_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_text_background_see_through", DefaultVertexFormat.POSITION_COLOR_LIGHTMAP), p_269656_ -> {
                rendertypeTextBackgroundSeeThroughShader = p_269656_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_text_intensity_see_through", DefaultVertexFormat.POSITION_COLOR_TEX_LIGHTMAP), p_172787_ -> {
                rendertypeTextIntensitySeeThroughShader = p_172787_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_lightning", DefaultVertexFormat.POSITION_COLOR), p_172785_ -> {
                rendertypeLightningShader = p_172785_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_tripwire", DefaultVertexFormat.BLOCK), p_172782_ -> {
                rendertypeTripwireShader = p_172782_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_end_portal", DefaultVertexFormat.POSITION), p_172778_ -> {
                rendertypeEndPortalShader = p_172778_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_end_gateway", DefaultVertexFormat.POSITION), p_172774_ -> {
                rendertypeEndGatewayShader = p_172774_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_clouds", DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL), p_323061_ -> {
                rendertypeCloudsShader = p_323061_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_lines", DefaultVertexFormat.POSITION_COLOR_NORMAL), p_172733_ -> {
                rendertypeLinesShader = p_172733_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_crumbling", DefaultVertexFormat.BLOCK), p_234230_ -> {
                rendertypeCrumblingShader = p_234230_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_gui", DefaultVertexFormat.POSITION_COLOR), p_286148_ -> {
                rendertypeGuiShader = p_286148_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_gui_overlay", DefaultVertexFormat.POSITION_COLOR), p_286146_ -> {
                rendertypeGuiOverlayShader = p_286146_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_gui_text_highlight", DefaultVertexFormat.POSITION_COLOR), p_286145_ -> {
                rendertypeGuiTextHighlightShader = p_286145_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_gui_ghost_recipe_overlay", DefaultVertexFormat.POSITION_COLOR), p_286147_ -> {
                rendertypeGuiGhostRecipeOverlayShader = p_286147_;
            }));
            $$2.add(Pair.of((Object)new ShaderInstance(p_250719_, "rendertype_breeze_wind", DefaultVertexFormat.NEW_ENTITY), p_311462_ -> {
                rendertypeBreezeWindShader = p_311462_;
            }));
            this.loadBlurEffect(p_250719_);
        }
        catch (IOException $$3) {
            $$2.forEach(p_172729_ -> ((ShaderInstance)p_172729_.getFirst()).close());
            throw new RuntimeException("could not reload shaders", $$3);
        }
        this.shutdownShaders();
        $$2.forEach(p_234225_ -> {
            ShaderInstance $$1 = (ShaderInstance)p_234225_.getFirst();
            this.shaders.put($$1.getName(), $$1);
            ((Consumer)p_234225_.getSecond()).accept($$1);
        });
    }

    private void shutdownShaders() {
        RenderSystem.assertOnRenderThread();
        this.shaders.values().forEach(ShaderInstance::close);
        this.shaders.clear();
    }

    @Nullable
    public ShaderInstance getShader(@Nullable String p_172735_) {
        if (p_172735_ == null) {
            return null;
        }
        return this.shaders.get(p_172735_);
    }

    public void tick() {
        this.tickFov();
        this.lightTexture.tick();
        if (this.minecraft.getCameraEntity() == null) {
            this.minecraft.setCameraEntity(this.minecraft.player);
        }
        this.mainCamera.tick();
        this.itemInHandRenderer.tick();
        ++this.confusionAnimationTick;
        if (!this.minecraft.level.tickRateManager().runsNormally()) {
            return;
        }
        this.minecraft.levelRenderer.tickRain(this.mainCamera);
        this.darkenWorldAmountO = this.darkenWorldAmount;
        if (this.minecraft.gui.getBossOverlay().shouldDarkenScreen()) {
            this.darkenWorldAmount += 0.05f;
            if (this.darkenWorldAmount > 1.0f) {
                this.darkenWorldAmount = 1.0f;
            }
        } else if (this.darkenWorldAmount > 0.0f) {
            this.darkenWorldAmount -= 0.0125f;
        }
        if (this.itemActivationTicks > 0) {
            --this.itemActivationTicks;
            if (this.itemActivationTicks == 0) {
                this.itemActivationItem = null;
            }
        }
    }

    @Nullable
    public PostChain currentEffect() {
        return this.postEffect;
    }

    public void resize(int p_109098_, int p_109099_) {
        if (this.postEffect != null) {
            this.postEffect.resize(p_109098_, p_109099_);
        }
        if (this.blurEffect != null) {
            this.blurEffect.resize(p_109098_, p_109099_);
        }
        this.minecraft.levelRenderer.resize(p_109098_, p_109099_);
    }

    public void pick(float p_109088_) {
        Entity entity;
        HitResult $$4;
        Entity $$1 = this.minecraft.getCameraEntity();
        if ($$1 == null) {
            return;
        }
        if (this.minecraft.level == null || this.minecraft.player == null) {
            return;
        }
        this.minecraft.getProfiler().push("pick");
        double $$2 = this.minecraft.player.blockInteractionRange();
        double $$3 = this.minecraft.player.entityInteractionRange();
        this.minecraft.hitResult = $$4 = this.pick($$1, $$2, $$3, p_109088_);
        if ($$4 instanceof EntityHitResult) {
            EntityHitResult $$5 = (EntityHitResult)$$4;
            entity = $$5.getEntity();
        } else {
            entity = null;
        }
        this.minecraft.crosshairPickEntity = entity;
        this.minecraft.getProfiler().pop();
    }

    private HitResult pick(Entity p_320077_, double p_320517_, double p_320380_, float p_319901_) {
        double $$4 = Math.max(p_320517_, p_320380_);
        double $$5 = Mth.square($$4);
        Vec3 $$6 = p_320077_.getEyePosition(p_319901_);
        HitResult $$7 = p_320077_.pick($$4, p_319901_, false);
        double $$8 = $$7.getLocation().distanceToSqr($$6);
        if ($$7.getType() != HitResult.Type.MISS) {
            $$5 = $$8;
            $$4 = Math.sqrt($$5);
        }
        Vec3 $$9 = p_320077_.getViewVector(p_319901_);
        Vec3 $$10 = $$6.add($$9.x * $$4, $$9.y * $$4, $$9.z * $$4);
        float $$11 = 1.0f;
        AABB $$12 = p_320077_.getBoundingBox().expandTowards($$9.scale($$4)).inflate(1.0, 1.0, 1.0);
        EntityHitResult $$13 = ProjectileUtil.getEntityHitResult(p_320077_, $$6, $$10, $$12, p_234237_ -> !p_234237_.isSpectator() && p_234237_.isPickable(), $$5);
        if ($$13 != null && $$13.getLocation().distanceToSqr($$6) < $$8) {
            return GameRenderer.filterHitResult($$13, $$6, p_320380_);
        }
        return GameRenderer.filterHitResult($$7, $$6, p_320517_);
    }

    private static HitResult filterHitResult(HitResult p_319875_, Vec3 p_320631_, double p_319892_) {
        Vec3 $$3 = p_319875_.getLocation();
        if (!$$3.closerThan(p_320631_, p_319892_)) {
            Vec3 $$4 = p_319875_.getLocation();
            Direction $$5 = Direction.getNearest($$4.x - p_320631_.x, $$4.y - p_320631_.y, $$4.z - p_320631_.z);
            return BlockHitResult.miss($$4, $$5, BlockPos.containing($$4));
        }
        return p_319875_;
    }

    private void tickFov() {
        float $$0 = 1.0f;
        Entity entity = this.minecraft.getCameraEntity();
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer $$1 = (AbstractClientPlayer)entity;
            $$0 = $$1.getFieldOfViewModifier();
        }
        this.oldFov = this.fov;
        this.fov += ($$0 - this.fov) * 0.5f;
        if (this.fov > 1.5f) {
            this.fov = 1.5f;
        }
        if (this.fov < 0.1f) {
            this.fov = 0.1f;
        }
    }

    private double getFov(Camera p_109142_, float p_109143_, boolean p_109144_) {
        FogType $$5;
        if (this.panoramicMode) {
            return 90.0;
        }
        double $$3 = 70.0;
        if (p_109144_) {
            $$3 = this.minecraft.options.fov().get().intValue();
            $$3 *= (double)Mth.lerp(p_109143_, this.oldFov, this.fov);
        }
        if (p_109142_.getEntity() instanceof LivingEntity && ((LivingEntity)p_109142_.getEntity()).isDeadOrDying()) {
            float $$4 = Math.min((float)((LivingEntity)p_109142_.getEntity()).deathTime + p_109143_, 20.0f);
            $$3 /= (double)((1.0f - 500.0f / ($$4 + 500.0f)) * 2.0f + 1.0f);
        }
        if (($$5 = p_109142_.getFluidInCamera()) == FogType.LAVA || $$5 == FogType.WATER) {
            $$3 *= Mth.lerp(this.minecraft.options.fovEffectScale().get(), 1.0, 0.8571428656578064);
        }
        return $$3;
    }

    private void bobHurt(PoseStack p_109118_, float p_109119_) {
        Entity entity = this.minecraft.getCameraEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity $$2 = (LivingEntity)entity;
            float $$3 = (float)$$2.hurtTime - p_109119_;
            if ($$2.isDeadOrDying()) {
                float $$4 = Math.min((float)$$2.deathTime + p_109119_, 20.0f);
                p_109118_.mulPose(Axis.ZP.rotationDegrees(40.0f - 8000.0f / ($$4 + 200.0f)));
            }
            if ($$3 < 0.0f) {
                return;
            }
            $$3 /= (float)$$2.hurtDuration;
            $$3 = Mth.sin($$3 * $$3 * $$3 * $$3 * (float)Math.PI);
            float $$5 = $$2.getHurtDir();
            p_109118_.mulPose(Axis.YP.rotationDegrees(-$$5));
            float $$6 = (float)((double)(-$$3) * 14.0 * this.minecraft.options.damageTiltStrength().get());
            p_109118_.mulPose(Axis.ZP.rotationDegrees($$6));
            p_109118_.mulPose(Axis.YP.rotationDegrees($$5));
        }
    }

    private void bobView(PoseStack p_109139_, float p_109140_) {
        if (!(this.minecraft.getCameraEntity() instanceof Player)) {
            return;
        }
        Player $$2 = (Player)this.minecraft.getCameraEntity();
        float $$3 = $$2.walkDist - $$2.walkDistO;
        float $$4 = -($$2.walkDist + $$3 * p_109140_);
        float $$5 = Mth.lerp(p_109140_, $$2.oBob, $$2.bob);
        p_109139_.translate(Mth.sin($$4 * (float)Math.PI) * $$5 * 0.5f, -Math.abs(Mth.cos($$4 * (float)Math.PI) * $$5), 0.0f);
        p_109139_.mulPose(Axis.ZP.rotationDegrees(Mth.sin($$4 * (float)Math.PI) * $$5 * 3.0f));
        p_109139_.mulPose(Axis.XP.rotationDegrees(Math.abs(Mth.cos($$4 * (float)Math.PI - 0.2f) * $$5) * 5.0f));
    }

    public void renderZoomed(float p_172719_, float p_172720_, float p_172721_) {
        this.zoom = p_172719_;
        this.zoomX = p_172720_;
        this.zoomY = p_172721_;
        this.setRenderBlockOutline(false);
        this.setRenderHand(false);
        this.renderLevel(DeltaTracker.ZERO);
        this.zoom = 1.0f;
    }

    private void renderItemInHand(Camera p_109122_, float p_109123_, Matrix4f p_333953_) {
        boolean $$5;
        if (this.panoramicMode) {
            return;
        }
        this.resetProjectionMatrix(this.getProjectionMatrix(this.getFov(p_109122_, p_109123_, false)));
        PoseStack $$3 = new PoseStack();
        $$3.pushPose();
        $$3.mulPose(p_333953_.invert(new Matrix4f()));
        Matrix4fStack $$4 = RenderSystem.getModelViewStack();
        $$4.pushMatrix().mul((Matrix4fc)p_333953_);
        RenderSystem.applyModelViewMatrix();
        this.bobHurt($$3, p_109123_);
        if (this.minecraft.options.bobView().get().booleanValue()) {
            this.bobView($$3, p_109123_);
        }
        boolean bl = $$5 = this.minecraft.getCameraEntity() instanceof LivingEntity && ((LivingEntity)this.minecraft.getCameraEntity()).isSleeping();
        if (this.minecraft.options.getCameraType().isFirstPerson() && !$$5 && !this.minecraft.options.hideGui && this.minecraft.gameMode.getPlayerMode() != GameType.SPECTATOR) {
            this.lightTexture.turnOnLightLayer();
            this.itemInHandRenderer.renderHandsWithItems(p_109123_, $$3, this.renderBuffers.bufferSource(), this.minecraft.player, this.minecraft.getEntityRenderDispatcher().getPackedLightCoords(this.minecraft.player, p_109123_));
            this.lightTexture.turnOffLightLayer();
        }
        $$4.popMatrix();
        RenderSystem.applyModelViewMatrix();
        $$3.popPose();
        if (this.minecraft.options.getCameraType().isFirstPerson() && !$$5) {
            ScreenEffectRenderer.renderScreenEffect(this.minecraft, $$3);
        }
    }

    public void resetProjectionMatrix(Matrix4f p_253668_) {
        RenderSystem.setProjectionMatrix(p_253668_, VertexSorting.DISTANCE_TO_ORIGIN);
    }

    public Matrix4f getProjectionMatrix(double p_254507_) {
        Matrix4f $$1 = new Matrix4f();
        if (this.zoom != 1.0f) {
            $$1.translate(this.zoomX, -this.zoomY, 0.0f);
            $$1.scale(this.zoom, this.zoom, 1.0f);
        }
        return $$1.perspective((float)(p_254507_ * 0.01745329238474369), (float)this.minecraft.getWindow().getWidth() / (float)this.minecraft.getWindow().getHeight(), 0.05f, this.getDepthFar());
    }

    public float getDepthFar() {
        return this.renderDistance * 4.0f;
    }

    public static float getNightVisionScale(LivingEntity p_109109_, float p_109110_) {
        MobEffectInstance $$2 = p_109109_.getEffect(MobEffects.NIGHT_VISION);
        if (!$$2.endsWithin(200)) {
            return 1.0f;
        }
        return 0.7f + Mth.sin(((float)$$2.getDuration() - p_109110_) * (float)Math.PI * 0.2f) * 0.3f;
    }

    public void render(DeltaTracker p_348648_, boolean p_109096_) {
        if (this.minecraft.isWindowActive() || !this.minecraft.options.pauseOnLostFocus || this.minecraft.options.touchscreen().get().booleanValue() && this.minecraft.mouseHandler.isRightPressed()) {
            this.lastActiveTime = Util.getMillis();
        } else if (Util.getMillis() - this.lastActiveTime > 500L) {
            this.minecraft.pauseGame(false);
        }
        if (this.minecraft.noRender) {
            return;
        }
        boolean $$2 = this.minecraft.isGameLoadFinished();
        int $$3 = (int)(this.minecraft.mouseHandler.xpos() * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth());
        int $$4 = (int)(this.minecraft.mouseHandler.ypos() * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight());
        RenderSystem.viewport(0, 0, this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight());
        if ($$2 && p_109096_ && this.minecraft.level != null) {
            this.minecraft.getProfiler().push("level");
            this.renderLevel(p_348648_);
            this.tryTakeScreenshotIfNeeded();
            this.minecraft.levelRenderer.doEntityOutline();
            if (this.postEffect != null && this.effectActive) {
                RenderSystem.disableBlend();
                RenderSystem.disableDepthTest();
                RenderSystem.resetTextureMatrix();
                this.postEffect.process(p_348648_.getGameTimeDeltaTicks());
            }
            this.minecraft.getMainRenderTarget().bindWrite(true);
        }
        Window $$5 = this.minecraft.getWindow();
        RenderSystem.clear(256, Minecraft.ON_OSX);
        Matrix4f $$6 = new Matrix4f().setOrtho(0.0f, (float)((double)$$5.getWidth() / $$5.getGuiScale()), (float)((double)$$5.getHeight() / $$5.getGuiScale()), 0.0f, 1000.0f, 21000.0f);
        RenderSystem.setProjectionMatrix($$6, VertexSorting.ORTHOGRAPHIC_Z);
        Matrix4fStack $$7 = RenderSystem.getModelViewStack();
        $$7.pushMatrix();
        $$7.translation(0.0f, 0.0f, -11000.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.setupFor3DItems();
        GuiGraphics $$8 = new GuiGraphics(this.minecraft, this.renderBuffers.bufferSource());
        if ($$2 && p_109096_ && this.minecraft.level != null) {
            this.minecraft.getProfiler().popPush("gui");
            if (this.minecraft.player != null) {
                float $$9 = Mth.lerp(p_348648_.getGameTimeDeltaPartialTick(false), this.minecraft.player.oSpinningEffectIntensity, this.minecraft.player.spinningEffectIntensity);
                float $$10 = this.minecraft.options.screenEffectScale().get().floatValue();
                if ($$9 > 0.0f && this.minecraft.player.hasEffect(MobEffects.CONFUSION) && $$10 < 1.0f) {
                    this.renderConfusionOverlay($$8, $$9 * (1.0f - $$10));
                }
            }
            if (!this.minecraft.options.hideGui) {
                this.renderItemActivationAnimation($$8, p_348648_.getGameTimeDeltaPartialTick(false));
            }
            this.minecraft.gui.render($$8, p_348648_);
            RenderSystem.clear(256, Minecraft.ON_OSX);
            this.minecraft.getProfiler().pop();
        }
        if (this.minecraft.getOverlay() != null) {
            try {
                this.minecraft.getOverlay().render($$8, $$3, $$4, p_348648_.getRealtimeDeltaTicks());
            }
            catch (Throwable $$11) {
                CrashReport $$12 = CrashReport.forThrowable($$11, "Rendering overlay");
                CrashReportCategory $$13 = $$12.addCategory("Overlay render details");
                $$13.setDetail("Overlay name", () -> this.minecraft.getOverlay().getClass().getCanonicalName());
                throw new ReportedException($$12);
            }
        }
        if ($$2 && this.minecraft.screen != null) {
            try {
                this.minecraft.screen.renderWithTooltip($$8, $$3, $$4, p_348648_.getRealtimeDeltaTicks());
            }
            catch (Throwable $$14) {
                CrashReport $$15 = CrashReport.forThrowable($$14, "Rendering screen");
                CrashReportCategory $$16 = $$15.addCategory("Screen render details");
                $$16.setDetail("Screen name", () -> this.minecraft.screen.getClass().getCanonicalName());
                $$16.setDetail("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", $$3, $$4, this.minecraft.mouseHandler.xpos(), this.minecraft.mouseHandler.ypos()));
                $$16.setDetail("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight(), this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight(), this.minecraft.getWindow().getGuiScale()));
                throw new ReportedException($$15);
            }
            try {
                if (this.minecraft.screen != null) {
                    this.minecraft.screen.handleDelayedNarration();
                }
            }
            catch (Throwable $$17) {
                CrashReport $$18 = CrashReport.forThrowable($$17, "Narrating screen");
                CrashReportCategory $$19 = $$18.addCategory("Screen details");
                $$19.setDetail("Screen name", () -> this.minecraft.screen.getClass().getCanonicalName());
                throw new ReportedException($$18);
            }
        }
        if ($$2 && p_109096_ && this.minecraft.level != null) {
            this.minecraft.gui.renderSavingIndicator($$8, p_348648_);
        }
        if ($$2) {
            this.minecraft.getProfiler().push("toasts");
            this.minecraft.getToasts().render($$8);
            this.minecraft.getProfiler().pop();
        }
        $$8.flush();
        $$7.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    private void tryTakeScreenshotIfNeeded() {
        if (this.hasWorldScreenshot || !this.minecraft.isLocalServer()) {
            return;
        }
        long $$0 = Util.getMillis();
        if ($$0 - this.lastScreenshotAttempt < 1000L) {
            return;
        }
        this.lastScreenshotAttempt = $$0;
        IntegratedServer $$1 = this.minecraft.getSingleplayerServer();
        if ($$1 == null || $$1.isStopped()) {
            return;
        }
        $$1.getWorldScreenshotFile().ifPresent(p_234239_ -> {
            if (Files.isRegularFile(p_234239_, new LinkOption[0])) {
                this.hasWorldScreenshot = true;
            } else {
                this.takeAutoScreenshot((Path)p_234239_);
            }
        });
    }

    private void takeAutoScreenshot(Path p_182643_) {
        if (this.minecraft.levelRenderer.countRenderedSections() > 10 && this.minecraft.levelRenderer.hasRenderedAllSections()) {
            NativeImage $$1 = Screenshot.takeScreenshot(this.minecraft.getMainRenderTarget());
            Util.ioPool().execute(() -> {
                int $$2 = $$1.getWidth();
                int $$3 = $$1.getHeight();
                int $$4 = 0;
                int $$5 = 0;
                if ($$2 > $$3) {
                    $$4 = ($$2 - $$3) / 2;
                    $$2 = $$3;
                } else {
                    $$5 = ($$3 - $$2) / 2;
                    $$3 = $$2;
                }
                try (NativeImage $$6 = new NativeImage(64, 64, false);){
                    $$1.resizeSubRectTo($$4, $$5, $$2, $$3, $$6);
                    $$6.writeToFile(p_182643_);
                }
                catch (IOException $$7) {
                    LOGGER.warn("Couldn't save auto screenshot", (Throwable)$$7);
                }
                finally {
                    $$1.close();
                }
            });
        }
    }

    private boolean shouldRenderBlockOutline() {
        boolean $$1;
        if (!this.renderBlockOutline) {
            return false;
        }
        Entity $$0 = this.minecraft.getCameraEntity();
        boolean bl = $$1 = $$0 instanceof Player && !this.minecraft.options.hideGui;
        if ($$1 && !((Player)$$0).getAbilities().mayBuild) {
            ItemStack $$2 = ((LivingEntity)$$0).getMainHandItem();
            HitResult $$3 = this.minecraft.hitResult;
            if ($$3 != null && $$3.getType() == HitResult.Type.BLOCK) {
                BlockPos $$4 = ((BlockHitResult)$$3).getBlockPos();
                BlockState $$5 = this.minecraft.level.getBlockState($$4);
                if (this.minecraft.gameMode.getPlayerMode() == GameType.SPECTATOR) {
                    $$1 = $$5.getMenuProvider(this.minecraft.level, $$4) != null;
                } else {
                    BlockInWorld $$6 = new BlockInWorld(this.minecraft.level, $$4, false);
                    Registry<Block> $$7 = this.minecraft.level.registryAccess().registryOrThrow(Registries.BLOCK);
                    $$1 = !$$2.isEmpty() && ($$2.canBreakBlockInAdventureMode($$6) || $$2.canPlaceOnBlockInAdventureMode($$6));
                }
            }
        }
        return $$1;
    }

    public void renderLevel(DeltaTracker p_348589_) {
        float $$1 = p_348589_.getGameTimeDeltaPartialTick(true);
        this.lightTexture.updateLightTexture($$1);
        if (this.minecraft.getCameraEntity() == null) {
            this.minecraft.setCameraEntity(this.minecraft.player);
        }
        this.pick($$1);
        this.minecraft.getProfiler().push("center");
        boolean $$2 = this.shouldRenderBlockOutline();
        this.minecraft.getProfiler().popPush("camera");
        Camera $$3 = this.mainCamera;
        Entity $$4 = this.minecraft.getCameraEntity() == null ? this.minecraft.player : this.minecraft.getCameraEntity();
        float $$5 = this.minecraft.level.tickRateManager().isEntityFrozen($$4) ? 1.0f : $$1;
        $$3.setup(this.minecraft.level, $$4, !this.minecraft.options.getCameraType().isFirstPerson(), this.minecraft.options.getCameraType().isMirrored(), $$5);
        this.renderDistance = this.minecraft.options.getEffectiveRenderDistance() * 16;
        double $$6 = this.getFov($$3, $$1, true);
        Matrix4f $$7 = this.getProjectionMatrix($$6);
        PoseStack $$8 = new PoseStack();
        this.bobHurt($$8, $$3.getPartialTickTime());
        if (this.minecraft.options.bobView().get().booleanValue()) {
            this.bobView($$8, $$3.getPartialTickTime());
        }
        $$7.mul((Matrix4fc)$$8.last().pose());
        float $$9 = this.minecraft.options.screenEffectScale().get().floatValue();
        float $$10 = Mth.lerp($$1, this.minecraft.player.oSpinningEffectIntensity, this.minecraft.player.spinningEffectIntensity) * ($$9 * $$9);
        if ($$10 > 0.0f) {
            int $$11 = this.minecraft.player.hasEffect(MobEffects.CONFUSION) ? 7 : 20;
            float $$12 = 5.0f / ($$10 * $$10 + 5.0f) - $$10 * 0.04f;
            $$12 *= $$12;
            Vector3f $$13 = new Vector3f(0.0f, Mth.SQRT_OF_TWO / 2.0f, Mth.SQRT_OF_TWO / 2.0f);
            float $$14 = ((float)this.confusionAnimationTick + $$1) * (float)$$11 * ((float)Math.PI / 180);
            $$7.rotate($$14, (Vector3fc)$$13);
            $$7.scale(1.0f / $$12, 1.0f, 1.0f);
            $$7.rotate(-$$14, (Vector3fc)$$13);
        }
        this.resetProjectionMatrix($$7);
        Quaternionf $$15 = $$3.rotation().conjugate(new Quaternionf());
        Matrix4f $$16 = new Matrix4f().rotation((Quaternionfc)$$15);
        this.minecraft.levelRenderer.prepareCullFrustum($$3.getPosition(), $$16, this.getProjectionMatrix(Math.max($$6, (double)this.minecraft.options.fov().get().intValue())));
        this.minecraft.levelRenderer.renderLevel(p_348589_, $$2, $$3, this, this.lightTexture, $$16, $$7);
        this.minecraft.getProfiler().popPush("hand");
        if (this.renderHand) {
            RenderSystem.clear(256, Minecraft.ON_OSX);
            this.renderItemInHand($$3, $$1, $$16);
        }
        this.minecraft.getProfiler().pop();
    }

    public void resetData() {
        this.itemActivationItem = null;
        this.mapRenderer.resetData();
        this.mainCamera.reset();
        this.hasWorldScreenshot = false;
    }

    public MapRenderer getMapRenderer() {
        return this.mapRenderer;
    }

    public void displayItemActivation(ItemStack p_109114_) {
        this.itemActivationItem = p_109114_;
        this.itemActivationTicks = 40;
        this.itemActivationOffX = this.random.nextFloat() * 2.0f - 1.0f;
        this.itemActivationOffY = this.random.nextFloat() * 2.0f - 1.0f;
    }

    private void renderItemActivationAnimation(GuiGraphics p_350868_, float p_109103_) {
        if (this.itemActivationItem == null || this.itemActivationTicks <= 0) {
            return;
        }
        int $$2 = 40 - this.itemActivationTicks;
        float $$3 = ((float)$$2 + p_109103_) / 40.0f;
        float $$4 = $$3 * $$3;
        float $$5 = $$3 * $$4;
        float $$6 = 10.25f * $$5 * $$4 - 24.95f * $$4 * $$4 + 25.5f * $$5 - 13.8f * $$4 + 4.0f * $$3;
        float $$7 = $$6 * (float)Math.PI;
        float $$8 = this.itemActivationOffX * (float)(p_350868_.guiWidth() / 4);
        float $$9 = this.itemActivationOffY * (float)(p_350868_.guiHeight() / 4);
        PoseStack $$10 = new PoseStack();
        $$10.pushPose();
        $$10.translate((float)(p_350868_.guiWidth() / 2) + $$8 * Mth.abs(Mth.sin($$7 * 2.0f)), (float)(p_350868_.guiHeight() / 2) + $$9 * Mth.abs(Mth.sin($$7 * 2.0f)), -50.0f);
        float $$11 = 50.0f + 175.0f * Mth.sin($$7);
        $$10.scale($$11, -$$11, $$11);
        $$10.mulPose(Axis.YP.rotationDegrees(900.0f * Mth.abs(Mth.sin($$7))));
        $$10.mulPose(Axis.XP.rotationDegrees(6.0f * Mth.cos($$3 * 8.0f)));
        $$10.mulPose(Axis.ZP.rotationDegrees(6.0f * Mth.cos($$3 * 8.0f)));
        p_350868_.drawManaged(() -> this.minecraft.getItemRenderer().renderStatic(this.itemActivationItem, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, $$10, p_350868_.bufferSource(), this.minecraft.level, 0));
        $$10.popPose();
    }

    private void renderConfusionOverlay(GuiGraphics p_282460_, float p_282656_) {
        int $$2 = p_282460_.guiWidth();
        int $$3 = p_282460_.guiHeight();
        p_282460_.pose().pushPose();
        float $$4 = Mth.lerp(p_282656_, 2.0f, 1.0f);
        p_282460_.pose().translate((float)$$2 / 2.0f, (float)$$3 / 2.0f, 0.0f);
        p_282460_.pose().scale($$4, $$4, $$4);
        p_282460_.pose().translate((float)(-$$2) / 2.0f, (float)(-$$3) / 2.0f, 0.0f);
        float $$5 = 0.2f * p_282656_;
        float $$6 = 0.4f * p_282656_;
        float $$7 = 0.2f * p_282656_;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ONE);
        p_282460_.setColor($$5, $$6, $$7, 1.0f);
        p_282460_.blit(NAUSEA_LOCATION, 0, 0, -90, 0.0f, 0.0f, $$2, $$3, $$2, $$3);
        p_282460_.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();
        p_282460_.pose().popPose();
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public float getDarkenWorldAmount(float p_109132_) {
        return Mth.lerp(p_109132_, this.darkenWorldAmountO, this.darkenWorldAmount);
    }

    public float getRenderDistance() {
        return this.renderDistance;
    }

    public Camera getMainCamera() {
        return this.mainCamera;
    }

    public LightTexture lightTexture() {
        return this.lightTexture;
    }

    public OverlayTexture overlayTexture() {
        return this.overlayTexture;
    }

    @Nullable
    public static ShaderInstance getPositionShader() {
        return positionShader;
    }

    @Nullable
    public static ShaderInstance getPositionColorShader() {
        return positionColorShader;
    }

    @Nullable
    public static ShaderInstance getPositionTexShader() {
        return positionTexShader;
    }

    @Nullable
    public static ShaderInstance getPositionTexColorShader() {
        return positionTexColorShader;
    }

    @Nullable
    public static ShaderInstance getParticleShader() {
        return particleShader;
    }

    @Nullable
    public static ShaderInstance getPositionColorLightmapShader() {
        return positionColorLightmapShader;
    }

    @Nullable
    public static ShaderInstance getPositionColorTexLightmapShader() {
        return positionColorTexLightmapShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeSolidShader() {
        return rendertypeSolidShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeCutoutMippedShader() {
        return rendertypeCutoutMippedShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeCutoutShader() {
        return rendertypeCutoutShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTranslucentShader() {
        return rendertypeTranslucentShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTranslucentMovingBlockShader() {
        return rendertypeTranslucentMovingBlockShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeArmorCutoutNoCullShader() {
        return rendertypeArmorCutoutNoCullShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntitySolidShader() {
        return rendertypeEntitySolidShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityCutoutShader() {
        return rendertypeEntityCutoutShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityCutoutNoCullShader() {
        return rendertypeEntityCutoutNoCullShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityCutoutNoCullZOffsetShader() {
        return rendertypeEntityCutoutNoCullZOffsetShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeItemEntityTranslucentCullShader() {
        return rendertypeItemEntityTranslucentCullShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityTranslucentCullShader() {
        return rendertypeEntityTranslucentCullShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityTranslucentShader() {
        return rendertypeEntityTranslucentShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityTranslucentEmissiveShader() {
        return rendertypeEntityTranslucentEmissiveShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntitySmoothCutoutShader() {
        return rendertypeEntitySmoothCutoutShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeBeaconBeamShader() {
        return rendertypeBeaconBeamShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityDecalShader() {
        return rendertypeEntityDecalShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityNoOutlineShader() {
        return rendertypeEntityNoOutlineShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityShadowShader() {
        return rendertypeEntityShadowShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityAlphaShader() {
        return rendertypeEntityAlphaShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEyesShader() {
        return rendertypeEyesShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEnergySwirlShader() {
        return rendertypeEnergySwirlShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeBreezeWindShader() {
        return rendertypeBreezeWindShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeLeashShader() {
        return rendertypeLeashShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeWaterMaskShader() {
        return rendertypeWaterMaskShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeOutlineShader() {
        return rendertypeOutlineShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeArmorGlintShader() {
        return rendertypeArmorGlintShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeArmorEntityGlintShader() {
        return rendertypeArmorEntityGlintShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeGlintTranslucentShader() {
        return rendertypeGlintTranslucentShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeGlintShader() {
        return rendertypeGlintShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeGlintDirectShader() {
        return rendertypeGlintDirectShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityGlintShader() {
        return rendertypeEntityGlintShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEntityGlintDirectShader() {
        return rendertypeEntityGlintDirectShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTextShader() {
        return rendertypeTextShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTextBackgroundShader() {
        return rendertypeTextBackgroundShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTextIntensityShader() {
        return rendertypeTextIntensityShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTextSeeThroughShader() {
        return rendertypeTextSeeThroughShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTextBackgroundSeeThroughShader() {
        return rendertypeTextBackgroundSeeThroughShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTextIntensitySeeThroughShader() {
        return rendertypeTextIntensitySeeThroughShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeLightningShader() {
        return rendertypeLightningShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeTripwireShader() {
        return rendertypeTripwireShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEndPortalShader() {
        return rendertypeEndPortalShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeEndGatewayShader() {
        return rendertypeEndGatewayShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeCloudsShader() {
        return rendertypeCloudsShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeLinesShader() {
        return rendertypeLinesShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeCrumblingShader() {
        return rendertypeCrumblingShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeGuiShader() {
        return rendertypeGuiShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeGuiOverlayShader() {
        return rendertypeGuiOverlayShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeGuiTextHighlightShader() {
        return rendertypeGuiTextHighlightShader;
    }

    @Nullable
    public static ShaderInstance getRendertypeGuiGhostRecipeOverlayShader() {
        return rendertypeGuiGhostRecipeOverlayShader;
    }

    public record ResourceCache(ResourceProvider original, Map<ResourceLocation, Resource> cache) implements ResourceProvider
    {
        @Override
        public Optional<Resource> getResource(ResourceLocation p_251007_) {
            Resource $$1 = this.cache.get(p_251007_);
            if ($$1 != null) {
                return Optional.of($$1);
            }
            return this.original.getResource(p_251007_);
        }
    }
}

