/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.AllMissingGlyphProvider;
import net.minecraft.client.gui.font.FontOption;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class FontManager
implements PreparableReloadListener,
AutoCloseable {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String FONTS_PATH = "fonts.json";
    public static final ResourceLocation MISSING_FONT = ResourceLocation.withDefaultNamespace("missing");
    private static final FileToIdConverter FONT_DEFINITIONS = FileToIdConverter.json("font");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final FontSet missingFontSet;
    private final List<GlyphProvider> providersToClose = new ArrayList<GlyphProvider>();
    private final Map<ResourceLocation, FontSet> fontSets = new HashMap<ResourceLocation, FontSet>();
    private final TextureManager textureManager;
    @Nullable
    private volatile FontSet lastFontSetCache;

    public FontManager(TextureManager p_95005_) {
        this.textureManager = p_95005_;
        this.missingFontSet = Util.make(new FontSet(p_95005_, MISSING_FONT), p_325488_ -> p_325488_.reload(List.of(FontManager.createFallbackProvider()), Set.of()));
    }

    private static GlyphProvider.Conditional createFallbackProvider() {
        return new GlyphProvider.Conditional(new AllMissingGlyphProvider(), FontOption.Filter.ALWAYS_PASS);
    }

    @Override
    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier p_285160_, ResourceManager p_285231_, ProfilerFiller p_285232_, ProfilerFiller p_285262_, Executor p_284975_, Executor p_285218_) {
        p_285232_.startTick();
        p_285232_.endTick();
        return ((CompletableFuture)this.prepare(p_285231_, p_284975_).thenCompose(p_285160_::wait)).thenAcceptAsync(p_284609_ -> this.apply((Preparation)p_284609_, p_285262_), p_285218_);
    }

    private CompletableFuture<Preparation> prepare(ResourceManager p_285252_, Executor p_284969_) {
        ArrayList<CompletableFuture<UnresolvedBuilderBundle>> $$2 = new ArrayList<CompletableFuture<UnresolvedBuilderBundle>>();
        for (Map.Entry<ResourceLocation, List<Resource>> $$3 : FONT_DEFINITIONS.listMatchingResourceStacks(p_285252_).entrySet()) {
            ResourceLocation $$4 = FONT_DEFINITIONS.fileToId($$3.getKey());
            $$2.add(CompletableFuture.supplyAsync(() -> {
                List<Pair<BuilderId, GlyphProviderDefinition.Conditional>> $$4 = FontManager.loadResourceStack((List)$$3.getValue(), $$4);
                UnresolvedBuilderBundle $$5 = new UnresolvedBuilderBundle($$4);
                for (Pair<BuilderId, GlyphProviderDefinition.Conditional> $$6 : $$4) {
                    BuilderId $$7 = (BuilderId)$$6.getFirst();
                    FontOption.Filter $$8 = ((GlyphProviderDefinition.Conditional)$$6.getSecond()).filter();
                    ((GlyphProviderDefinition.Conditional)$$6.getSecond()).definition().unpack().ifLeft(p_325476_ -> {
                        CompletableFuture<Optional<GlyphProvider>> $$6 = this.safeLoad($$7, (GlyphProviderDefinition.Loader)p_325476_, p_285252_, p_284969_);
                        $$5.add($$7, $$8, $$6);
                    }).ifRight(p_325470_ -> $$5.add($$7, $$8, (GlyphProviderDefinition.Reference)p_325470_));
                }
                return $$5;
            }, p_284969_));
        }
        return Util.sequence($$2).thenCompose(p_341556_ -> {
            List $$2 = p_341556_.stream().flatMap(UnresolvedBuilderBundle::listBuilders).collect(Util.toMutableList());
            GlyphProvider.Conditional $$3 = FontManager.createFallbackProvider();
            $$2.add(CompletableFuture.completedFuture(Optional.of($$3.provider())));
            return Util.sequence($$2).thenCompose(p_284618_ -> {
                Map<ResourceLocation, List<GlyphProvider.Conditional>> $$4 = this.resolveProviders((List<UnresolvedBuilderBundle>)p_341556_);
                CompletableFuture[] $$5 = (CompletableFuture[])$$4.values().stream().map(p_284585_ -> CompletableFuture.runAsync(() -> this.finalizeProviderLoading((List<GlyphProvider.Conditional>)p_284585_, $$3), p_284969_)).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf($$5).thenApply(p_284595_ -> {
                    List<GlyphProvider> $$3 = p_284618_.stream().flatMap(Optional::stream).toList();
                    return new Preparation($$4, $$3);
                });
            });
        });
    }

    private CompletableFuture<Optional<GlyphProvider>> safeLoad(BuilderId p_285113_, GlyphProviderDefinition.Loader p_286561_, ResourceManager p_285424_, Executor p_285371_) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Optional.of(p_286561_.load(p_285424_));
            }
            catch (Exception $$3) {
                LOGGER.warn("Failed to load builder {}, rejecting", (Object)p_285113_, (Object)$$3);
                return Optional.empty();
            }
        }, p_285371_);
    }

    private Map<ResourceLocation, List<GlyphProvider.Conditional>> resolveProviders(List<UnresolvedBuilderBundle> p_285282_) {
        HashMap<ResourceLocation, List<GlyphProvider.Conditional>> $$1 = new HashMap<ResourceLocation, List<GlyphProvider.Conditional>>();
        DependencySorter<ResourceLocation, UnresolvedBuilderBundle> $$2 = new DependencySorter<ResourceLocation, UnresolvedBuilderBundle>();
        p_285282_.forEach(p_284626_ -> $$2.addEntry(p_284626_.fontId, (UnresolvedBuilderBundle)p_284626_));
        $$2.orderByDependencies((p_284620_, p_284621_) -> p_284621_.resolve($$1::get).ifPresent(p_284590_ -> $$1.put((ResourceLocation)p_284620_, (List<GlyphProvider.Conditional>)p_284590_)));
        return $$1;
    }

    private void finalizeProviderLoading(List<GlyphProvider.Conditional> p_285520_, GlyphProvider.Conditional p_326102_) {
        p_285520_.add(0, p_326102_);
        IntOpenHashSet $$2 = new IntOpenHashSet();
        for (GlyphProvider.Conditional $$3 : p_285520_) {
            $$2.addAll((IntCollection)$$3.provider().getSupportedGlyphs());
        }
        $$2.forEach(p_325466_ -> {
            GlyphProvider.Conditional $$2;
            if (p_325466_ == 32) {
                return;
            }
            Iterator iterator = Lists.reverse((List)p_285520_).iterator();
            while (iterator.hasNext() && ($$2 = (GlyphProvider.Conditional)iterator.next()).provider().getGlyph(p_325466_) == null) {
            }
        });
    }

    private static Set<FontOption> getFontOptions(Options p_326037_) {
        EnumSet<FontOption> $$1 = EnumSet.noneOf(FontOption.class);
        if (p_326037_.forceUnicodeFont().get().booleanValue()) {
            $$1.add(FontOption.UNIFORM);
        }
        if (p_326037_.japaneseGlyphVariants().get().booleanValue()) {
            $$1.add(FontOption.JAPANESE_VARIANTS);
        }
        return $$1;
    }

    private void apply(Preparation p_284939_, ProfilerFiller p_285407_) {
        p_285407_.startTick();
        p_285407_.push("closing");
        this.lastFontSetCache = null;
        this.fontSets.values().forEach(FontSet::close);
        this.fontSets.clear();
        this.providersToClose.forEach(GlyphProvider::close);
        this.providersToClose.clear();
        Set<FontOption> $$2 = FontManager.getFontOptions(Minecraft.getInstance().options);
        p_285407_.popPush("reloading");
        p_284939_.fontSets().forEach((p_325478_, p_325479_) -> {
            FontSet $$3 = new FontSet(this.textureManager, (ResourceLocation)p_325478_);
            $$3.reload(Lists.reverse((List)p_325479_), $$2);
            this.fontSets.put((ResourceLocation)p_325478_, $$3);
        });
        this.providersToClose.addAll(p_284939_.allProviders);
        p_285407_.pop();
        p_285407_.endTick();
        if (!this.fontSets.containsKey(Minecraft.DEFAULT_FONT)) {
            throw new IllegalStateException("Default font failed to load");
        }
    }

    public void updateOptions(Options p_326271_) {
        Set<FontOption> $$1 = FontManager.getFontOptions(p_326271_);
        for (FontSet $$2 : this.fontSets.values()) {
            $$2.reload($$1);
        }
    }

    private static List<Pair<BuilderId, GlyphProviderDefinition.Conditional>> loadResourceStack(List<Resource> p_284976_, ResourceLocation p_285272_) {
        ArrayList<Pair<BuilderId, GlyphProviderDefinition.Conditional>> $$2 = new ArrayList<Pair<BuilderId, GlyphProviderDefinition.Conditional>>();
        for (Resource $$3 : p_284976_) {
            try {
                BufferedReader $$4 = $$3.openAsReader();
                try {
                    JsonElement $$5 = (JsonElement)GSON.fromJson((Reader)$$4, JsonElement.class);
                    FontDefinitionFile $$6 = (FontDefinitionFile)FontDefinitionFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$5).getOrThrow(JsonParseException::new);
                    List<GlyphProviderDefinition.Conditional> $$7 = $$6.providers;
                    for (int $$8 = $$7.size() - 1; $$8 >= 0; --$$8) {
                        BuilderId $$9 = new BuilderId(p_285272_, $$3.sourcePackId(), $$8);
                        $$2.add((Pair<BuilderId, GlyphProviderDefinition.Conditional>)Pair.of((Object)$$9, (Object)$$7.get($$8)));
                    }
                }
                finally {
                    if ($$4 == null) continue;
                    ((Reader)$$4).close();
                }
            }
            catch (Exception $$10) {
                LOGGER.warn("Unable to load font '{}' in {} in resourcepack: '{}'", new Object[]{p_285272_, FONTS_PATH, $$3.sourcePackId(), $$10});
            }
        }
        return $$2;
    }

    public Font createFont() {
        return new Font(this::getFontSetCached, false);
    }

    public Font createFontFilterFishy() {
        return new Font(this::getFontSetCached, true);
    }

    private FontSet getFontSetRaw(ResourceLocation p_325954_) {
        return this.fontSets.getOrDefault(p_325954_, this.missingFontSet);
    }

    private FontSet getFontSetCached(ResourceLocation p_326503_) {
        FontSet $$2;
        FontSet $$1 = this.lastFontSetCache;
        if ($$1 != null && p_326503_.equals($$1.name())) {
            return $$1;
        }
        this.lastFontSetCache = $$2 = this.getFontSetRaw(p_326503_);
        return $$2;
    }

    @Override
    public void close() {
        this.fontSets.values().forEach(FontSet::close);
        this.providersToClose.forEach(GlyphProvider::close);
        this.missingFontSet.close();
    }

    record BuilderId(ResourceLocation fontId, String pack, int index) {
        @Override
        public String toString() {
            return "(" + String.valueOf(this.fontId) + ": builder #" + this.index + " from pack " + this.pack + ")";
        }
    }

    record Preparation(Map<ResourceLocation, List<GlyphProvider.Conditional>> fontSets, List<GlyphProvider> allProviders) {
    }

    record FontDefinitionFile(List<GlyphProviderDefinition.Conditional> providers) {
        public static final Codec<FontDefinitionFile> CODEC = RecordCodecBuilder.create(p_325493_ -> p_325493_.group((App)GlyphProviderDefinition.Conditional.CODEC.listOf().fieldOf("providers").forGetter(FontDefinitionFile::providers)).apply((Applicative)p_325493_, FontDefinitionFile::new));
    }

    record UnresolvedBuilderBundle(ResourceLocation fontId, List<BuilderResult> builders, Set<ResourceLocation> dependencies) implements DependencySorter.Entry<ResourceLocation>
    {
        public UnresolvedBuilderBundle(ResourceLocation p_284984_) {
            this(p_284984_, new ArrayList<BuilderResult>(), new HashSet<ResourceLocation>());
        }

        public void add(BuilderId p_286837_, FontOption.Filter p_326179_, GlyphProviderDefinition.Reference p_286500_) {
            this.builders.add(new BuilderResult(p_286837_, p_326179_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.right((Object)p_286500_.id())));
            this.dependencies.add(p_286500_.id());
        }

        public void add(BuilderId p_284935_, FontOption.Filter p_326423_, CompletableFuture<Optional<GlyphProvider>> p_284966_) {
            this.builders.add(new BuilderResult(p_284935_, p_326423_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.left(p_284966_)));
        }

        private Stream<CompletableFuture<Optional<GlyphProvider>>> listBuilders() {
            return this.builders.stream().flatMap(p_285041_ -> p_285041_.result.left().stream());
        }

        public Optional<List<GlyphProvider.Conditional>> resolve(Function<ResourceLocation, List<GlyphProvider.Conditional>> p_285118_) {
            ArrayList $$1 = new ArrayList();
            for (BuilderResult $$2 : this.builders) {
                Optional<List<GlyphProvider.Conditional>> $$3 = $$2.resolve(p_285118_);
                if ($$3.isPresent()) {
                    $$1.addAll($$3.get());
                    continue;
                }
                return Optional.empty();
            }
            return Optional.of($$1);
        }

        @Override
        public void visitRequiredDependencies(Consumer<ResourceLocation> p_285391_) {
            this.dependencies.forEach(p_285391_);
        }

        @Override
        public void visitOptionalDependencies(Consumer<ResourceLocation> p_285405_) {
        }
    }

    record BuilderResult(BuilderId id, FontOption.Filter filter, Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation> result) {
        public Optional<List<GlyphProvider.Conditional>> resolve(Function<ResourceLocation, List<GlyphProvider.Conditional>> p_284942_) {
            return (Optional)this.result.map(p_325492_ -> ((Optional)p_325492_.join()).map(p_325491_ -> List.of(new GlyphProvider.Conditional((GlyphProvider)p_325491_, this.filter))), p_325490_ -> {
                List $$2 = (List)p_284942_.apply((ResourceLocation)p_325490_);
                if ($$2 == null) {
                    LOGGER.warn("Can't find font {} referenced by builder {}, either because it's missing, failed to load or is part of loading cycle", p_325490_, (Object)this.id);
                    return Optional.empty();
                }
                return Optional.of($$2.stream().map(this::mergeFilters).toList());
            });
        }

        private GlyphProvider.Conditional mergeFilters(GlyphProvider.Conditional p_326502_) {
            return new GlyphProvider.Conditional(p_326502_.provider(), this.filter.merge(p_326502_.filter()));
        }
    }
}

