/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraft.util.SmoothDouble;
import org.lwjgl.glfw.GLFWDropCallback;
import org.slf4j.Logger;

public class MouseHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Minecraft minecraft;
    private boolean isLeftPressed;
    private boolean isMiddlePressed;
    private boolean isRightPressed;
    private double xpos;
    private double ypos;
    private int fakeRightMouse;
    private int activeButton = -1;
    private boolean ignoreFirstMove = true;
    private int clickDepth;
    private double mousePressedTime;
    private final SmoothDouble smoothTurnX = new SmoothDouble();
    private final SmoothDouble smoothTurnY = new SmoothDouble();
    private double accumulatedDX;
    private double accumulatedDY;
    private double accumulatedScrollX;
    private double accumulatedScrollY;
    private double lastHandleMovementTime = Double.MIN_VALUE;
    private boolean mouseGrabbed;

    public MouseHandler(Minecraft p_91522_) {
        this.minecraft = p_91522_;
    }

    private void onPress(long p_91531_, int p_91532_, int p_91533_, int p_91534_) {
        boolean $$4;
        if (p_91531_ != this.minecraft.getWindow().getWindow()) {
            return;
        }
        if (this.minecraft.screen != null) {
            this.minecraft.setLastInputType(InputType.MOUSE);
        }
        boolean bl = $$4 = p_91533_ == 1;
        if (Minecraft.ON_OSX && p_91532_ == 0) {
            if ($$4) {
                if ((p_91534_ & 2) == 2) {
                    p_91532_ = 1;
                    ++this.fakeRightMouse;
                }
            } else if (this.fakeRightMouse > 0) {
                p_91532_ = 1;
                --this.fakeRightMouse;
            }
        }
        int $$5 = p_91532_;
        if ($$4) {
            if (this.minecraft.options.touchscreen().get().booleanValue() && this.clickDepth++ > 0) {
                return;
            }
            this.activeButton = $$5;
            this.mousePressedTime = Blaze3D.getTime();
        } else if (this.activeButton != -1) {
            if (this.minecraft.options.touchscreen().get().booleanValue() && --this.clickDepth > 0) {
                return;
            }
            this.activeButton = -1;
        }
        boolean[] $$6 = new boolean[]{false};
        if (this.minecraft.getOverlay() == null) {
            if (this.minecraft.screen == null) {
                if (!this.mouseGrabbed && $$4) {
                    this.grabMouse();
                }
            } else {
                double $$7 = this.xpos * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                double $$8 = this.ypos * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
                Screen $$9 = this.minecraft.screen;
                if ($$4) {
                    $$9.afterMouseAction();
                    Screen.wrapScreenError(() -> {
                        p_168085_[0] = $$9.mouseClicked($$7, $$8, $$5);
                    }, "mouseClicked event handler", $$9.getClass().getCanonicalName());
                } else {
                    Screen.wrapScreenError(() -> {
                        p_168079_[0] = $$9.mouseReleased($$7, $$8, $$5);
                    }, "mouseReleased event handler", $$9.getClass().getCanonicalName());
                }
            }
        }
        if (!$$6[0] && this.minecraft.screen == null && this.minecraft.getOverlay() == null) {
            if ($$5 == 0) {
                this.isLeftPressed = $$4;
            } else if ($$5 == 2) {
                this.isMiddlePressed = $$4;
            } else if ($$5 == 1) {
                this.isRightPressed = $$4;
            }
            KeyMapping.set(InputConstants.Type.MOUSE.getOrCreate($$5), $$4);
            if ($$4) {
                if (this.minecraft.player.isSpectator() && $$5 == 2) {
                    this.minecraft.gui.getSpectatorGui().onMouseMiddleClick();
                } else {
                    KeyMapping.click(InputConstants.Type.MOUSE.getOrCreate($$5));
                }
            }
        }
    }

    private void onScroll(long p_91527_, double p_91528_, double p_91529_) {
        if (p_91527_ == Minecraft.getInstance().getWindow().getWindow()) {
            boolean $$3 = this.minecraft.options.discreteMouseScroll().get();
            double $$4 = this.minecraft.options.mouseWheelSensitivity().get();
            double $$5 = ($$3 ? Math.signum(p_91528_) : p_91528_) * $$4;
            double $$6 = ($$3 ? Math.signum(p_91529_) : p_91529_) * $$4;
            if (this.minecraft.getOverlay() == null) {
                if (this.minecraft.screen != null) {
                    double $$7 = this.xpos * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                    double $$8 = this.ypos * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
                    this.minecraft.screen.mouseScrolled($$7, $$8, $$5, $$6);
                    this.minecraft.screen.afterMouseAction();
                } else if (this.minecraft.player != null) {
                    int $$11;
                    if (this.accumulatedScrollX != 0.0 && Math.signum($$5) != Math.signum(this.accumulatedScrollX)) {
                        this.accumulatedScrollX = 0.0;
                    }
                    if (this.accumulatedScrollY != 0.0 && Math.signum($$6) != Math.signum(this.accumulatedScrollY)) {
                        this.accumulatedScrollY = 0.0;
                    }
                    this.accumulatedScrollX += $$5;
                    this.accumulatedScrollY += $$6;
                    int $$9 = (int)this.accumulatedScrollX;
                    int $$10 = (int)this.accumulatedScrollY;
                    if ($$9 == 0 && $$10 == 0) {
                        return;
                    }
                    this.accumulatedScrollX -= (double)$$9;
                    this.accumulatedScrollY -= (double)$$10;
                    int n = $$11 = $$10 == 0 ? -$$9 : $$10;
                    if (this.minecraft.player.isSpectator()) {
                        if (this.minecraft.gui.getSpectatorGui().isMenuActive()) {
                            this.minecraft.gui.getSpectatorGui().onMouseScrolled(-$$11);
                        } else {
                            float $$12 = Mth.clamp(this.minecraft.player.getAbilities().getFlyingSpeed() + (float)$$10 * 0.005f, 0.0f, 0.2f);
                            this.minecraft.player.getAbilities().setFlyingSpeed($$12);
                        }
                    } else {
                        this.minecraft.player.getInventory().swapPaint($$11);
                    }
                }
            }
        }
    }

    private void onDrop(long p_91540_, List<Path> p_91541_, int p_350707_) {
        if (this.minecraft.screen != null) {
            this.minecraft.screen.onFilesDrop(p_91541_);
        }
        if (p_350707_ > 0) {
            SystemToast.onFileDropFailure(this.minecraft, p_350707_);
        }
    }

    public void setup(long p_91525_) {
        InputConstants.setupMouseCallbacks(p_91525_, (p_91591_, p_91592_, p_91593_) -> this.minecraft.execute(() -> this.onMove(p_91591_, p_91592_, p_91593_)), (p_91566_, p_91567_, p_91568_, p_91569_) -> this.minecraft.execute(() -> this.onPress(p_91566_, p_91567_, p_91568_, p_91569_)), (p_91576_, p_91577_, p_91578_) -> this.minecraft.execute(() -> this.onScroll(p_91576_, p_91577_, p_91578_)), (p_349790_, p_349791_, p_349792_) -> {
            ArrayList<Path> $$3 = new ArrayList<Path>(p_349791_);
            int $$4 = 0;
            for (int $$5 = 0; $$5 < p_349791_; ++$$5) {
                String $$6 = GLFWDropCallback.getName((long)p_349792_, (int)$$5);
                try {
                    $$3.add(Paths.get($$6, new String[0]));
                    continue;
                }
                catch (InvalidPathException $$7) {
                    ++$$4;
                    LOGGER.error("Failed to parse path '{}'", (Object)$$6, (Object)$$7);
                }
            }
            if (!$$3.isEmpty()) {
                int $$8 = $$4;
                this.minecraft.execute(() -> this.onDrop(p_349790_, $$3, $$8));
            }
        });
    }

    private void onMove(long p_91562_, double p_91563_, double p_91564_) {
        if (p_91562_ != Minecraft.getInstance().getWindow().getWindow()) {
            return;
        }
        if (this.ignoreFirstMove) {
            this.xpos = p_91563_;
            this.ypos = p_91564_;
            this.ignoreFirstMove = false;
            return;
        }
        if (this.minecraft.isWindowActive()) {
            this.accumulatedDX += p_91563_ - this.xpos;
            this.accumulatedDY += p_91564_ - this.ypos;
        }
        this.xpos = p_91563_;
        this.ypos = p_91564_;
    }

    public void handleAccumulatedMovement() {
        double $$0 = Blaze3D.getTime();
        double $$1 = $$0 - this.lastHandleMovementTime;
        this.lastHandleMovementTime = $$0;
        if (this.minecraft.isWindowActive()) {
            Screen $$2 = this.minecraft.screen;
            if ($$2 != null && this.minecraft.getOverlay() == null && (this.accumulatedDX != 0.0 || this.accumulatedDY != 0.0)) {
                double $$3 = this.xpos * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                double $$4 = this.ypos * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
                Screen.wrapScreenError(() -> $$2.mouseMoved($$3, $$4), "mouseMoved event handler", $$2.getClass().getCanonicalName());
                if (this.activeButton != -1 && this.mousePressedTime > 0.0) {
                    double $$5 = this.accumulatedDX * (double)this.minecraft.getWindow().getGuiScaledWidth() / (double)this.minecraft.getWindow().getScreenWidth();
                    double $$6 = this.accumulatedDY * (double)this.minecraft.getWindow().getGuiScaledHeight() / (double)this.minecraft.getWindow().getScreenHeight();
                    Screen.wrapScreenError(() -> $$2.mouseDragged($$3, $$4, this.activeButton, $$5, $$6), "mouseDragged event handler", $$2.getClass().getCanonicalName());
                }
                $$2.afterMouseMove();
            }
            if (this.isMouseGrabbed() && this.minecraft.player != null) {
                this.turnPlayer($$1);
            }
        }
        this.accumulatedDX = 0.0;
        this.accumulatedDY = 0.0;
    }

    private void turnPlayer(double p_316356_) {
        double $$11;
        double $$10;
        double $$1 = this.minecraft.options.sensitivity().get() * (double)0.6f + (double)0.2f;
        double $$2 = $$1 * $$1 * $$1;
        double $$3 = $$2 * 8.0;
        if (this.minecraft.options.smoothCamera) {
            double $$4 = this.smoothTurnX.getNewDeltaValue(this.accumulatedDX * $$3, p_316356_ * $$3);
            double $$5 = this.smoothTurnY.getNewDeltaValue(this.accumulatedDY * $$3, p_316356_ * $$3);
            double $$6 = $$4;
            double $$7 = $$5;
        } else if (this.minecraft.options.getCameraType().isFirstPerson() && this.minecraft.player.isScoping()) {
            this.smoothTurnX.reset();
            this.smoothTurnY.reset();
            double $$8 = this.accumulatedDX * $$2;
            double $$9 = this.accumulatedDY * $$2;
        } else {
            this.smoothTurnX.reset();
            this.smoothTurnY.reset();
            $$10 = this.accumulatedDX * $$3;
            $$11 = this.accumulatedDY * $$3;
        }
        int $$12 = 1;
        if (this.minecraft.options.invertYMouse().get().booleanValue()) {
            $$12 = -1;
        }
        this.minecraft.getTutorial().onMouse($$10, $$11);
        if (this.minecraft.player != null) {
            this.minecraft.player.turn($$10, $$11 * (double)$$12);
        }
    }

    public boolean isLeftPressed() {
        return this.isLeftPressed;
    }

    public boolean isMiddlePressed() {
        return this.isMiddlePressed;
    }

    public boolean isRightPressed() {
        return this.isRightPressed;
    }

    public double xpos() {
        return this.xpos;
    }

    public double ypos() {
        return this.ypos;
    }

    public void setIgnoreFirstMove() {
        this.ignoreFirstMove = true;
    }

    public boolean isMouseGrabbed() {
        return this.mouseGrabbed;
    }

    public void grabMouse() {
        if (!this.minecraft.isWindowActive()) {
            return;
        }
        if (this.mouseGrabbed) {
            return;
        }
        if (!Minecraft.ON_OSX) {
            KeyMapping.setAll();
        }
        this.mouseGrabbed = true;
        this.xpos = this.minecraft.getWindow().getScreenWidth() / 2;
        this.ypos = this.minecraft.getWindow().getScreenHeight() / 2;
        InputConstants.grabOrReleaseMouse(this.minecraft.getWindow().getWindow(), 212995, this.xpos, this.ypos);
        this.minecraft.setScreen(null);
        this.minecraft.missTime = 10000;
        this.ignoreFirstMove = true;
    }

    public void releaseMouse() {
        if (!this.mouseGrabbed) {
            return;
        }
        this.mouseGrabbed = false;
        this.xpos = this.minecraft.getWindow().getScreenWidth() / 2;
        this.ypos = this.minecraft.getWindow().getScreenHeight() / 2;
        InputConstants.grabOrReleaseMouse(this.minecraft.getWindow().getWindow(), 212993, this.xpos, this.ypos);
    }

    public void cursorEntered() {
        this.ignoreFirstMove = true;
    }
}

