/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.forgewrapper.installer;

import io.github.zekerzhayard.forgewrapper.installer.util.ModuleUtil;
import java.io.File;
import java.util.ArrayList;

public class Bootstrap {
    public static void bootstrap(String[] jvmArgs, String minecraftJar, String libraryDir) throws Throwable {
        String[] replacedJvmArgs = new String[jvmArgs.length];
        for (int i = 0; i < jvmArgs.length; ++i) {
            String[] arg = jvmArgs[i];
            replacedJvmArgs[i] = arg.replace("${classpath}", System.getProperty("java.class.path").replace(File.separator, "/")).replace("${classpath_separator}", File.pathSeparator).replace("${library_directory}", libraryDir).replace("${version_name}", minecraftJar.substring(0, minecraftJar.lastIndexOf(46)));
        }
        jvmArgs = replacedJvmArgs;
        StringBuilder newCP = new StringBuilder();
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (path.endsWith("NewLaunch.jar")) continue;
            newCP.append(path).append(File.pathSeparator);
        }
        System.setProperty("java.class.path", newCP.substring(0, newCP.length() - 1));
        String modulePath = null;
        ArrayList<String> addExports = new ArrayList<String>();
        ArrayList<String> addOpens = new ArrayList<String>();
        for (int i = 0; i < jvmArgs.length; ++i) {
            String arg = jvmArgs[i];
            if (arg.equals("-p") || arg.equals("--module-path")) {
                modulePath = jvmArgs[i + 1];
            } else if (arg.startsWith("--module-path=")) {
                modulePath = arg.split("=", 2)[1];
            }
            if (arg.equals("--add-exports")) {
                addExports.add(jvmArgs[i + 1]);
            } else if (arg.startsWith("--add-exports=")) {
                addExports.add(arg.split("=", 2)[1]);
            }
            if (arg.equals("--add-opens")) {
                addOpens.add(jvmArgs[i + 1]);
            } else if (arg.startsWith("--add-opens=")) {
                addOpens.add(arg.split("=", 2)[1]);
            }
            if (!arg.startsWith("-D")) continue;
            String[] prop = arg.substring(2).split("=", 2);
            if (prop[0].equals("ignoreList")) {
                System.setProperty(prop[0], prop[1] + ",NewLaunch.jar,ForgeWrapper-," + minecraftJar);
                continue;
            }
            System.setProperty(prop[0], prop[1]);
        }
        if (modulePath != null) {
            ModuleUtil.addModules(modulePath);
        }
        ModuleUtil.addExports(addExports);
        ModuleUtil.addOpens(addOpens);
    }
}

