/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.util;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.block.GraveBlock;
import com.b1n_ry.yigd.client.render.GraveBlockEntityRenderer;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.data.GraveyardData;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

public class YigdResourceHandler {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (elem, type, context) -> ResourceLocation.parse((String)elem.getAsString())).registerTypeAdapter(Vec3i.class, (elem, type, context) -> new Vec3i(elem.getAsJsonArray().get(0).getAsInt(), elem.getAsJsonArray().get(1).getAsInt(), elem.getAsJsonArray().get(2).getAsInt())).create();

    public static void serverDataEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new GraveServerModelLoader());
        event.addListener((PreparableReloadListener)new GraveyardDataLoader());
        event.addListener((PreparableReloadListener)new GraveAreaOverrideLoader());
    }

    public static void clientResourceEvent(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new GraveResourceLoader());
    }

    private static class GraveServerModelLoader
    implements ResourceManagerReloadListener {
        private GraveServerModelLoader() {
        }

        public void onResourceManagerReload(ResourceManager manager) {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"custom/grave_shape.json");
            List resources = manager.getResourceStack(resourceLocation);
            for (Resource resource : resources) {
                try {
                    InputStream is = resource.open();
                    try {
                        Yigd.LOGGER.info("Reloading grave shape (server)");
                        JsonObject resourceJson = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(is));
                        GraveBlock.reloadShapeFromJson(resourceJson);
                        Yigd.LOGGER.info("Grave model and shape reload successful (server)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from datapack `%s`".formatted(resourceLocation, resource.sourcePackId()), (Throwable)e);
                }
            }
        }
    }

    private static class GraveyardDataLoader
    implements ResourceManagerReloadListener {
        private GraveyardDataLoader() {
        }

        public void onResourceManagerReload(ResourceManager manager) {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"custom/graveyard.json");
            List resources = manager.getResourceStack(resourceLocation);
            for (Resource resource : resources) {
                try {
                    InputStream is = resource.open();
                    try {
                        Yigd.LOGGER.info("Reloading YIGD graveyard data (server)");
                        GraveComponent.graveyardData = (GraveyardData)GSON.fromJson((Reader)new InputStreamReader(is), GraveyardData.class);
                        GraveComponent.graveyardData.handlePoint2Point();
                        Yigd.LOGGER.info("Graveyard data successfully reloaded (server)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from datapack `%s`".formatted(resourceLocation, resource.sourcePackId()), (Throwable)e);
                }
            }
        }
    }

    private static class GraveAreaOverrideLoader
    implements ResourceManagerReloadListener {
        private GraveAreaOverrideLoader() {
        }

        public void onResourceManagerReload(ResourceManager manager) {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"custom/grave_areas.json");
            List resources = manager.getResourceStack(resourceLocation);
            for (Resource resource : resources) {
                try {
                    InputStream is = resource.open();
                    try {
                        Yigd.LOGGER.info("Reloading YIGD grave area overrides (server)");
                        GraveOverrideAreas.INSTANCE = (GraveOverrideAreas)GSON.fromJson((Reader)new InputStreamReader(is), GraveOverrideAreas.class);
                        Yigd.LOGGER.info("Grave area overrides successfully reloaded (server)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from datapack `%s`".formatted(resourceLocation, resource.sourcePackId()), (Throwable)e);
                }
            }
        }
    }

    public static class GraveResourceLoader
    implements ResourceManagerReloadListener {
        public void onResourceManagerReload(ResourceManager manager) {
            ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"yigd", (String)"models/block/grave.json");
            List resources = manager.getResourceStack(resourceLocation);
            for (Resource resource : resources) {
                try {
                    InputStream is = resource.open();
                    try {
                        Yigd.LOGGER.info("Reloading grave model (client)");
                        JsonObject resourceJson = (JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(is));
                        GraveBlockEntityRenderer.reloadModelFromJson(resourceJson);
                        GraveBlock.reloadShapeFromJson(resourceJson);
                        Yigd.LOGGER.info("Grave model and shape reload successful (client)");
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                catch (IOException | ClassCastException | NullPointerException e) {
                    Yigd.LOGGER.error("Could not load resource `%s` from resource pack `%s`".formatted(resourceLocation, resource.sourcePackId()), (Throwable)e);
                }
            }
        }
    }
}

