/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.events;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.RespawnComponent;
import com.b1n_ry.yigd.config.GraveConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.networking.packets.SyncConfigS2CPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class ServerEventHandler {
    @SubscribeEvent
    public void onEndOfTick(ServerTickEvent.Post event) {
        ArrayList<Runnable> methodsToRun = new ArrayList<Runnable>(Yigd.END_OF_TICK);
        Yigd.END_OF_TICK.clear();
        for (Runnable runnable : methodsToRun) {
            runnable.run();
        }
    }

    @SubscribeEvent
    public void endPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.onGround()) {
            player.setData(Yigd.LAST_GROUND_POS, (Object)player.position());
        }
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        DeathInfoManager.INSTANCE.clear();
        ServerLevel overworld = server.overworld();
        DeathInfoManager.INSTANCE = (DeathInfoManager)overworld.getDataStorage().computeIfAbsent(DeathInfoManager.getPersistentStateType(server), "yigd_data");
        DeathInfoManager.INSTANCE.setDirty();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void afterRespawn(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player newPlayer = event.getEntity();
        Player oldPlayer = event.getOriginal();
        if (newPlayer.level().isClientSide || oldPlayer.level().isClientSide) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new YigdEvents.BeforeSoulboundEvent((ServerPlayer)oldPlayer, (ServerPlayer)newPlayer));
        ResolvableProfile newProfile = new ResolvableProfile(newPlayer.getGameProfile());
        Optional<RespawnComponent> respawnComponent = DeathInfoManager.INSTANCE.getRespawnComponent(newProfile);
        respawnComponent.ifPresent(component -> component.apply((ServerPlayer)newPlayer));
        if (YigdConfig.getConfig().graveConfig.informGraveLocation && respawnComponent.isPresent() && respawnComponent.get().wasGraveGenerated()) {
            ArrayList<GraveComponent> graves = new ArrayList<GraveComponent>(DeathInfoManager.INSTANCE.getBackupData(newProfile));
            graves.removeIf(grave -> grave.getStatus() != GraveStatus.UNCLAIMED);
            if (!graves.isEmpty()) {
                GraveComponent latest = (GraveComponent)graves.getLast();
                BlockPos gravePos = latest.getPos();
                newPlayer.sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.grave_location", (Object[])new Object[]{gravePos.getX(), gravePos.getY(), gravePos.getZ(), latest.getWorldRegistryKey().location().toString()}));
            }
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        YigdConfig config = YigdConfig.getConfig();
        PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncConfigS2CPacket(config.graveConfig.retrieveMethods.onBreak, config.graveRendering.useGlowingEffect, config.graveRendering.glowingDistance, config.extraFeatures.deathSightEnchant.range), (CustomPacketPayload[])new CustomPacketPayload[0]);
        GraveConfig.GraveRobbing robConfig = config.graveConfig.graveRobbing;
        UUID joiningId = player2.getUUID();
        if (!Yigd.NOT_NOTIFIED_ROBBERIES.containsKey(joiningId)) {
            return;
        }
        if (robConfig.tellWhoRobbed) {
            List<String> robbedBy = Yigd.NOT_NOTIFIED_ROBBERIES.remove(joiningId);
            for (String robber : robbedBy) {
                player2.sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.inform_robbery.with_details", (Object[])new Object[]{robber}));
            }
        } else {
            Yigd.NOT_NOTIFIED_ROBBERIES.remove(joiningId);
            player2.sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.inform_robbery"));
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        YigdConfig config = YigdConfig.getConfig();
        if (!config.graveConfig.sellOutOfflinePeople) {
            return;
        }
        ResolvableProfile loggedOffProfile = new ResolvableProfile(player2.getGameProfile());
        List<GraveComponent> loggedOffGraves = DeathInfoManager.INSTANCE.getBackupData(loggedOffProfile);
        ArrayList<GraveComponent> loggedOffUnclaimed = new ArrayList<GraveComponent>(loggedOffGraves);
        loggedOffGraves.removeIf(c -> c.getStatus() == GraveStatus.UNCLAIMED);
        if (!loggedOffUnclaimed.isEmpty()) {
            GraveComponent component = (GraveComponent)loggedOffUnclaimed.getFirst();
            BlockPos lastGravePos = component.getPos();
            player2.server.sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.sellout_player", (Object[])new Object[]{loggedOffProfile.name().orElse("PLAYER_NOT_FOUND"), lastGravePos.getX(), lastGravePos.getY(), lastGravePos.getZ(), component.getWorldRegistryKey().location().toString()}));
        }
    }
}

