/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.components.EffectComponent;
import com.b1n_ry.yigd.components.ExpComponent;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.ExtraFeaturesConfig;
import com.b1n_ry.yigd.config.RespawnConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.item.DeathScrollItem;
import com.b1n_ry.yigd.item.GraveKeyItem;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RespawnComponent {
    @Nullable
    private InventoryComponent soulboundInventory;
    @Nullable
    private ExpComponent soulboundExp;
    private final EffectComponent respawnEffects;
    private boolean graveGenerated = false;

    public RespawnComponent(ServerPlayer player) {
        this.respawnEffects = new EffectComponent(player);
    }

    private RespawnComponent(@Nullable InventoryComponent soulboundInventory, @Nullable ExpComponent expComponent, EffectComponent effectComponent) {
        this.soulboundInventory = soulboundInventory;
        this.respawnEffects = effectComponent;
        this.soulboundExp = expComponent;
    }

    public void setSoulboundInventory(@NotNull InventoryComponent component) {
        this.soulboundInventory = component;
    }

    public void setSoulboundExp(@NotNull ExpComponent component) {
        this.soulboundExp = component;
    }

    @Nullable
    public ExpComponent getSoulboundExp() {
        return this.soulboundExp;
    }

    public void setGraveGenerated(boolean graveGenerated) {
        this.graveGenerated = graveGenerated;
    }

    public boolean wasGraveGenerated() {
        return this.graveGenerated;
    }

    public void primeForRespawn(ResolvableProfile profile) {
        DeathInfoManager.INSTANCE.addRespawnComponent(profile, this);
        DeathInfoManager.INSTANCE.setDirty();
    }

    public boolean isEmpty() {
        return !(this.soulboundInventory != null && !this.soulboundInventory.isEmpty() || this.soulboundExp != null && !this.soulboundExp.isEmpty());
    }

    public void apply(ServerPlayer player) {
        List<GraveComponent> playerGraves;
        if (this.soulboundInventory != null) {
            NonNullList<ItemStack> extraItems = this.soulboundInventory.pullBindingCurseItems(player);
            extraItems.addAll(this.soulboundInventory.applyToPlayer(player));
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            ServerLevel world = player.serverLevel();
            for (ItemStack stack : extraItems) {
                InventoryComponent.dropItemIfToBeDropped(stack, x, y, z, world);
            }
        }
        YigdConfig config = YigdConfig.getConfig();
        ExtraFeaturesConfig extraFeaturesConfig = config.extraFeatures;
        if (extraFeaturesConfig.deathScroll.enabled && extraFeaturesConfig.deathScroll.receiveOnRespawn) {
            ItemStack scroll = ((DeathScrollItem)((Object)Yigd.DEATH_SCROLL_ITEM.get())).getDefaultInstance();
            boolean turned = ((DeathScrollItem)((Object)Yigd.DEATH_SCROLL_ITEM.get())).bindStackToLatestDeath(player, scroll);
            if (turned) {
                player.addItem(scroll);
            }
        }
        if (extraFeaturesConfig.graveKeys.enabled && extraFeaturesConfig.graveKeys.receiveOnRespawn) {
            ItemStack key = ((GraveKeyItem)((Object)Yigd.GRAVE_KEY_ITEM.get())).getDefaultInstance();
            boolean turned = ((GraveKeyItem)((Object)Yigd.GRAVE_KEY_ITEM.get())).bindStackToLatestGrave((Player)player, key);
            if (turned) {
                player.addItem(key);
            }
        }
        if (extraFeaturesConfig.graveCompass.receiveOnRespawn && !(playerGraves = DeathInfoManager.INSTANCE.getBackupData(new ResolvableProfile(player.getGameProfile()))).isEmpty()) {
            GraveComponent latestGrave = playerGraves.getLast();
            GraveCompassHelper.giveCompass(player, latestGrave.getGraveId(), latestGrave.getPos(), latestGrave.getWorldRegistryKey());
        }
        for (RespawnConfig.ExtraItemDrop extraItemDrop : config.respawnConfig.extraItemDrops) {
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)extraItemDrop.itemId));
            ItemStack stack = new ItemStack((ItemLike)item, extraItemDrop.count);
            try {
                if (!extraItemDrop.itemNbt.isEmpty()) {
                    stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)NbtUtils.snbtToStructure((String)extraItemDrop.itemNbt)));
                }
            }
            catch (CommandSyntaxException e) {
                Yigd.LOGGER.error("Could not give an item with NBT to player on respawn. Invalid NBT. Falling back to item without NBT");
            }
            player.addItem(stack);
        }
        if (this.soulboundExp != null) {
            this.soulboundExp.applyToPlayer(player);
        }
        this.respawnEffects.applyToPlayer(player);
        DeathInfoManager.INSTANCE.removeRespawnComponent(new ResolvableProfile(player.getGameProfile()));
        DeathInfoManager.INSTANCE.setDirty();
    }

    public CompoundTag toNbt(HolderLookup.Provider registryLookup) {
        CompoundTag nbt = new CompoundTag();
        if (this.soulboundInventory != null) {
            nbt.put("inventory", (Tag)this.soulboundInventory.toNbt(registryLookup));
        }
        if (this.soulboundExp != null) {
            nbt.put("exp", (Tag)this.soulboundExp.toNbt());
        }
        nbt.put("effects", (Tag)this.respawnEffects.toNbt());
        return nbt;
    }

    public static RespawnComponent fromNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        InventoryComponent soulboundInventory = null;
        if (nbt.contains("inventory")) {
            CompoundTag inventoryNbt = nbt.getCompound("inventory");
            soulboundInventory = InventoryComponent.fromNbt(inventoryNbt, registryLookup);
        }
        ExpComponent expComponent = null;
        if (nbt.contains("exp")) {
            CompoundTag expNbt = nbt.getCompound("exp");
            expComponent = ExpComponent.fromNbt(expNbt);
        }
        CompoundTag effectsNbt = nbt.getCompound("effects");
        EffectComponent effectComponent = EffectComponent.fromNbt(effectsNbt);
        return new RespawnComponent(soulboundInventory, expComponent, effectComponent);
    }
}

