/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.Yigd;
import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.components.ExpComponent;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.components.RespawnComponent;
import com.b1n_ry.yigd.config.ClaimPriority;
import com.b1n_ry.yigd.config.DropType;
import com.b1n_ry.yigd.config.ExtraFeaturesConfig;
import com.b1n_ry.yigd.config.GraveConfig;
import com.b1n_ry.yigd.config.MapEntryConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.DeathInfoManager;
import com.b1n_ry.yigd.data.DirectionalPos;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.data.GraveyardData;
import com.b1n_ry.yigd.data.TimePoint;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.networking.LightGraveData;
import com.b1n_ry.yigd.util.DropRule;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.b1n_ry.yigd.util.GraveOverrideAreas;
import com.b1n_ry.yigd.util.YigdTags;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class GraveComponent {
    private final ResolvableProfile owner;
    private InventoryComponent inventoryComponent;
    private ExpComponent expComponent;
    @Nullable
    private ServerLevel world;
    private ResourceKey<Level> worldRegistryKey;
    private BlockPos pos;
    private final Component deathMessage;
    private final UUID graveId;
    private GraveStatus status;
    private boolean locked;
    private final TimePoint creationTime;
    private final UUID killerId;
    public static GraveyardData graveyardData = null;

    public GraveComponent(ResolvableProfile owner, InventoryComponent inventoryComponent, ExpComponent expComponent, ServerLevel world, Vec3 pos, Component deathMessage, UUID killerId) {
        this(owner, inventoryComponent, expComponent, world, BlockPos.containing((Position)pos), deathMessage, UUID.randomUUID(), GraveStatus.UNCLAIMED, true, new TimePoint(world), killerId);
    }

    public GraveComponent(ResolvableProfile owner, InventoryComponent inventoryComponent, ExpComponent expComponent, ServerLevel world, BlockPos pos, Component deathMessage, UUID graveId, GraveStatus status, boolean locked, TimePoint creationTime, UUID killerId) {
        this.owner = owner;
        this.inventoryComponent = inventoryComponent;
        this.expComponent = expComponent;
        this.world = world;
        this.worldRegistryKey = world.dimension();
        this.pos = pos;
        this.deathMessage = deathMessage;
        this.graveId = graveId;
        this.status = status;
        this.locked = locked;
        this.creationTime = creationTime;
        this.killerId = killerId;
    }

    public GraveComponent(ResolvableProfile owner, InventoryComponent inventoryComponent, ExpComponent expComponent, ResourceKey<Level> worldKey, BlockPos pos, Component deathMessage, UUID graveId, GraveStatus status, boolean locked, TimePoint creationTime, UUID killerId) {
        this.owner = owner;
        this.inventoryComponent = inventoryComponent;
        this.expComponent = expComponent;
        this.world = null;
        this.worldRegistryKey = worldKey;
        this.pos = pos;
        this.deathMessage = deathMessage;
        this.graveId = graveId;
        this.status = status;
        this.locked = locked;
        this.creationTime = creationTime;
        this.killerId = killerId;
    }

    public ResolvableProfile getOwner() {
        return this.owner;
    }

    public InventoryComponent getInventoryComponent() {
        return this.inventoryComponent;
    }

    public void setInventoryComponent(InventoryComponent inventoryComponent) {
        this.inventoryComponent = inventoryComponent;
        DeathInfoManager.INSTANCE.setDirty();
    }

    public ExpComponent getExpComponent() {
        return this.expComponent;
    }

    public void setExpComponent(ExpComponent expComponent) {
        this.expComponent = expComponent;
        DeathInfoManager.INSTANCE.setDirty();
    }

    @Nullable
    public ServerLevel getWorld() {
        return this.world;
    }

    public ResourceKey<Level> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Component getDeathMessage() {
        return this.deathMessage;
    }

    public UUID getGraveId() {
        return this.graveId;
    }

    public GraveStatus getStatus() {
        return this.status;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public TimePoint getCreationTime() {
        return this.creationTime;
    }

    public UUID getKillerId() {
        return this.killerId;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        DeathInfoManager.INSTANCE.setDirty();
    }

    public void setPos(BlockPos pos) {
        this.pos = pos;
        DeathInfoManager.INSTANCE.setDirty();
    }

    public void setWorld(ServerLevel world) {
        this.world = world;
        this.worldRegistryKey = world.dimension();
    }

    public void setStatus(GraveStatus status) {
        if (this.status == GraveStatus.UNCLAIMED && YigdConfig.getConfig().extraFeatures.graveCompass.pointToClosest != ExtraFeaturesConfig.GraveCompassConfig.CompassGraveTarget.DISABLED) {
            GraveCompassHelper.setClaimed(this.worldRegistryKey, this.pos);
        }
        this.status = status;
        DeathInfoManager.INSTANCE.setDirty();
    }

    public boolean isGraveEmpty() {
        return this.inventoryComponent.isGraveEmpty() && this.expComponent.isEmpty();
    }

    public boolean isEmpty() {
        return this.inventoryComponent.isEmpty() && this.expComponent.isEmpty();
    }

    public DirectionalPos findGravePos(Direction defaultDirection) {
        WorldBorder border;
        int topY;
        if (this.world == null) {
            Yigd.LOGGER.error("GraveComponent's associated world is null. Failed to find suitable position");
            return new DirectionalPos(this.pos, defaultDirection);
        }
        YigdConfig config = YigdConfig.getConfig();
        int y = this.pos.getY();
        int lowerAcceptableY = config.graveConfig.lowestGraveY + this.world.getMinBuildHeight();
        if (config.graveConfig.generateGraveInVoid && this.pos.getY() <= lowerAcceptableY) {
            y = lowerAcceptableY;
        }
        if (y > (topY = this.world.getMaxBuildHeight() - 1)) {
            y = topY;
        }
        int x = this.pos.getX();
        int z = this.pos.getZ();
        if (config.graveConfig.generateOnlyWithinBorder && !(border = this.world.getWorldBorder()).isWithinBounds((double)x, (double)z)) {
            x = (int)Math.max((double)x, border.getMinX());
            x = (int)Math.min((double)x, border.getMaxX());
            z = (int)Math.max((double)z, border.getMinZ());
            z = (int)Math.min((double)z, border.getMaxZ());
        }
        this.pos = new BlockPos(x, y, z);
        if (this.world.dimension().equals(Level.END) && Math.abs(this.pos.getX()) + Math.abs(this.pos.getZ()) < 25 && this.world.getBlockState(this.pos.below()).is(Blocks.BEDROCK)) {
            this.pos = this.pos.above();
        }
        DeathInfoManager.INSTANCE.setDirty();
        DirectionalPos graveyardPos = this.findPosInGraveyard(defaultDirection);
        if (graveyardPos != null) {
            return graveyardPos;
        }
        if (config.graveConfig.tryGenerateOnGround) {
            BlockPos pos = this.pos.below();
            while (pos.getY() >= this.world.getMinBuildHeight()) {
                if (!this.world.getBlockState(pos).is(YigdTags.REPLACE_SOFT_WHITELIST)) {
                    this.pos = pos.above();
                    break;
                }
                pos = pos.below();
            }
        }
        GraveConfig.Range generationMaxDistance = config.graveConfig.generationMaxDistance;
        for (int i = 0; i < 50; ++i) {
            for (BlockPos iPos : BlockPos.withinManhattan((BlockPos)this.pos, (int)generationMaxDistance.x, (int)generationMaxDistance.y, (int)generationMaxDistance.z)) {
                YigdEvents.GraveGenerationEvent event = (YigdEvents.GraveGenerationEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.GraveGenerationEvent(this.world, iPos, i));
                if (!event.canGenerate()) continue;
                this.pos = iPos;
                DeathInfoManager.INSTANCE.setDirty();
                return new DirectionalPos(iPos, defaultDirection);
            }
        }
        return new DirectionalPos(this.pos, defaultDirection);
    }

    private DirectionalPos findPosInGraveyard(Direction defaultDirection) {
        if (this.world == null) {
            return null;
        }
        if (graveyardData == null || GraveComponent.graveyardData.graveLocations.isEmpty()) {
            return null;
        }
        MinecraftServer server = this.world.getServer();
        ServerLevel graveyardWorld = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)GraveComponent.graveyardData.dimensionId));
        if (graveyardWorld == null) {
            graveyardWorld = server.overworld();
        }
        DirectionalPos closest = null;
        for (GraveyardData.GraveLocation location : GraveComponent.graveyardData.graveLocations) {
            Optional maybeName = this.owner.name();
            if (location.forPlayer != null && !location.forPlayer.equalsIgnoreCase(maybeName.orElse(""))) continue;
            Direction direction = location.direction != null ? location.direction : defaultDirection;
            DirectionalPos maybePos = new DirectionalPos(location.x, location.y, location.z, direction);
            if (GraveComponent.graveyardData.useClosest) {
                if (closest != null && !(maybePos.getSquaredDistance((Vec3i)this.pos) < closest.getSquaredDistance((Vec3i)this.pos))) continue;
                closest = maybePos;
                continue;
            }
            closest = maybePos;
            break;
        }
        if (closest != null) {
            this.world = graveyardWorld;
            this.pos = closest.pos();
            return closest;
        }
        return null;
    }

    public boolean tryPlaceGrave(BlockState state) {
        if (this.world == null) {
            Yigd.LOGGER.error("GraveComponent tried to place grave without knowing the ServerLevel");
            return false;
        }
        this.placeBlockUnder();
        return this.world.setBlockAndUpdate(this.pos, state);
    }

    public void placeAndLoad(Direction direction, DeathContext context, BlockPos pos, RespawnComponent respawnComponent) {
        YigdConfig config = YigdConfig.getConfig();
        ServerLevel world = context.world();
        Vec3 deathPos = context.deathPos();
        if (!config.graveConfig.storeItems) {
            this.inventoryComponent.dropGraveItems(world, deathPos);
        }
        if (!config.graveConfig.storeXp) {
            this.expComponent.dropAll(world, deathPos);
            this.getExpComponent().clear();
        }
        boolean waterlogged = world.getFluidState(pos).is((Fluid)Fluids.WATER);
        BlockState graveBlock = (BlockState)((BlockState)((Block)Yigd.GRAVE.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        Yigd.END_OF_TICK.add(() -> {
            BlockState previousState = world.getBlockState(pos);
            boolean placed = this.tryPlaceGrave(graveBlock);
            BlockPos placedPos = this.getPos();
            if (!placed) {
                Yigd.LOGGER.error("Failed to generate grave at X: {}, Y: {}, Z: {}, {}. Grave block placement failed", new Object[]{placedPos.getX(), placedPos.getY(), placedPos.getZ(), world.dimension().location()});
                Yigd.LOGGER.info("Dropping items on ground instead of in grave");
                context.player().sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.grave_generation_error"));
                this.getInventoryComponent().dropGraveItems(world, Vec3.atLowerCornerOf((Vec3i)placedPos));
                this.getExpComponent().dropAll(world, Vec3.atLowerCornerOf((Vec3i)placedPos));
                return;
            }
            respawnComponent.setGraveGenerated(true);
            DeathInfoManager.INSTANCE.setDirty();
            GraveBlockEntity be = (GraveBlockEntity)world.getBlockEntity(placedPos);
            if (be == null) {
                return;
            }
            be.setPreviousState(previousState);
            be.setComponent(this);
        });
    }

    public void generateOrDrop(Direction playerDirection, DeathContext context, RespawnComponent respawnComponent) {
        ServerLevel world = context.world();
        Vec3 pos = context.deathPos();
        YigdEvents.AllowGraveGenerationEvent event = (YigdEvents.AllowGraveGenerationEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.AllowGraveGenerationEvent(context, this));
        if (YigdConfig.getConfig().inventoryConfig.itemLoss.enabled) {
            this.inventoryComponent.applyLoss();
        }
        if (!event.isGenerationAllowed()) {
            this.inventoryComponent.dropGraveItems(world, pos);
            this.expComponent.dropAll(world, pos);
        } else {
            DirectionalPos dirGravePos = this.findGravePos(playerDirection);
            BlockPos gravePos = dirGravePos.pos();
            Direction direction = dirGravePos.dir();
            ServerLevel graveWorld = this.getWorld();
            assert (graveWorld != null);
            this.placeAndLoad(direction, context, gravePos, respawnComponent);
        }
    }

    private void placeBlockUnder() {
        String blockName;
        if (this.world == null) {
            Yigd.LOGGER.error("Tried to place block under a grave but world was null");
            return;
        }
        GraveConfig.BlockUnderGrave config = YigdConfig.getConfig().graveConfig.blockUnderGrave;
        if (!config.enabled) {
            return;
        }
        BlockState currentUnder = this.world.getBlockState(this.pos.below());
        YigdEvents.AllowBlockUnderGraveGenerationEvent event = (YigdEvents.AllowBlockUnderGraveGenerationEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.AllowBlockUnderGraveGenerationEvent(this, currentUnder));
        if (!event.isPlacementAllowed()) {
            return;
        }
        HashMap<String, String> blockInDimMap = new HashMap<String, String>();
        for (MapEntryConfig pair : config.blockInDimensions) {
            blockInDimMap.put(pair.key, pair.value);
        }
        String dimName = this.worldRegistryKey.location().toString();
        if (!blockInDimMap.containsKey(dimName)) {
            dimName = "misc";
        }
        if ((blockName = (String)blockInDimMap.get(dimName)) == null) {
            Yigd.LOGGER.warn("Didn't place supporting block under grave in %s, at %d, %d, %d. Couldn't find dimension key in config".formatted(dimName, this.pos.getX(), this.pos.getY(), this.pos.getZ()));
            return;
        }
        Block blockUnder = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockName));
        boolean placed = this.world.setBlockAndUpdate(this.pos.below(), blockUnder.defaultBlockState());
        if (!placed) {
            Yigd.LOGGER.warn("Didn't place supporting block under grave in %s, at %d, %d, %d. Block placement failed".formatted(dimName, this.pos.getX(), this.pos.getY(), this.pos.getZ()));
        }
    }

    public boolean replaceWithOld(BlockState newState) {
        if (this.world == null) {
            return false;
        }
        if (newState.is(YigdTags.REPLACE_GRAVE_BLACKLIST)) {
            return false;
        }
        boolean placed = this.world.setBlockAndUpdate(this.pos, newState);
        newState.getBlock().setPlacedBy((Level)this.world, this.pos, newState, null, ItemStack.EMPTY);
        return placed;
    }

    public void backUp() {
        DeathInfoManager.INSTANCE.addBackup(this.owner, this);
        DeathInfoManager.INSTANCE.setDirty();
    }

    public boolean hasExistedTicks(long time) {
        if (this.world == null) {
            return false;
        }
        return this.world.getGameTime() - this.creationTime.getTime() >= time;
    }

    public String getTimeUntilRobbable() {
        if (this.world == null) {
            return "0";
        }
        int tps = 20;
        GraveConfig.GraveRobbing robConfig = YigdConfig.getConfig().graveConfig.graveRobbing;
        long delay = robConfig.timeUnit.toSeconds(robConfig.afterTime) * 20L;
        long timePassed = (this.creationTime.getTime() - this.world.getGameTime() + delay) / 20L;
        long seconds = timePassed % 60L;
        long minutes = timePassed / 60L % 60L;
        long hours = timePassed / 3600L;
        return "%02d:%02d:%02d".formatted(hours, minutes, seconds);
    }

    public InteractionResult claim(ServerPlayer player, ServerLevel world, BlockState previousState, BlockPos pos, ItemStack tool) {
        YigdConfig config = YigdConfig.getConfig();
        if (this.status == GraveStatus.CLAIMED) {
            return InteractionResult.FAIL;
        }
        YigdEvents.GraveClaimEvent event = (YigdEvents.GraveClaimEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.GraveClaimEvent(player, world, pos, this, tool));
        if (!event.allowClaim()) {
            return InteractionResult.FAIL;
        }
        this.handleRandomSpawn(config.graveConfig.randomSpawn, world, player.getGameProfile());
        boolean thisIsARobbery = !player.getUUID().equals(this.owner.id().orElse(null));
        ItemStack graveItem = new ItemStack((ItemLike)Yigd.GRAVE.asItem());
        boolean addGraveItem = config.graveConfig.dropGraveBlock;
        if (config.graveConfig.dropOnRetrieve == DropType.IN_INVENTORY) {
            this.applyToPlayer(player, world, pos.getCenter(), !thisIsARobbery);
            if (addGraveItem) {
                player.addItem(graveItem);
            }
        } else if (config.graveConfig.dropOnRetrieve == DropType.ON_GROUND) {
            this.dropAll();
            if (this.world != null && addGraveItem) {
                InventoryComponent.dropItemIfToBeDropped(graveItem, this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.world);
            }
        }
        this.setStatus(GraveStatus.CLAIMED);
        if (!config.graveConfig.persistentGraves.enabled) {
            if (config.graveConfig.replaceOldWhenClaimed && previousState != null) {
                this.replaceWithOld(previousState);
            } else {
                world.removeBlock(pos, false);
            }
        } else {
            GraveBlockEntity be = (GraveBlockEntity)world.getBlockEntity(pos);
            if (be != null) {
                BlockState state = world.getBlockState(pos);
                be.setClaimed(true);
                be.setChanged();
                world.sendBlockUpdated(pos, state, state, 3);
            }
        }
        if (thisIsARobbery && config.graveConfig.graveRobbing.notifyWhenRobbed) {
            MinecraftServer server = world.getServer();
            String robberName = player.getGameProfile().getName();
            Optional ownerId = this.owner.id();
            ServerPlayer robbedPlayer = ownerId.map(value -> server.getPlayerList().getPlayer(value)).orElse(null);
            if (robbedPlayer != null) {
                if (config.graveConfig.graveRobbing.tellWhoRobbed) {
                    robbedPlayer.sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.inform_robbery.with_details", (Object[])new Object[]{player.getGameProfile().getName()}));
                } else {
                    robbedPlayer.sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.inform_robbery"));
                }
            } else {
                ownerId.ifPresent(value -> Yigd.NOT_NOTIFIED_ROBBERIES.computeIfAbsent((UUID)value, uuid -> new ArrayList()).add(robberName));
            }
        }
        Yigd.LOGGER.info("{} claimed a grave belonging to {} at {}, {}, {}, {}", new Object[]{player.getGameProfile().getName(), this.owner.name().orElse("PLAYER_NOT_FOUND"), this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.worldRegistryKey.location()});
        return InteractionResult.SUCCESS;
    }

    public boolean removeGraveBlock() {
        if (this.status == GraveStatus.UNCLAIMED) {
            this.setStatus(GraveStatus.DESTROYED);
        }
        if (this.world == null) {
            return false;
        }
        BlockEntity blockEntity = this.world.getBlockEntity(this.pos);
        if (!(blockEntity instanceof GraveBlockEntity)) {
            return false;
        }
        GraveBlockEntity grave = (GraveBlockEntity)blockEntity;
        BlockState previousState = grave.getPreviousState();
        if (previousState == null) {
            return this.world.removeBlock(this.pos, false);
        }
        return this.replaceWithOld(previousState);
    }

    private void handleRandomSpawn(GraveConfig.RandomSpawn config, ServerLevel world, GameProfile looter) {
        String res;
        Pattern pattern;
        Matcher matcher;
        Pattern nbtPattern;
        Matcher nbtMatcher;
        if (config.percentSpawnChance <= world.random.nextInt(100)) {
            return;
        }
        IntArrayTag ownerIdNbt = this.owner.id().map(NbtUtils::createUUID).orElse(new IntArrayTag(new int[0]));
        IntArrayTag looterIdNbt = NbtUtils.createUUID((UUID)looter.getId());
        String summonNbt = config.spawnNbt.replaceAll("\\$\\{owner\\.name}", this.owner.name().orElse("Steve")).replaceAll("\\$\\{owner\\.uuid}", ownerIdNbt.toString()).replaceAll("\\$\\{looter\\.name}", looter.getName()).replaceAll("\\$\\{looter\\.uuid}", looterIdNbt.toString());
        NonNullList<Tuple<ItemStack, DropRule>> items = this.inventoryComponent.getItems();
        while ((nbtMatcher = (nbtPattern = Pattern.compile("\\$\\{!?item\\[[0-9]+]}")).matcher(summonNbt)).find() && (matcher = (pattern = Pattern.compile("(?<=\\$\\{!?item\\[)[0-9]+(?=]})")).matcher(summonNbt)).find() && (res = matcher.group()).matches("[0-9]+")) {
            int itemNumber = Integer.parseInt(res);
            ItemStack item = (ItemStack)((Tuple)items.get(itemNumber)).getA();
            CompoundTag itemNbt = (CompoundTag)item.save((HolderLookup.Provider)world.registryAccess());
            boolean removeItem = summonNbt.contains("${!item[" + itemNumber + "]}");
            summonNbt = summonNbt.replaceAll("\\$\\{!?item\\[" + itemNumber + "]}", itemNbt.toString());
            if (removeItem) {
                items.set(itemNumber, (Object)new Tuple((Object)ItemStack.EMPTY, (Object)GraveOverrideAreas.INSTANCE.defaultDropRule));
            }
            if (nbtMatcher.find()) continue;
        }
        try {
            CompoundTag nbt = NbtUtils.snbtToStructure((String)summonNbt);
            nbt.putString("id", config.spawnEntity);
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)world, e -> {
                e.moveTo(this.pos, e.getYRot(), e.getXRot());
                return e;
            });
            if (entity == null) {
                return;
            }
            world.addFreshEntity(entity);
        }
        catch (CommandSyntaxException e2) {
            Yigd.LOGGER.error("Failed spawning entity on grave", (Throwable)e2);
        }
    }

    public void applyToPlayer(ServerPlayer player, ServerLevel world, Vec3 pos, boolean isGraveOwner) {
        this.applyToPlayer(player, world, pos, isGraveOwner, dropRule -> dropRule == DropRule.PUT_IN_GRAVE);
    }

    public void applyToPlayer(ServerPlayer player, ServerLevel world, Vec3 pos, boolean isGraveOwner, Predicate<DropRule> itemFilter) {
        YigdConfig config = YigdConfig.getConfig();
        this.expComponent.applyToPlayer(player);
        InventoryComponent currentPlayerInv = new InventoryComponent(player);
        InventoryComponent.clearPlayer(player);
        NonNullList extraItems = NonNullList.create();
        UUID playerId = player.getUUID();
        ClaimPriority claimPriority = Yigd.CLAIM_PRIORITIES.containsKey(playerId) ? Yigd.CLAIM_PRIORITIES.get(playerId) : config.graveConfig.claimPriority;
        ClaimPriority robPriority = Yigd.ROB_PRIORITIES.containsKey(playerId) ? Yigd.CLAIM_PRIORITIES.get(playerId) : config.graveConfig.graveRobbing.robPriority;
        ClaimPriority priority = isGraveOwner ? claimPriority : robPriority;
        InventoryComponent graveInv = this.inventoryComponent.filteredInv(itemFilter);
        if (config.graveConfig.treatBindingCurse) {
            extraItems.addAll(graveInv.pullBindingCurseItems(player));
        }
        if (priority == ClaimPriority.GRAVE) {
            extraItems.addAll(graveInv.merge(currentPlayerInv, player));
            extraItems.addAll(graveInv.applyToPlayer(player));
        } else {
            extraItems.addAll(currentPlayerInv.merge(graveInv, player));
            extraItems.addAll(currentPlayerInv.applyToPlayer(player));
        }
        for (ItemStack stack : extraItems) {
            if (player.addItem(stack)) continue;
            double x = pos.x();
            double y = pos.y();
            double z = pos.z();
            InventoryComponent.dropItemIfToBeDropped(stack, x, y, z, world);
        }
    }

    public void dropAll() {
        this.inventoryComponent.dropAll(this.world, this.pos.getCenter());
        this.expComponent.dropAll(this.world, this.pos.getCenter());
    }

    public void onDestroyed() {
        this.setStatus(GraveStatus.DESTROYED);
        if (this.world == null) {
            return;
        }
        PlayerList playerManager = this.world.getServer().getPlayerList();
        ServerPlayer owner = this.owner.id().map(arg_0 -> ((PlayerList)playerManager).getPlayer(arg_0)).orElse(null);
        if (owner == null) {
            return;
        }
        YigdConfig config = YigdConfig.getConfig();
        Yigd.LOGGER.info("Grave belonging to {} was detected destroyed at X: {}, Y: {}, Z: {} / {}", new Object[]{owner.getGameProfile().getName(), this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.worldRegistryKey.location()});
        if (config.graveConfig.notifyOwnerIfDestroyed) {
            owner.sendSystemMessage((Component)Component.translatable((String)"text.yigd.message.grave_destroyed"));
        }
        if (YigdConfig.getConfig().graveConfig.dropItemsIfDestroyed) {
            this.dropAll();
        }
    }

    public LightGraveData toLightData() {
        return new LightGraveData(this.inventoryComponent.graveSize(), this.pos, this.expComponent.getStoredXp(), this.worldRegistryKey, this.deathMessage, this.graveId, this.status);
    }

    public CompoundTag toNbt(HolderLookup.Provider lookupRegistry) {
        CompoundTag nbt = new CompoundTag();
        nbt.put("owner", (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.owner).getOrThrow());
        nbt.put("inventory", (Tag)this.inventoryComponent.toNbt(lookupRegistry));
        nbt.put("exp", (Tag)this.expComponent.toNbt());
        nbt.put("world", (Tag)this.getWorldRegistryKeyNbt(this.worldRegistryKey));
        nbt.put("pos", NbtUtils.writeBlockPos((BlockPos)this.pos));
        nbt.putString("deathMessage", Component.Serializer.toJson((Component)this.deathMessage, (HolderLookup.Provider)lookupRegistry));
        nbt.putUUID("graveId", this.graveId);
        nbt.putString("status", this.status.toString());
        nbt.putBoolean("locked", this.locked);
        nbt.put("creationTime", (Tag)this.creationTime.toNbt());
        if (this.killerId != null) {
            nbt.putUUID("killerId", this.killerId);
        }
        return nbt;
    }

    private CompoundTag getWorldRegistryKeyNbt(ResourceKey<?> key) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("registry", key.registry().toString());
        nbt.putString("value", key.location().toString());
        return nbt;
    }

    public static GraveComponent fromNbt(CompoundTag nbt, HolderLookup.Provider lookupRegistry, @Nullable MinecraftServer server) {
        ServerLevel world;
        UUID killerId;
        if (nbt == null) {
            return null;
        }
        ResolvableProfile owner = (ResolvableProfile)ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("owner")).getOrThrow();
        InventoryComponent inventoryComponent = InventoryComponent.fromNbt(nbt.getCompound("inventory"), lookupRegistry);
        ExpComponent expComponent = ExpComponent.fromNbt(nbt.getCompound("exp"));
        ResourceKey<Level> worldKey = GraveComponent.getRegistryKeyFromNbt(nbt.getCompound("world"));
        Optional pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"pos");
        MutableComponent deathMessage = Component.Serializer.fromJson((String)nbt.getString("deathMessage"), (HolderLookup.Provider)lookupRegistry);
        UUID graveId = nbt.getUUID("graveId");
        GraveStatus status = GraveStatus.valueOf(nbt.getString("status"));
        boolean locked = nbt.getBoolean("locked");
        TimePoint creationTime = TimePoint.fromNbt(nbt.getCompound("creationTime"));
        UUID uUID = killerId = nbt.contains("killerId") ? nbt.getUUID("killerId") : null;
        if (server != null && (world = server.getLevel(worldKey)) != null) {
            return new GraveComponent(owner, inventoryComponent, expComponent, world, pos.orElse(BlockPos.ZERO), (Component)deathMessage, graveId, status, locked, creationTime, killerId);
        }
        return new GraveComponent(owner, inventoryComponent, expComponent, worldKey, pos.orElse(BlockPos.ZERO), (Component)deathMessage, graveId, status, locked, creationTime, killerId);
    }

    private static ResourceKey<Level> getRegistryKeyFromNbt(CompoundTag nbt) {
        String registry = nbt.getString("registry");
        String value = nbt.getString("value");
        ResourceKey r = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.parse((String)registry));
        return ResourceKey.create((ResourceKey)r, (ResourceLocation)ResourceLocation.parse((String)value));
    }
}

