/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import java.util.Collection;
import java.util.function.Predicate;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class CosmeticArmorCompat
implements InvModCompat<NonNullList<Tuple<ItemStack, DropRule>>> {
    @Override
    public String getModName() {
        return "cosmeticarmor";
    }

    @Override
    public void clear(ServerPlayer player) {
        InventoryCosArmor inv = ModObjects.invMan.getCosArmorInventory(player.getUUID());
        inv.clearContent();
    }

    @Override
    public CompatComponent<NonNullList<Tuple<ItemStack, DropRule>>> readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        NonNullList<Tuple<ItemStack, DropRule>> items = InventoryComponent.listFromNbt(nbt, itemTag -> {
            DropRule dropRule = DropRule.valueOf(itemTag.getString("dropRule"));
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemTag).orElse(ItemStack.EMPTY);
            return new Tuple((Object)stack, (Object)dropRule);
        }, InventoryComponent.EMPTY_ITEM_PAIR);
        return new CosmeticArmorCompatComponent(items);
    }

    @Override
    public CompatComponent<NonNullList<Tuple<ItemStack, DropRule>>> getNewComponent(ServerPlayer player) {
        return new CosmeticArmorCompatComponent(player);
    }

    static class CosmeticArmorCompatComponent
    extends CompatComponent<NonNullList<Tuple<ItemStack, DropRule>>> {
        public CosmeticArmorCompatComponent(ServerPlayer player) {
            super(player);
        }

        public CosmeticArmorCompatComponent(NonNullList<Tuple<ItemStack, DropRule>> inventory) {
            super(inventory);
        }

        @Override
        public NonNullList<Tuple<ItemStack, DropRule>> getInventory(ServerPlayer player) {
            InventoryCosArmor inventory = ModObjects.invMan.getCosArmorInventory(player.getUUID());
            NonNullList list = NonNullList.create();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                list.add((Object)new Tuple((Object)stack, (Object)DropRule.PUT_IN_GRAVE));
            }
            return list;
        }

        @Override
        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            NonNullList extraItems = NonNullList.create();
            InventoryCosArmor cosArmor = ModObjects.invMan.getCosArmorInventory(player.getUUID());
            for (int i = 0; i < cosArmor.getContainerSize() && i < ((NonNullList)this.inventory).size(); ++i) {
                ItemStack stack = ((ItemStack)((Tuple)((NonNullList)this.inventory).get(i)).getA()).copy();
                if (cosArmor.getItem(i).isEmpty()) {
                    cosArmor.setItem(i, stack);
                    continue;
                }
                extraItems.add((Object)stack);
            }
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            for (Tuple tuple : (NonNullList)this.inventory) {
                DropRule dropRule;
                if (((ItemStack)tuple.getA()).isEmpty() || (dropRule = compatConfig.defaultCosmeticArmorDropRule) != DropRule.PUT_IN_GRAVE) continue;
                dropRule = ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent((ItemStack)tuple.getA(), -1, context, true))).getDropRule();
                tuple.setB((Object)dropRule);
            }
        }

        @Override
        public NonNullList<Tuple<ItemStack, DropRule>> getAsStackDropList() {
            return NonNullList.copyOf((Collection)((Collection)this.inventory));
        }

        @Override
        public void clear() {
            ((NonNullList)this.inventory).clear();
        }

        @Override
        public CompoundTag writeNbt(HolderLookup.Provider registries) {
            return InventoryComponent.listToNbt((NonNullList)this.inventory, tuple -> {
                CompoundTag itemTag = (CompoundTag)((ItemStack)tuple.getA()).save(registries);
                itemTag.putString("dropRule", ((DropRule)((Object)((Object)tuple.getB()))).toString());
                return itemTag;
            }, tuple -> ((ItemStack)tuple.getA()).isEmpty());
        }

        @Override
        public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
            for (Tuple tuple : (NonNullList)this.inventory) {
                ItemStack stack = (ItemStack)tuple.getA();
                if (!predicate.test(stack)) continue;
                stack.shrink(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public CompatComponent<NonNullList<Tuple<ItemStack, DropRule>>> filterInv(Predicate<DropRule> predicate) {
            NonNullList list = NonNullList.create();
            for (Tuple tuple : (NonNullList)this.inventory) {
                if (predicate.test((DropRule)((Object)tuple.getB()))) {
                    list.add((Object)tuple);
                    continue;
                }
                list.add(InventoryComponent.EMPTY_ITEM_PAIR);
            }
            return new CosmeticArmorCompatComponent((NonNullList<Tuple<ItemStack, DropRule>>)list);
        }

        @Override
        public NonNullList<ItemStack> merge(CompatComponent<?> mergingComponent, ServerPlayer merger) {
            NonNullList extraItems = NonNullList.create();
            NonNullList mergingItems = (NonNullList)mergingComponent.inventory;
            for (int i = 0; i < mergingItems.size(); ++i) {
                Tuple tuple = (Tuple)mergingItems.get(i);
                ItemStack mergingStack = (ItemStack)tuple.getA();
                if (i >= ((NonNullList)this.inventory).size()) {
                    extraItems.add((Object)mergingStack);
                    continue;
                }
                ItemStack thisStack = (ItemStack)((Tuple)((NonNullList)this.inventory).get(i)).getA();
                if (thisStack.isEmpty()) {
                    ((NonNullList)this.inventory).set(i, (Object)new Tuple((Object)mergingStack, (Object)((DropRule)((Object)tuple.getB()))));
                    continue;
                }
                extraItems.add((Object)mergingStack);
            }
            return extraItems;
        }
    }
}

